/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zclient.operations;

import asn1.ASN1BitString;
import asn1.ASN1GeneralString;
import asn1.ASN1Integer;
import asn1.ASN1Null;
import org.jafer.util.ConnectionException;
import org.jafer.util.PDUDriver;
import org.jafer.zclient.ClientSession;
import z3950.v3.IdAuthentication;
import z3950.v3.IdAuthentication_idPass;
import z3950.v3.InitializeRequest;
import z3950.v3.InitializeResponse;
import z3950.v3.InternationalString;
import z3950.v3.Options;
import z3950.v3.PDU;
import z3950.v3.ProtocolVersion;

public class Init {
    private ClientSession clientSession;
    private PDUDriver pduDriver;
    private String targetInfo;
    private int targetVersion;

    public Init(ClientSession clientSession) {
        this.clientSession = clientSession;
        this.pduDriver = clientSession.getPDUDriver();
    }

    public void init(String group, String username, String password) throws ConnectionException {
        InitializeRequest init = new InitializeRequest();
        boolean[] version = new boolean[]{true, true, true};
        init.s_protocolVersion = new ProtocolVersion();
        init.s_protocolVersion.value = new ASN1BitString(version);
        boolean[] options = new boolean[]{true, true, true};
        init.s_options = new Options();
        init.s_options.value = new ASN1BitString(options);
        init.s_preferredMessageSize = new ASN1Integer(131072);
        init.s_exceptionalRecordSize = new ASN1Integer(262144);
        init.s_implementationId = new InternationalString();
        init.s_implementationId.value = new ASN1GeneralString("1");
        init.s_implementationName = new InternationalString();
        init.s_implementationName.value = new ASN1GeneralString("KPSYS Verbis ZClient");
        init.s_implementationVersion = new InternationalString();
        init.s_implementationVersion.value = new ASN1GeneralString("2.0");
        init.s_idAuthentication = new IdAuthentication();
        if (username == null && password == null && group == null) {
            init.s_idAuthentication.c_anonymous = new ASN1Null();
        } else {
            init.s_idAuthentication.c_idPass = new IdAuthentication_idPass();
            if (username != null) {
                init.s_idAuthentication.c_idPass.s_userId = new InternationalString();
                init.s_idAuthentication.c_idPass.s_userId.value = new ASN1GeneralString(username);
            }
            if (password != null) {
                init.s_idAuthentication.c_idPass.s_password = new InternationalString();
                init.s_idAuthentication.c_idPass.s_password.value = new ASN1GeneralString(password);
            }
            if (group != null) {
                init.s_idAuthentication.c_idPass.s_groupId = new InternationalString();
                init.s_idAuthentication.c_idPass.s_groupId.value = new ASN1GeneralString(group);
            }
        }
        PDU pduOut = new PDU();
        pduOut.c_initRequest = init;
        this.pduDriver.sendPDU(pduOut);
        PDU pduIn = this.pduDriver.getPDU();
        InitializeResponse initResp = pduIn.c_initResponse;
        if (initResp.s_implementationName != null) {
            this.targetInfo = initResp.s_implementationName.toString();
            if (initResp.s_implementationVersion != null) {
                this.targetInfo = this.targetInfo + " - " + initResp.s_implementationVersion.toString();
            }
        } else {
            this.targetInfo = "server";
        }
        if (initResp.s_protocolVersion != null) {
            for (int n = 0; n < initResp.s_protocolVersion.value.get().length; ++n) {
                if (!initResp.s_protocolVersion.value.get()[n]) continue;
                this.targetVersion = n + 1;
            }
            this.targetInfo = this.targetInfo + " (Version " + this.targetVersion + ")";
        } else {
            this.targetInfo = this.targetInfo + " (Version unknown)";
        }
        if (initResp.s_userInformationField != null && initResp.s_userInformationField.c_singleASN1type != null) {
            this.targetInfo = this.targetInfo + "\n" + initResp.s_userInformationField.c_singleASN1type.toString();
        }
        if (initResp.s_otherInfo != null) {
            this.targetInfo = this.targetInfo + "\n" + initResp.s_otherInfo.toString();
        }
        this.targetInfo = this.targetInfo.replaceAll("\"", "");
        if (!initResp.s_result.get()) {
            throw new ConnectionException("Init failed");
        }
    }

    public String getTargetInfo() {
        return this.targetInfo;
    }

    public int getTargetVersion() {
        return this.targetVersion;
    }
}

