/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zclient.operations;

import asn1.ASN1Exception;
import asn1.ASN1GeneralString;
import asn1.ASN1Integer;
import asn1.ASN1ObjectIdentifier;
import java.util.Vector;
import org.jafer.record.DataObject;
import org.jafer.record.Diagnostic;
import org.jafer.util.ConnectionException;
import org.jafer.util.PDUDriver;
import org.jafer.zclient.ClientSession;
import org.jafer.zclient.operations.PresentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import z3950.v3.InternationalString;
import z3950.v3.NamePlusRecord;
import z3950.v3.PDU;
import z3950.v3.PresentRequest;
import z3950.v3.PresentResponse;
import z3950.v3.ResultSetId;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001\u0002\u0006\f\u0001QA\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001\b\u0005\tC\u0001\u0011\t\u0011)A\u0005;!)!\u0005\u0001C\u0001G!9q\u0005\u0001b\u0001\n\u0003A\u0003BB\u0018\u0001A\u0003%\u0011\u0006C\u00041\u0001\t\u0007I\u0011A\u0019\t\ra\u0002\u0001\u0015!\u00033\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u001d\ty\u0002\u0001C\u0005\u0003C\u0011q\u0001\u0015:fg\u0016tGO\u0003\u0002\r\u001b\u0005Qq\u000e]3sCRLwN\\:\u000b\u00059y\u0011a\u0002>dY&,g\u000e\u001e\u0006\u0003!E\tQA[1gKJT\u0011AE\u0001\u0004_J<7\u0001A\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0017!D2mS\u0016tGoU3tg&|g.F\u0001\u001e!\tqr$D\u0001\u000e\u0013\t\u0001SBA\u0007DY&,g\u000e^*fgNLwN\\\u0001\u000fG2LWM\u001c;TKN\u001c\u0018n\u001c8!\u0003\u0019a\u0014N\\5u}Q\u0011AE\n\t\u0003K\u0001i\u0011a\u0003\u0005\u00067\r\u0001\r!H\u0001\u0007Y><w-\u001a:\u0016\u0003%\u0002\"AK\u0017\u000e\u0003-R!\u0001L\t\u0002\u000bMdg\r\u000e6\n\u00059Z#A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u0013A$W\u000f\u0012:jm\u0016\u0014X#\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0005Uz\u0011\u0001B;uS2L!a\u000e\u001b\u0003\u0013A#U\u000b\u0012:jm\u0016\u0014\u0018A\u00039ek\u0012\u0013\u0018N^3sA\u00059\u0001O]3tK:$HCB\u001eI\u001b>#\u0016\rE\u0002=\u0001\nk\u0011!\u0010\u0006\u0003kyR\u0011aP\u0001\u0005U\u00064\u0018-\u0003\u0002B{\t1a+Z2u_J\u0004\"a\u0011$\u000e\u0003\u0011S!!R\b\u0002\rI,7m\u001c:e\u0013\t9EI\u0001\u0006ECR\fwJ\u00196fGRDQ!\u0013\u0005A\u0002)\u000bqA\u001c*fG>\u0014H\r\u0005\u0002\u0017\u0017&\u0011Aj\u0006\u0002\u0004\u0013:$\b\"\u0002(\t\u0001\u0004Q\u0015A\u00049pG\u0016$8*Z*uCj,g.\u001b\u0005\u0006!\"\u0001\r!U\u0001\ne\u0016\u001cwN\u001d3P\u0013\u0012\u00032A\u0006*K\u0013\t\u0019vCA\u0003BeJ\f\u0017\u0010C\u0003V\u0011\u0001\u0007a+A\u0003f'B,7\r\u0005\u0002X=:\u0011\u0001\f\u0018\t\u00033^i\u0011A\u0017\u0006\u00037N\ta\u0001\u0010:p_Rt\u0014BA/\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011q\f\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u;\u0002\"\u00022\t\u0001\u00041\u0016!\u0004:fgVdGoU3u\u001d\u0006lW\rK\u0002\tI*\u00042AF3h\u0013\t1wC\u0001\u0004uQJ|wo\u001d\t\u0003g!L!!\u001b\u001b\u0003'\r{gN\\3di&|g.\u0012=dKB$\u0018n\u001c82\u000by16.!\u00032\u000b\rb\u0007o`9\u0016\u00055tW#\u0001,\u0005\u000b=\u001c\"\u0019\u0001;\u0003\u0003QK!!\u001d:\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\t\u0019x#\u0001\u0004uQJ|wo]\t\u0003kb\u0004\"A\u0006<\n\u0005]<\"a\u0002(pi\"Lgn\u001a\t\u0003srt!A\u0006>\n\u0005m<\u0012a\u00029bG.\fw-Z\u0005\u0003{z\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005m<\u0012\u0007C\u0012\u0002\u0002\u0005\r\u0011QA:\u000f\u0007Y\t\u0019!\u0003\u0002t/E*!EF\f\u0002\b\t)1oY1mCF\u0012ae\u001a\u0015\u0006\u0011\u00055\u0011Q\u0003\t\u0005-\u0015\fy\u0001E\u0002&\u0003#I1!a\u0005\f\u0005A\u0001&/Z:f]R,\u0005pY3qi&|g.\r\u0004\u001f-\u0006]\u0011QD\u0019\u0007G1\u0004\u0018\u0011D92\u0011\r\n\t!a\u0001\u0002\u001cM\fTA\t\f\u0018\u0003\u000f\t4AJA\b\u0003M9W\r\u001e)sKN,g\u000e^#yG\u0016\u0004H/[8o))\ty!a\t\u0002(\u0005-\u0012q\u0006\u0005\u0007\u0003KI\u0001\u0019\u0001&\u0002\rM$\u0018\r^;t\u0011\u0019\tI#\u0003a\u0001\u0015\u0006IaNU3ukJtW\r\u001a\u0005\u0007\u0003[I\u0001\u0019\u0001,\u0002\r\u0011\u0014g*Y7f\u0011\u001d\t\t$\u0003a\u0001\u0003g\t\u0001B]3ta>t7/\u001a\t\u0005\u0003k\ty$\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\t18G\u0003\u0002\u0002>\u0005)!pM\u001d6a%!\u0011\u0011IA\u001c\u0005=\u0001&/Z:f]R\u0014Vm\u001d9p]N,\u0007")
public class Present {
    private final ClientSession clientSession;
    private final Logger logger;
    private final PDUDriver pduDriver;

    public ClientSession clientSession() {
        return this.clientSession;
    }

    public Logger logger() {
        return this.logger;
    }

    public PDUDriver pduDriver() {
        return this.pduDriver;
    }

    public Vector<DataObject> present(int nRecord, int pocetKeStazeni, int[] recordOID, String eSpec, String resultSetName) throws PresentException, ConnectionException {
        Object object;
        boolean limitTest;
        Vector<DataObject> dataObjects = new Vector<DataObject>();
        PresentRequest pr = new PresentRequest();
        pr.s_resultSetId = new ResultSetId();
        pr.s_resultSetId.value = new InternationalString();
        pr.s_resultSetId.value.value = new ASN1GeneralString(resultSetName);
        pr.s_resultSetStartPoint = new ASN1Integer(nRecord);
        pr.s_numberOfRecordsRequested = new ASN1Integer(pocetKeStazeni);
        pr.s_preferredRecordSyntax = new ASN1ObjectIdentifier(recordOID);
        PDU pduResponse = new PDU();
        pduResponse.c_presentRequest = pr;
        this.pduDriver().sendPDU(pduResponse);
        PDU pduRequest = this.pduDriver().getPDU();
        PresentResponse response = pduRequest.c_presentResponse;
        String dbName = "xxdefault";
        int pocetStazenych = 0;
        int status = 0;
        if (response.s_numberOfRecordsReturned != null) {
            pocetStazenych = response.s_numberOfRecordsReturned.get();
        }
        if (response.s_presentStatus.value != null) {
            status = response.s_presentStatus.value.get();
        }
        boolean bl = limitTest = pocetStazenych < pocetKeStazeni && pocetStazenych > 0;
        if (status == 0) {
            int limit;
            int n = 0;
            int n2 = limit = limitTest ? pocetStazenych : pocetKeStazeni;
            if (response.s_numberOfRecordsReturned.get() == 0) {
                throw new IllegalStateException("ZServer vratil prazdnou odpoved prestoze deklaroval, ze nalezl alespon jeden zaznam");
            }
            while (n < limit) {
                NamePlusRecord nr = response.s_records.c_responseRecords[n];
                if (nr.s_name != null) {
                    dbName = nr.s_name.value.value.get();
                }
                try {
                    Object object2;
                    if (nr.s_record.c_retrievalRecord != null) {
                        object2 = BoxesRunTime.boxToBoolean((boolean)dataObjects.add(new DataObject(dbName, nr.s_record.c_retrievalRecord.ber_encode())));
                    } else {
                        if (nr.s_record.c_surrogateDiagnostic != null) {
                            dataObjects.add(new DataObject(dbName, nr.s_record.c_surrogateDiagnostic.c_defaultFormat.ber_encode()));
                            String message = new StringBuilder(33).append("ClientSession Present (Record ").append(nRecord + n).append("): ").append(new Diagnostic(dbName, nr.s_record.c_surrogateDiagnostic.c_defaultFormat.ber_encode()).toString()).toString();
                            this.logger().warn(message);
                        }
                        object2 = BoxedUnit.UNIT;
                    }
                }
                catch (ASN1Exception e) {
                    String message = new StringBuilder(61).append("Record(s) not available: ASN1Exception processing record(s); ").append(e.toString()).toString();
                    throw new PresentException(status, pocetStazenych, message, (Throwable)e);
                }
                int cfr_ignored_0 = ++n - 1;
            }
        }
        if (status == 1 || status == 2 || status == 3 || status == 4 || limitTest) {
            int dalsiKVraceni = nRecord + pocetStazenych;
            int zbyvaVratit = pocetKeStazeni - pocetStazenych;
            int n = 0;
            while (n < pocetStazenych) {
                NamePlusRecord nr = response.s_records.c_responseRecords[n];
                if (nr.s_name != null) {
                    dbName = nr.s_name.value.value.get();
                }
                try {
                    Object object3;
                    if (nr.s_record.c_retrievalRecord != null) {
                        object3 = BoxesRunTime.boxToBoolean((boolean)dataObjects.add(new DataObject(dbName, nr.s_record.c_retrievalRecord.ber_encode())));
                    } else {
                        if (nr.s_record.c_surrogateDiagnostic != null) {
                            dataObjects.add(new DataObject(dbName, nr.s_record.c_surrogateDiagnostic.c_defaultFormat.ber_encode()));
                            String message = new StringBuilder(33).append("ClientSession Present (Record ").append(nRecord + n).append("): ").append(new Diagnostic(dbName, nr.s_record.c_surrogateDiagnostic.c_defaultFormat.ber_encode()).toString()).toString();
                            this.logger().warn(message);
                        }
                        object3 = BoxedUnit.UNIT;
                    }
                }
                catch (ASN1Exception e) {
                    String message = new StringBuilder(61).append("Record(s) not available: ASN1Exception processing record(s); ").append(e.toString()).toString();
                    throw new PresentException(status, pocetStazenych, message, (Throwable)e);
                }
                int cfr_ignored_1 = ++n - 1;
            }
            Vector vectorNext = this.present(dalsiKVraceni, zbyvaVratit, recordOID, eSpec, resultSetName);
            object = BoxesRunTime.boxToBoolean((boolean)dataObjects.addAll(vectorNext));
        } else {
            if (status > 0) {
                throw this.getPresentException(status, pocetStazenych, dbName, response);
            }
            object = BoxedUnit.UNIT;
        }
        return dataObjects;
    }

    private PresentException getPresentException(int status, int nReturned, String dbName, PresentResponse response) {
        String string;
        PresentException presentException = null;
        Diagnostic[] diagnostics = null;
        int n = status;
        switch (n) {
            case 1: {
                string = "Some records were not returned (request was terminated by access control)";
                break;
            }
            case 2: {
                string = "Some records were not returned (message size is too small)";
                break;
            }
            case 3: {
                string = "Some records were not returned (request was terminated by resource control, at origin request)";
                break;
            }
            case 4: {
                string = "Some records were not returned (request was terminated by resource control, by the target)";
                break;
            }
            case 5: {
                string = "no records were returned (one or more non-surrogate diagnostics were returned)";
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        String message = string;
        if (response.s_records.c_multipleNonSurDiagnostics != null) {
            diagnostics = new Diagnostic[response.s_records.c_multipleNonSurDiagnostics.length];
            int i = 0;
            while (i < response.s_records.c_multipleNonSurDiagnostics.length) {
                diagnostics[i] = new Diagnostic(dbName, response.s_records.c_multipleNonSurDiagnostics[i].c_defaultFormat.ber_encode());
                int cfr_ignored_0 = ++i - 1;
            }
        } else if (response.s_records.c_nonSurrogateDiagnostic != null) {
            diagnostics = new Diagnostic[]{new Diagnostic(dbName, response.s_records.c_nonSurrogateDiagnostic.ber_encode())};
        }
        presentException = diagnostics != null ? new PresentException(status, nReturned, diagnostics, message) : new PresentException(status, nReturned, message);
        return presentException;
    }

    public Present(ClientSession clientSession) {
        this.clientSession = clientSession;
        this.logger = LoggerFactory.getLogger((String)"cz.kpsys.zclient");
        this.pduDriver = clientSession.getPDUDriver();
    }
}

