/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import org.jafer.interfaces.Authenticate;
import org.jafer.interfaces.DatabeanFactory;
import org.jafer.zserver.Session;
import org.jafer.zserver.ZServerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZServer
extends ZServerThread
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ZServer.class);
    private int sessionTimeout;
    private int bindingPort;
    private ServerSocket serverSocket;
    private DatabeanFactory databeanFactory;
    private Authenticate authenticate;
    private String bindingAddress;
    private Thread thread;

    public ZServer() {
        super("server");
    }

    public void start() {
        try {
            logger.info("starting " + this.getName() + " bound to " + this.getBindingPort() + " on " + this.getBindingAddress() + " using " + this.getDatabeanFactory().getClass().getName());
            InetAddress address = InetAddress.getByName(this.getBindingAddress());
            InetSocketAddress socketaddress = new InetSocketAddress(address, this.getBindingPort());
            this.serverSocket = new ServerSocket();
            this.serverSocket.setSoTimeout(0);
            this.serverSocket.setReuseAddress(true);
            this.serverSocket.bind(socketaddress, 50);
            this.thread = new Thread((Runnable)this, "zserv3r thread");
            this.thread.setDaemon(true);
            this.thread.start();
        }
        catch (UnknownHostException ex) {
            logger.error(this.getName() + " UnknownHostException", (Throwable)ex);
        }
        catch (SocketException ex) {
            logger.error(this.getName() + " SocketException", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error(this.getName() + " IOException", (Throwable)ex);
        }
    }

    public void run() {
        this.setStopping(false);
        this.setStopped(false);
        this.setThreads(new Vector());
        this.setStartTime(System.currentTimeMillis() / 1000L);
        while (!this.isStopping()) {
            try {
                this.purgeThreads();
                Socket socket = this.serverSocket.accept();
                logger.debug(this.getName() + " starting new session...");
                this.startThread((Thread)new Session(socket, this.getSessionTimeout(), this.getDatabeanFactory(), this.getAuthenticate()));
            }
            catch (InterruptedIOException ex) {
                logger.info(this.getName() + " accept interrupted - continuing to wait for connections");
            }
            catch (SocketException ex) {
                logger.info(this.getName() + " socket closed");
            }
            catch (IOException ex) {
                logger.warn(this.getName() + " IOException (" + ex.toString() + ")");
                this.setStopping(true);
                this.close();
            }
        }
    }

    public void close() {
        if (!this.isStopped()) {
            logger.debug(this.getName() + " close...");
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException ex) {
                logger.debug(this.getName() + " socket already closed");
            }
            finally {
                this.setStopping(true);
                this.setStopped(true);
                this.serverSocket = null;
                this.setThreads(null);
                this.thread = null;
                logger.info(this.getName() + " stopped");
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    public void setDatabeanFactory(DatabeanFactory databeanFactory) {
        this.databeanFactory = databeanFactory;
    }

    public DatabeanFactory getDatabeanFactory() {
        return this.databeanFactory;
    }

    public void setAuthenticate(Authenticate authenticate) {
        this.authenticate = authenticate;
    }

    public Authenticate getAuthenticate() {
        return this.authenticate;
    }

    public void setBindingAddress(String bindingAddress) {
        this.bindingAddress = bindingAddress;
    }

    public String getBindingAddress() {
        return this.bindingAddress;
    }

    public void setBindingPort(int bindingPort) {
        this.bindingPort = bindingPort;
    }

    public int getBindingPort() {
        return this.bindingPort;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }
}

