/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zserver.authenticate;

import java.lang.invoke.StringConcatFactory;
import java.util.Hashtable;
import org.jafer.conf.Config;
import org.jafer.interfaces.Authenticate;
import org.jafer.zserver.authenticate.UserCredentials;

public class BasicAuthenticate
extends Authenticate {
    private static final String GROUP_DELIMITER = "//?//";
    private UserCredentials[] users;
    private Hashtable userLookup;
    private boolean anonymous = false;

    public boolean authenticate(String username, String groupname, String password, String clientIp) {
        if (this.isAnonymous()) {
            return true;
        }
        try {
            UserCredentials userCreds;
            if (this.userLookup.containsKey(StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"null//?//null"}))) {
                userCreds = (UserCredentials)this.userLookup.get(StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"null//?//null"}));
            } else {
                if (this.userLookup.containsKey(groupname + "//?//null")) {
                    userCreds = (UserCredentials)this.userLookup.get(groupname + "//?//null");
                } else if (this.userLookup.containsKey("null//?//" + username)) {
                    userCreds = (UserCredentials)this.userLookup.get("null//?//" + username);
                } else if (this.userLookup.containsKey(groupname + GROUP_DELIMITER + username)) {
                    userCreds = (UserCredentials)this.userLookup.get(groupname + GROUP_DELIMITER + username);
                } else {
                    return false;
                }
                if (userCreds.getPassword() != null && !userCreds.getPassword().equals(password)) {
                    return false;
                }
            }
            if (userCreds.getIpAddress() != null && userCreds.getIpAddressMask() != null) {
                int[] ipAddressMask = Config.convertSyntax((String)userCreds.getIpAddressMask());
                int[] ipAddress = Config.convertSyntax((String)userCreds.getIpAddress());
                int[] ip = Config.convertSyntax((String)clientIp);
                for (int i = 0; i < 4; ++i) {
                    int n = i;
                    ip[n] = ip[n] & ipAddressMask[i];
                    if (ip[n] == ipAddress[i]) continue;
                    return false;
                }
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public void setUsers(UserCredentials[] users) {
        this.users = users;
        this.userLookup = new Hashtable();
        for (int n = 0; n < this.users.length; ++n) {
            this.userLookup.put(this.users[n].getGroup() + GROUP_DELIMITER + this.users[n].getUsername(), this.users[n]);
        }
    }

    public UserCredentials[] getUsers() {
        return this.users;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }
}

