/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zserver.operations;

import asn1.ASN1BitString;
import asn1.ASN1Boolean;
import asn1.ASN1External;
import asn1.ASN1GeneralString;
import asn1.ASN1ObjectIdentifier;
import cz.kpsys.kpwin2.rest.KPWINServiceApplication;
import java.util.Calendar;
import org.jafer.conf.Config;
import org.jafer.interfaces.Databean;
import org.jafer.zserver.Session;
import org.jafer.zserver.operations.Operation;
import z3950.RS_SUTRS.SutrsRecord;
import z3950.v3.InitializeResponse;
import z3950.v3.InternationalString;
import z3950.v3.Options;
import z3950.v3.PDU;
import z3950.v3.ProtocolVersion;

public class Init
extends Operation {
    private final PDU pduRequest;
    private final PDU pduResponse;
    private String clientInfo;
    private int clientVersion;

    public Init(Session session, PDU pduRequest) {
        super(session, "init");
        this.pduRequest = pduRequest;
        this.pduResponse = new PDU();
    }

    public PDU runOp() throws Exception {
        this.pduResponse.c_initResponse = new InitializeResponse();
        this.pduResponse.c_initResponse.s_exceptionalRecordSize = this.pduRequest.c_initRequest.s_exceptionalRecordSize;
        this.pduResponse.c_initResponse.s_preferredMessageSize = this.pduRequest.c_initRequest.s_preferredMessageSize;
        this.pduResponse.c_initResponse.s_implementationId = new InternationalString();
        this.pduResponse.c_initResponse.s_implementationId.value = new ASN1GeneralString(this.getSession().getName());
        this.pduResponse.c_initResponse.s_implementationName = new InternationalString();
        this.pduResponse.c_initResponse.s_implementationName.value = new ASN1GeneralString("KPSYS ZServer");
        this.pduResponse.c_initResponse.s_implementationVersion = new InternationalString();
        String versionString = KPWINServiceApplication.versionString;
        this.pduResponse.c_initResponse.s_implementationVersion.value = new ASN1GeneralString(versionString == null ? "internal" : versionString);
        this.pduResponse.c_initResponse.s_referenceId = this.pduRequest.c_initRequest.s_referenceId;
        String userId = null;
        String groupId = null;
        String password = null;
        if (this.pduRequest.c_initRequest.s_idAuthentication != null && this.pduRequest.c_initRequest.s_idAuthentication.c_anonymous == null && this.pduRequest.c_initRequest.s_idAuthentication.c_idPass != null) {
            if (this.pduRequest.c_initRequest.s_idAuthentication.c_idPass.s_userId != null) {
                userId = this.pduRequest.c_initRequest.s_idAuthentication.c_idPass.s_userId.value.get();
            }
            if (this.pduRequest.c_initRequest.s_idAuthentication.c_idPass.s_groupId != null) {
                groupId = this.pduRequest.c_initRequest.s_idAuthentication.c_idPass.s_groupId.value.get();
            }
            if (this.pduRequest.c_initRequest.s_idAuthentication.c_idPass.s_password != null) {
                password = this.pduRequest.c_initRequest.s_idAuthentication.c_idPass.s_password.value.get();
            }
        }
        this.getSession().setAuthenticated(userId, groupId, password);
        this.pduResponse.c_initResponse.s_result = new ASN1Boolean(this.getSession().getAuthenticated());
        this.clientVersion = this.getClientVersion();
        this.clientInfo = this.getClientInfo();
        this.getSession().setClientVersion(this.clientVersion);
        this.getSession().setClientInfo(this.clientInfo);
        this.getSession().setPreferredMessageSize(this.pduRequest.c_initRequest.s_preferredMessageSize.get());
        this.getSession().setExceptionalRecordSize(this.pduRequest.c_initRequest.s_exceptionalRecordSize.get());
        SutrsRecord sutrs_record = new SutrsRecord();
        sutrs_record.value = new InternationalString();
        sutrs_record.value.value = this.getSession().getAuthenticated() ? new ASN1GeneralString("Java ZServer, KPSYS spol. s.r.o. (c) " + Calendar.getInstance().get(1)) : new ASN1GeneralString("Authentication failed, session terminated by target");
        this.pduResponse.c_initResponse.s_userInformationField = new ASN1External();
        this.pduResponse.c_initResponse.s_userInformationField.s_direct_reference = new ASN1ObjectIdentifier(Config.convertSyntax((String)Config.getRecordSyntaxFromName((String)"SUTRS")));
        this.pduResponse.c_initResponse.s_userInformationField.c_singleASN1type = sutrs_record;
        boolean[] version = new boolean[]{true, true, true};
        this.pduResponse.c_initResponse.s_protocolVersion = new ProtocolVersion();
        this.pduResponse.c_initResponse.s_protocolVersion.value = new ASN1BitString(version);
        boolean canSearch = false;
        boolean canPresent = false;
        boolean canScan = false;
        boolean canSort = false;
        Databean bean = this.getSession().getDatabean();
        Class<?> beanClass = bean.getClass();
        Class<?>[] interfaces = beanClass.getInterfaces();
        for (int n = 0; n < interfaces.length; ++n) {
            if (interfaces[n].getName().equals("org.jafer.interfaces.Search")) {
                canSearch = true;
                continue;
            }
            if (interfaces[n].getName().equals("org.jafer.interfaces.Present")) {
                canPresent = true;
                continue;
            }
            if (interfaces[n].getName().equals("org.jafer.interfaces.Scan")) {
                canScan = true;
                continue;
            }
            if (!interfaces[n].getName().equals("org.jafer.interfaces.Sort")) continue;
            canSort = true;
        }
        boolean[] options = new boolean[15];
        options[0] = this.pduRequest.c_initRequest.s_options.value.get().length > 0 ? canSearch & this.pduRequest.c_initRequest.s_options.value.get()[0] : false;
        options[1] = this.pduRequest.c_initRequest.s_options.value.get().length > 1 ? canPresent & this.pduRequest.c_initRequest.s_options.value.get()[1] : false;
        options[2] = this.pduRequest.c_initRequest.s_options.value.get().length > 2 ? this.pduRequest.c_initRequest.s_options.value.get()[2] : false;
        options[3] = false;
        options[4] = false;
        options[5] = false;
        options[6] = false;
        options[7] = this.pduRequest.c_initRequest.s_options.value.get().length > 7 ? canScan & this.pduRequest.c_initRequest.s_options.value.get()[7] : false;
        options[8] = this.pduRequest.c_initRequest.s_options.value.get().length > 8 ? canSort & this.pduRequest.c_initRequest.s_options.value.get()[8] : false;
        options[9] = false;
        options[10] = false;
        options[11] = false;
        options[12] = false;
        if (this.pduRequest.c_initRequest.s_options.value.get().length > 13) {
            options[13] = this.pduRequest.c_initRequest.s_options.value.get()[13];
            this.getSession().setConcurrent(this.pduRequest.c_initRequest.s_options.value.get()[13]);
        } else {
            options[13] = false;
        }
        if (this.pduRequest.c_initRequest.s_options.value.get().length > 14) {
            options[13] = this.pduRequest.c_initRequest.s_options.value.get()[14];
        } else {
            options[14] = false;
        }
        this.pduResponse.c_initResponse.s_options = new Options();
        this.pduResponse.c_initResponse.s_options.value = new ASN1BitString(options);
        return this.pduResponse;
    }

    private int getClientVersion() {
        int clientVersion = 0;
        if (this.pduRequest.c_initRequest.s_protocolVersion != null) {
            for (int n = 0; n < this.pduRequest.c_initRequest.s_protocolVersion.value.get().length; ++n) {
                if (!this.pduRequest.c_initRequest.s_protocolVersion.value.get()[n]) continue;
                clientVersion = n + 1;
            }
        }
        return clientVersion;
    }

    private String getClientInfo() {
        Object clientInfo = "Z39.50 client";
        if (this.pduRequest.c_initRequest.s_implementationName != null) {
            clientInfo = this.pduRequest.c_initRequest.s_implementationName.toString();
            if (this.pduRequest.c_initRequest.s_implementationVersion != null) {
                clientInfo = (String)clientInfo + " - " + this.pduRequest.c_initRequest.s_implementationVersion.toString();
            }
        }
        clientInfo = this.clientVersion > 0 ? (String)clientInfo + " (Version " + this.clientVersion + ")" : (String)clientInfo + " (Version unknown)";
        if (this.pduRequest.c_initRequest.s_userInformationField != null && this.pduRequest.c_initRequest.s_userInformationField.c_singleASN1type != null) {
            clientInfo = (String)clientInfo + "\n" + this.pduRequest.c_initRequest.s_userInformationField.c_singleASN1type.toString();
        }
        if (this.pduRequest.c_initRequest.s_otherInfo != null) {
            clientInfo = (String)clientInfo + "\n" + this.pduRequest.c_initRequest.s_otherInfo.toString();
        }
        clientInfo = ((String)clientInfo).replaceAll("\"", "");
        return clientInfo;
    }
}

