/*
 * Decompiled with CFR 0.152.
 */
package org.jafer.zserver.operations;

import asn1.ASN1Boolean;
import asn1.ASN1Integer;
import cz.kpsys.kpwinsql.z3950.model.ZServerDatabaseConfig;
import cz.kpsys.kpwinsql.z3950.services.ZServerConfigService;
import org.apache.commons.lang3.StringUtils;
import org.jafer.conf.Config;
import org.jafer.exception.JaferException;
import org.jafer.query.QueryException;
import org.jafer.query.XMLRPNQuery;
import org.jafer.zserver.Session;
import org.jafer.zserver.operations.Operation;
import org.jafer.zserver.operations.OperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import z3950.v3.DefaultDiagFormat;
import z3950.v3.PDU;
import z3950.v3.PresentStatus;
import z3950.v3.RPNQuery;
import z3950.v3.Records;
import z3950.v3.SearchResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class Search
extends Operation {
    private static final Logger logger = LoggerFactory.getLogger(Search.class);
    private final PDU pduRequest;
    private final PDU pduResponse;

    public Search(Session session, PDU pduRequest) {
        super(session, "search");
        this.pduRequest = pduRequest;
        this.pduResponse = new PDU();
    }

    public PDU runOp() throws Exception {
        String[] databases;
        String resultSetName;
        block9: {
            this.pduResponse.c_searchResponse = new SearchResponse();
            this.pduResponse.c_searchResponse.s_referenceId = this.pduRequest.c_searchRequest.s_referenceId;
            this.pduResponse.c_searchResponse.s_resultCount = new ASN1Integer(0);
            this.pduResponse.c_searchResponse.s_searchStatus = new ASN1Boolean(false);
            this.pduResponse.c_searchResponse.s_nextResultSetPosition = new ASN1Integer(0);
            this.pduResponse.c_searchResponse.s_numberOfRecordsReturned = new ASN1Integer(0);
            this.pduResponse.c_searchResponse.s_presentStatus = new PresentStatus();
            PresentStatus cfr_ignored_0 = this.pduResponse.c_searchResponse.s_presentStatus;
            this.pduResponse.c_searchResponse.s_presentStatus.value = new ASN1Integer(5);
            if (this.pduRequest.c_searchRequest.s_resultSetName == null) {
                resultSetName = "default";
            } else {
                resultSetName = this.pduRequest.c_searchRequest.s_resultSetName.value.get();
                if (this.getSession().containsDatabean(resultSetName) && !this.pduRequest.c_searchRequest.s_replaceIndicator.get()) {
                    throw new OperationException(this.getName() + Config.getBib1Diagnostic((int)21) + " ( resultSetName: " + resultSetName + ")", this.getDiagnostic(100, null));
                }
            }
            databases = new String[this.pduRequest.c_searchRequest.s_databaseNames.length];
            for (int n = 0; n < this.pduRequest.c_searchRequest.s_databaseNames.length; ++n) {
                databases[n] = this.pduRequest.c_searchRequest.s_databaseNames[n].value.value.get();
            }
            try {
                ZServerDatabaseConfig database = (ZServerDatabaseConfig)ZServerConfigService.getServerConfig().getDatabases().get(databases[0].toUpperCase());
                if (database == null) {
                    throw new OperationException("neplatna databaze" + Config.getBib1Diagnostic((int)23), this.getDiagnostic(23, databases[0].toUpperCase()));
                }
                String encoding = database.getEncoding();
                if (StringUtils.isBlank((CharSequence)encoding)) {
                    throw new OperationException("neplatne kodovani u baze" + Config.getBib1Diagnostic((int)23), this.getDiagnostic(23, databases[0].toUpperCase()));
                }
                this.session.setEncoding(encoding);
            }
            catch (Exception e) {
                logger.error("selhani", (Throwable)e);
                if (!(e instanceof OperationException)) break block9;
                throw e;
            }
        }
        int results = this.search(this.pduRequest.c_searchRequest.s_query.c_type_1, databases, resultSetName);
        this.pduResponse.c_searchResponse.s_resultCount = new ASN1Integer(results);
        this.pduResponse.c_searchResponse.s_searchStatus = new ASN1Boolean(true);
        this.pduResponse.c_searchResponse.s_numberOfRecordsReturned = new ASN1Integer(0);
        if (results > 0) {
            this.pduResponse.c_searchResponse.s_nextResultSetPosition = new ASN1Integer(1);
        }
        PresentStatus cfr_ignored_1 = this.pduResponse.c_searchResponse.s_presentStatus;
        this.pduResponse.c_searchResponse.s_presentStatus.value = new ASN1Integer(0);
        return this.pduResponse;
    }

    private int search(RPNQuery rpnQuery, String[] databases, String resultSetName) throws OperationException {
        if (this.pduRequest.c_searchRequest.s_query.c_type_1 == null) {
            throw new OperationException(this.getName() + Config.getBib1Diagnostic((int)107), this.getDiagnostic(107, null));
        }
        Node xmlQuery = null;
        try {
            XMLRPNQuery xmlRPNQuery = new XMLRPNQuery(this.session.getEncoding());
            xmlQuery = xmlRPNQuery.getXMLQuery(rpnQuery);
        }
        catch (QueryException ex) {
            throw new OperationException(this.getName() + Config.getBib1Diagnostic((int)108) + "; " + ex.toString(), this.getDiagnostic(108, null), (Throwable)ex);
        }
        org.jafer.interfaces.Search databean = null;
        try {
            databean = this.getDatabean(resultSetName);
        }
        catch (Exception ex) {
            throw new OperationException(this.getName() + Config.getBib1Diagnostic((int)28) + "; " + ex.getMessage(), this.getDiagnostic(28, null), (Throwable)ex);
        }
        int results = 0;
        try {
            databean.setDatabases(databases);
            results = databean.submitQuery(xmlQuery);
        }
        catch (JaferException ex) {
            throw new OperationException(this.getName() + Config.getBib1Diagnostic((int)100) + "; " + ex.getMessage(), this.getDiagnostic(100, ex.getMessage()), (Throwable)ex);
        }
        try {
            this.getSession().freeDatabean(resultSetName);
        }
        catch (JaferException ex) {
            throw new OperationException(this.getName() + Config.getBib1Diagnostic((int)28) + "; " + ex.getMessage(), this.getDiagnostic(28, null), (Throwable)ex);
        }
        return results;
    }

    private org.jafer.interfaces.Search getDatabean(String resultSetName) throws Exception {
        org.jafer.interfaces.Search databean;
        if (this.getSession().containsDatabean(resultSetName)) {
            databean = (org.jafer.interfaces.Search)this.getSession().getDatabean(resultSetName);
        } else {
            databean = (org.jafer.interfaces.Search)this.getSession().getDatabean();
            this.getSession().setDatabean(resultSetName, (Object)databean);
        }
        this.getSession().lockDatabean(resultSetName);
        return databean;
    }

    public PDU getDiagnostic(int condition, String addInfo) {
        this.pduResponse.c_searchResponse.s_records = new Records();
        this.pduResponse.c_searchResponse.s_records.c_nonSurrogateDiagnostic = Search.getDiagnostic((DefaultDiagFormat)new DefaultDiagFormat(), (int)condition, (String)addInfo);
        this.pduResponse.c_searchResponse.s_searchStatus = new ASN1Boolean(false);
        this.pduResponse.c_searchResponse.s_numberOfRecordsReturned = new ASN1Integer(1);
        this.pduResponse.c_searchResponse.s_resultSetStatus = new ASN1Integer(3);
        this.pduResponse.c_searchResponse.s_nextResultSetPosition = new ASN1Integer(1);
        return this.pduResponse;
    }
}

