/*
 * Decompiled with CFR 0.152.
 */
package z3950.AccessCtrl_krb;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1OctetString;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.InternationalString;

public final class KRBResponse
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public InternationalString s_userid;
    public ASN1OctetString s_ticket;

    public KRBResponse() {
    }

    public KRBResponse(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis KRBResponse: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis KRBResponse: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_userid = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis KRBResponse: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis KRBResponse: bad tag in s_ticket\n");
        }
        this.s_ticket = new ASN1OctetString(berencoding1, false);
        if (++j < i) {
            throw new ASN1Exception("Verbis KRBResponse: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 1;
        if (this.s_userid != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_userid != null) {
            aberencoding[l++] = this.s_userid.ber_encode(128, 1);
        }
        aberencoding[l++] = this.s_ticket.ber_encode(128, 2);
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_userid != null) {
            stringbuffer.append("userid ");
            stringbuffer.append(this.s_userid);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("ticket ");
        stringbuffer.append(this.s_ticket);
        ++i;
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

