/*
 * Decompiled with CFR 0.152.
 */
package z3950.ESFormat_Update;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.InternationalString;

public final class CorrelationInfo
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public InternationalString s_note;
    public ASN1Integer s_id;

    public CorrelationInfo() {
    }

    public CorrelationInfo(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis CorrelationInfo: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        this.s_note = null;
        this.s_id = null;
        if (i <= j) {
            return;
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_note = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_id = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis CorrelationInfo: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.s_note != null) {
            ++k;
        }
        if (this.s_id != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_note != null) {
            aberencoding[l++] = this.s_note.ber_encode(128, 1);
        }
        if (this.s_id != null) {
            aberencoding[l++] = this.s_id.ber_encode(128, 2);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_note != null) {
            stringbuffer.append("note ");
            stringbuffer.append(this.s_note);
            ++i;
        }
        if (this.s_id != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("id ");
            stringbuffer.append(this.s_id);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

