/*
 * Decompiled with CFR 0.152.
 */
package z3950.ESFormat_Update;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.InternationalString;

public final class OriginPartToKeep
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1Integer s_action;
    public InternationalString s_databaseName;
    public ASN1ObjectIdentifier s_schema;
    public InternationalString s_elementSetName;
    public static final int E_recordInsert = 1;
    public static final int E_recordReplace = 2;
    public static final int E_recordDelete = 3;
    public static final int E_elementUpdate = 4;

    public OriginPartToKeep() {
    }

    public OriginPartToKeep(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis OriginPartToKeep: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis OriginPartToKeep: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis OriginPartToKeep: bad tag in s_action\n");
        }
        this.s_action = new ASN1Integer(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis OriginPartToKeep: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis OriginPartToKeep: bad tag in s_databaseName\n");
        }
        this.s_databaseName = new InternationalString(berencoding1, false);
        this.s_schema = null;
        this.s_elementSetName = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_schema = new ASN1ObjectIdentifier(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            this.s_elementSetName = new InternationalString(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis OriginPartToKeep: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 2;
        if (this.s_schema != null) {
            ++k;
        }
        if (this.s_elementSetName != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        aberencoding[l++] = this.s_action.ber_encode(128, 1);
        aberencoding[l++] = this.s_databaseName.ber_encode(128, 2);
        if (this.s_schema != null) {
            aberencoding[l++] = this.s_schema.ber_encode(128, 3);
        }
        if (this.s_elementSetName != null) {
            aberencoding[l++] = this.s_elementSetName.ber_encode(128, 4);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        stringbuffer.append("action ");
        stringbuffer.append(this.s_action);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("databaseName ");
        stringbuffer.append(this.s_databaseName);
        ++i;
        if (this.s_schema != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("schema ");
            stringbuffer.append(this.s_schema);
            ++i;
        }
        if (this.s_elementSetName != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("elementSetName ");
            stringbuffer.append(this.s_elementSetName);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

