/*
 * Decompiled with CFR 0.152.
 */
package z3950.ElementSpec;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Null;
import asn1.BEREncoding;
import z3950.ElementSpec.Occurrences_values;

public final class Occurrences
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1Null c_all;
    public ASN1Null c_last;
    public Occurrences_values c_values;

    public Occurrences() {
    }

    public Occurrences(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        this.c_all = null;
        this.c_last = null;
        this.c_values = null;
        if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
            this.c_all = new ASN1Null(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 2 && berencoding.tag_type_get() == 128) {
            this.c_last = new ASN1Null(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 3 && berencoding.tag_type_get() == 128) {
            this.c_values = new Occurrences_values(berencoding, false);
            return;
        }
        throw new ASN1Exception("Verbis Occurrences: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding berencoding = null;
        if (this.c_all != null) {
            berencoding = this.c_all.ber_encode(128, 1);
        }
        if (this.c_last != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_last.ber_encode(128, 2);
        }
        if (this.c_values != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_values.ber_encode(128, 3);
        }
        if (berencoding == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return berencoding;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis Occurrences: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_all != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: all> ");
            }
            flag = true;
            stringbuffer.append("all ");
            stringbuffer.append(this.c_all);
        }
        if (this.c_last != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: last> ");
            }
            flag = true;
            stringbuffer.append("last ");
            stringbuffer.append(this.c_last);
        }
        if (this.c_values != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: values> ");
            }
            flag = true;
            stringbuffer.append("values ");
            stringbuffer.append(this.c_values);
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

