/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_ESTaskPackage;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.ASN1GeneralizedTime;
import asn1.ASN1Integer;
import asn1.ASN1ObjectIdentifier;
import asn1.ASN1OctetString;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.DiagRec;
import z3950.v3.IntUnit;
import z3950.v3.InternationalString;
import z3950.v3.Permissions;

public final class TaskPackage
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1ObjectIdentifier s_packageType;
    public InternationalString s_packageName;
    public InternationalString s_userId;
    public IntUnit s_retentionTime;
    public Permissions s_permissions;
    public InternationalString s_description;
    public ASN1OctetString s_targetReference;
    public ASN1GeneralizedTime s_creationDateTime;
    public ASN1Integer s_taskStatus;
    public DiagRec[] s_packageDiagnostics;
    public ASN1External s_taskSpecificParameters;
    public static final int E_pending = 0;
    public static final int E_active = 1;
    public static final int E_complete = 2;
    public static final int E_aborted = 3;

    public TaskPackage() {
    }

    public TaskPackage(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis TaskPackage: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis TaskPackage: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis TaskPackage: bad tag in s_packageType\n");
        }
        this.s_packageType = new ASN1ObjectIdentifier(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis TaskPackage: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_packageName = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis TaskPackage: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_userId = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis TaskPackage: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            this.s_retentionTime = new IntUnit(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis TaskPackage: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 5 && berencoding1.tag_type_get() == 128) {
            this.s_permissions = new Permissions(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis TaskPackage: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 6 && berencoding1.tag_type_get() == 128) {
            this.s_description = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis TaskPackage: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 7 && berencoding1.tag_type_get() == 128) {
            this.s_targetReference = new ASN1OctetString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis TaskPackage: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 8 && berencoding1.tag_type_get() == 128) {
            this.s_creationDateTime = new ASN1GeneralizedTime(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis TaskPackage: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 9 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis TaskPackage: bad tag in s_taskStatus\n");
        }
        this.s_taskStatus = new ASN1Integer(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis TaskPackage: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 10 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_packageDiagnostics = new DiagRec[k];
                for (int l = 0; l < k; ++l) {
                    this.s_packageDiagnostics[l] = new DiagRec(berconstructed1.elementAt(l), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis TaskPackage: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 11 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis TaskPackage: bad tag in s_taskSpecificParameters\n");
        }
        this.s_taskSpecificParameters = new ASN1External(berencoding1, false);
        if (++j < i) {
            throw new ASN1Exception("Verbis TaskPackage: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 3;
        if (this.s_packageName != null) {
            ++k;
        }
        if (this.s_userId != null) {
            ++k;
        }
        if (this.s_retentionTime != null) {
            ++k;
        }
        if (this.s_permissions != null) {
            ++k;
        }
        if (this.s_description != null) {
            ++k;
        }
        if (this.s_targetReference != null) {
            ++k;
        }
        if (this.s_creationDateTime != null) {
            ++k;
        }
        if (this.s_packageDiagnostics != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        aberencoding[l++] = this.s_packageType.ber_encode(128, 1);
        if (this.s_packageName != null) {
            aberencoding[l++] = this.s_packageName.ber_encode(128, 2);
        }
        if (this.s_userId != null) {
            aberencoding[l++] = this.s_userId.ber_encode(128, 3);
        }
        if (this.s_retentionTime != null) {
            aberencoding[l++] = this.s_retentionTime.ber_encode(128, 4);
        }
        if (this.s_permissions != null) {
            aberencoding[l++] = this.s_permissions.ber_encode(128, 5);
        }
        if (this.s_description != null) {
            aberencoding[l++] = this.s_description.ber_encode(128, 6);
        }
        if (this.s_targetReference != null) {
            aberencoding[l++] = this.s_targetReference.ber_encode(128, 7);
        }
        if (this.s_creationDateTime != null) {
            aberencoding[l++] = this.s_creationDateTime.ber_encode(128, 8);
        }
        aberencoding[l++] = this.s_taskStatus.ber_encode(128, 9);
        if (this.s_packageDiagnostics != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_packageDiagnostics.length];
            for (int i1 = 0; i1 < this.s_packageDiagnostics.length; ++i1) {
                aberencoding1[i1] = this.s_packageDiagnostics[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 10, aberencoding1);
        }
        aberencoding[l++] = this.s_taskSpecificParameters.ber_encode(128, 11);
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        stringbuffer.append("packageType ");
        stringbuffer.append(this.s_packageType);
        ++j;
        if (this.s_packageName != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("packageName ");
            stringbuffer.append(this.s_packageName);
            ++j;
        }
        if (this.s_userId != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("userId ");
            stringbuffer.append(this.s_userId);
            ++j;
        }
        if (this.s_retentionTime != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("retentionTime ");
            stringbuffer.append(this.s_retentionTime);
            ++j;
        }
        if (this.s_permissions != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("permissions ");
            stringbuffer.append(this.s_permissions);
            ++j;
        }
        if (this.s_description != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("description ");
            stringbuffer.append(this.s_description);
            ++j;
        }
        if (this.s_targetReference != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("targetReference ");
            stringbuffer.append(this.s_targetReference);
            ++j;
        }
        if (this.s_creationDateTime != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("creationDateTime ");
            stringbuffer.append(this.s_creationDateTime);
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("taskStatus ");
        stringbuffer.append(this.s_taskStatus);
        ++j;
        if (this.s_packageDiagnostics != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("packageDiagnostics ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_packageDiagnostics.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_packageDiagnostics[i]);
            }
            stringbuffer.append("}");
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("taskSpecificParameters ");
        stringbuffer.append(this.s_taskSpecificParameters);
        ++j;
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

