/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1GeneralizedTime;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.LanguageCode;
import z3950.v3.OtherInformation;

public final class CommonInfo
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1GeneralizedTime s_dateAdded;
    public ASN1GeneralizedTime s_dateChanged;
    public ASN1GeneralizedTime s_expiry;
    public LanguageCode s_humanString_Language;
    public OtherInformation s_otherInfo;

    public CommonInfo() {
    }

    public CommonInfo(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis CommonInfo: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        this.s_dateAdded = null;
        this.s_dateChanged = null;
        this.s_expiry = null;
        this.s_humanString_Language = null;
        this.s_otherInfo = null;
        if (i <= j) {
            return;
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 0 && berencoding1.tag_type_get() == 128) {
            this.s_dateAdded = new ASN1GeneralizedTime(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_dateChanged = new ASN1GeneralizedTime(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_expiry = new ASN1GeneralizedTime(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_humanString_Language = new LanguageCode(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis CommonInfo: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.s_dateAdded != null) {
            ++k;
        }
        if (this.s_dateChanged != null) {
            ++k;
        }
        if (this.s_expiry != null) {
            ++k;
        }
        if (this.s_humanString_Language != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_dateAdded != null) {
            aberencoding[l++] = this.s_dateAdded.ber_encode(128, 0);
        }
        if (this.s_dateChanged != null) {
            aberencoding[l++] = this.s_dateChanged.ber_encode(128, 1);
        }
        if (this.s_expiry != null) {
            aberencoding[l++] = this.s_expiry.ber_encode(128, 2);
        }
        if (this.s_humanString_Language != null) {
            aberencoding[l++] = this.s_humanString_Language.ber_encode(128, 3);
        }
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_dateAdded != null) {
            stringbuffer.append("dateAdded ");
            stringbuffer.append(this.s_dateAdded);
            ++i;
        }
        if (this.s_dateChanged != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("dateChanged ");
            stringbuffer.append(this.s_dateChanged);
            ++i;
        }
        if (this.s_expiry != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("expiry ");
            stringbuffer.append(this.s_expiry);
            ++i;
        }
        if (this.s_humanString_Language != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("humanString-Language ");
            stringbuffer.append(this.s_humanString_Language);
            ++i;
        }
        if (this.s_otherInfo != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

