/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_Explain;

import asn1.ASN1Any;
import asn1.ASN1Boolean;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_Explain.ProximitySupport;

public final class RpnCapabilities
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1Integer[] s_operators;
    public ASN1Boolean s_resultSetAsOperandSupported;
    public ASN1Boolean s_restrictionOperandSupported;
    public ProximitySupport s_proximity;

    public RpnCapabilities() {
    }

    public RpnCapabilities(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis RpnCapabilities: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis RpnCapabilities: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 0 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_operators = new ASN1Integer[k];
                for (int l = 0; l < k; ++l) {
                    this.s_operators[l] = new ASN1Integer(berconstructed1.elementAt(l), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis RpnCapabilities: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis RpnCapabilities: bad tag in s_resultSetAsOperandSupported\n");
        }
        this.s_resultSetAsOperandSupported = new ASN1Boolean(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis RpnCapabilities: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis RpnCapabilities: bad tag in s_restrictionOperandSupported\n");
        }
        this.s_restrictionOperandSupported = new ASN1Boolean(berencoding1, false);
        this.s_proximity = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_proximity = new ProximitySupport(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis RpnCapabilities: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 2;
        if (this.s_operators != null) {
            ++k;
        }
        if (this.s_proximity != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_operators != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_operators.length];
            for (int i1 = 0; i1 < this.s_operators.length; ++i1) {
                aberencoding1[i1] = this.s_operators[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 0, aberencoding1);
        }
        aberencoding[l++] = this.s_resultSetAsOperandSupported.ber_encode(128, 1);
        aberencoding[l++] = this.s_restrictionOperandSupported.ber_encode(128, 2);
        if (this.s_proximity != null) {
            aberencoding[l++] = this.s_proximity.ber_encode(128, 3);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        if (this.s_operators != null) {
            stringbuffer.append("operators ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_operators.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_operators[i]);
            }
            stringbuffer.append("}");
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("resultSetAsOperandSupported ");
        stringbuffer.append(this.s_resultSetAsOperandSupported);
        if (++j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("restrictionOperandSupported ");
        stringbuffer.append(this.s_restrictionOperandSupported);
        ++j;
        if (this.s_proximity != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("proximity ");
            stringbuffer.append(this.s_proximity);
            ++j;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

