/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_generic;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.ASN1OctetString;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.IntUnit;
import z3950.v3.Term;

public final class HitVector
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public Term s_satisfier;
    public IntUnit s_offsetIntoElement;
    public IntUnit s_length;
    public ASN1Integer s_hitRank;
    public ASN1OctetString s_targetToken;

    public HitVector() {
    }

    public HitVector(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis HitVector: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        this.s_satisfier = null;
        this.s_offsetIntoElement = null;
        this.s_length = null;
        this.s_hitRank = null;
        this.s_targetToken = null;
        if (i <= j) {
            return;
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_satisfier = new Term(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_satisfier = null;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_offsetIntoElement = new IntUnit(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_length = new IntUnit(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_hitRank = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            this.s_targetToken = new ASN1OctetString(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis HitVector: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.s_satisfier != null) {
            ++k;
        }
        if (this.s_offsetIntoElement != null) {
            ++k;
        }
        if (this.s_length != null) {
            ++k;
        }
        if (this.s_hitRank != null) {
            ++k;
        }
        if (this.s_targetToken != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_satisfier != null) {
            aberencoding[l++] = this.s_satisfier.ber_encode();
        }
        if (this.s_offsetIntoElement != null) {
            aberencoding[l++] = this.s_offsetIntoElement.ber_encode(128, 1);
        }
        if (this.s_length != null) {
            aberencoding[l++] = this.s_length.ber_encode(128, 2);
        }
        if (this.s_hitRank != null) {
            aberencoding[l++] = this.s_hitRank.ber_encode(128, 3);
        }
        if (this.s_targetToken != null) {
            aberencoding[l++] = this.s_targetToken.ber_encode(128, 4);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_satisfier != null) {
            stringbuffer.append("satisfier ");
            stringbuffer.append(this.s_satisfier);
            ++i;
        }
        if (this.s_offsetIntoElement != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("offsetIntoElement ");
            stringbuffer.append(this.s_offsetIntoElement);
            ++i;
        }
        if (this.s_length != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("length ");
            stringbuffer.append(this.s_length);
            ++i;
        }
        if (this.s_hitRank != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("hitRank ");
            stringbuffer.append(this.s_hitRank);
            ++i;
        }
        if (this.s_targetToken != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("targetToken ");
            stringbuffer.append(this.s_targetToken);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

