/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_generic;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_generic.ElementData;
import z3950.RS_generic.ElementMetaData;
import z3950.RS_generic.Variant;
import z3950.v3.StringOrNumeric;

public final class TaggedElement
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1Integer s_tagType;
    public StringOrNumeric s_tagValue;
    public ASN1Integer s_tagOccurrence;
    public ElementData s_content;
    public ElementMetaData s_metaData;
    public Variant s_appliedVariant;

    public TaggedElement() {
    }

    public TaggedElement(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed1;
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis TaggedElement: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis TaggedElement: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_tagType = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis TaggedElement: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis TaggedElement: bad tag in s_tagValue\n");
        }
        try {
            berconstructed1 = (BERConstructed)berencoding1;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis TaggedElement: bad BER encoding: s_tagValue tag bad\n");
        }
        if (berconstructed1.number_components() != 1) {
            throw new ASN1EncodingException("Verbis TaggedElement: bad BER encoding: s_tagValue tag bad\n");
        }
        this.s_tagValue = new StringOrNumeric(berconstructed1.elementAt(0), true);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis TaggedElement: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_tagOccurrence = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis TaggedElement: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 4 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis TaggedElement: bad tag in s_content\n");
        }
        try {
            berconstructed1 = (BERConstructed)berencoding1;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis TaggedElement: bad BER encoding: s_content tag bad\n");
        }
        if (berconstructed1.number_components() != 1) {
            throw new ASN1EncodingException("Verbis TaggedElement: bad BER encoding: s_content tag bad\n");
        }
        this.s_content = new ElementData(berconstructed1.elementAt(0), true);
        this.s_metaData = null;
        this.s_appliedVariant = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 5 && berencoding1.tag_type_get() == 128) {
            this.s_metaData = new ElementMetaData(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 6 && berencoding1.tag_type_get() == 128) {
            this.s_appliedVariant = new Variant(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis TaggedElement: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 2;
        if (this.s_tagType != null) {
            ++k;
        }
        if (this.s_tagOccurrence != null) {
            ++k;
        }
        if (this.s_metaData != null) {
            ++k;
        }
        if (this.s_appliedVariant != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_tagType != null) {
            aberencoding[l++] = this.s_tagType.ber_encode(128, 1);
        }
        BEREncoding[] aberencoding1 = new BEREncoding[]{this.s_tagValue.ber_encode()};
        aberencoding[l++] = new BERConstructed(128, 2, aberencoding1);
        if (this.s_tagOccurrence != null) {
            aberencoding[l++] = this.s_tagOccurrence.ber_encode(128, 3);
        }
        aberencoding1 = new BEREncoding[]{this.s_content.ber_encode()};
        aberencoding[l++] = new BERConstructed(128, 4, aberencoding1);
        if (this.s_metaData != null) {
            aberencoding[l++] = this.s_metaData.ber_encode(128, 5);
        }
        if (this.s_appliedVariant != null) {
            aberencoding[l++] = this.s_appliedVariant.ber_encode(128, 6);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_tagType != null) {
            stringbuffer.append("tagType ");
            stringbuffer.append(this.s_tagType);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("tagValue ");
        stringbuffer.append(this.s_tagValue);
        ++i;
        if (this.s_tagOccurrence != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("tagOccurrence ");
            stringbuffer.append(this.s_tagOccurrence);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("content ");
        stringbuffer.append(this.s_content);
        ++i;
        if (this.s_metaData != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("metaData ");
            stringbuffer.append(this.s_metaData);
            ++i;
        }
        if (this.s_appliedVariant != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("appliedVariant ");
            stringbuffer.append(this.s_appliedVariant);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

