/*
 * Decompiled with CFR 0.152.
 */
package z3950.ResourceReport_FR1;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.ResourceReport_FR1.EstimateType;

public final class Estimate
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public EstimateType s_type;
    public ASN1Integer s_value;
    public ASN1Integer s_currency_code;

    public Estimate() {
    }

    public Estimate(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis Estimate: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis Estimate: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis Estimate: bad tag in s_type\n");
        }
        this.s_type = new EstimateType(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis Estimate: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis Estimate: bad tag in s_value\n");
        }
        this.s_value = new ASN1Integer(berencoding1, false);
        this.s_currency_code = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_currency_code = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis Estimate: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 2;
        if (this.s_currency_code != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        aberencoding[l++] = this.s_type.ber_encode(128, 1);
        aberencoding[l++] = this.s_value.ber_encode(128, 2);
        if (this.s_currency_code != null) {
            aberencoding[l++] = this.s_currency_code.ber_encode(128, 3);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        stringbuffer.append("type ");
        stringbuffer.append(this.s_type);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("value ");
        stringbuffer.append(this.s_value);
        ++i;
        if (this.s_currency_code != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("currency-code ");
            stringbuffer.append(this.s_currency_code);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

