/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.AttributeElement_attributeValue;
import z3950.v3.AttributeSetId;

public final class AttributeElement
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public AttributeSetId s_attributeSet;
    public ASN1Integer s_attributeType;
    public AttributeElement_attributeValue s_attributeValue;

    public AttributeElement() {
    }

    public AttributeElement(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis AttributeElement: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis AttributeElement: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_attributeSet = new AttributeSetId(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis AttributeElement: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 120 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis AttributeElement: bad tag in s_attributeType\n");
        }
        this.s_attributeType = new ASN1Integer(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis AttributeElement: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        this.s_attributeValue = new AttributeElement_attributeValue(berencoding1, true);
        if (++j < i) {
            throw new ASN1Exception("Verbis AttributeElement: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 2;
        if (this.s_attributeSet != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_attributeSet != null) {
            aberencoding[l++] = this.s_attributeSet.ber_encode(128, 1);
        }
        aberencoding[l++] = this.s_attributeType.ber_encode(128, 120);
        aberencoding[l++] = this.s_attributeValue.ber_encode();
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_attributeSet != null) {
            stringbuffer.append("attributeSet ");
            stringbuffer.append(this.s_attributeSet);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("attributeType ");
        stringbuffer.append(this.s_attributeType);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("attributeValue ");
        stringbuffer.append(this.s_attributeValue);
        ++i;
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

