/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.ASN1Integer;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.ElementSetName;
import z3950.v3.IntUnit;
import z3950.v3.InternationalString;
import z3950.v3.OtherInformation;
import z3950.v3.Permissions;
import z3950.v3.ReferenceId;

public final class ExtendedServicesRequest
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public ASN1Integer s_function;
    public ASN1ObjectIdentifier s_packageType;
    public InternationalString s_packageName;
    public InternationalString s_userId;
    public IntUnit s_retentionTime;
    public Permissions s_permissions;
    public InternationalString s_description;
    public ASN1External s_taskSpecificParameters;
    public ASN1Integer s_waitAction;
    public ElementSetName s_elements;
    public OtherInformation s_otherInfo;
    public static final int E_create = 1;
    public static final int E_delete = 2;
    public static final int E_modify = 3;
    public static final int E_wait = 1;
    public static final int E_waitIfPossible = 2;
    public static final int E_dontWait = 3;
    public static final int E_dontReturnPackage = 4;

    public ExtendedServicesRequest() {
    }

    public ExtendedServicesRequest(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis ExtendedServicesRequest: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis ExtendedServicesRequest: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ExtendedServicesRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 3 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ExtendedServicesRequest: bad tag in s_function\n");
        }
        this.s_function = new ASN1Integer(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ExtendedServicesRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 4 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ExtendedServicesRequest: bad tag in s_packageType\n");
        }
        this.s_packageType = new ASN1ObjectIdentifier(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis ExtendedServicesRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 5 && berencoding1.tag_type_get() == 128) {
            this.s_packageName = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ExtendedServicesRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 6 && berencoding1.tag_type_get() == 128) {
            this.s_userId = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ExtendedServicesRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 7 && berencoding1.tag_type_get() == 128) {
            this.s_retentionTime = new IntUnit(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ExtendedServicesRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 8 && berencoding1.tag_type_get() == 128) {
            this.s_permissions = new Permissions(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ExtendedServicesRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 9 && berencoding1.tag_type_get() == 128) {
            this.s_description = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ExtendedServicesRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 10 && berencoding1.tag_type_get() == 128) {
            this.s_taskSpecificParameters = new ASN1External(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ExtendedServicesRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 11 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ExtendedServicesRequest: bad tag in s_waitAction\n");
        }
        this.s_waitAction = new ASN1Integer(berencoding1, false);
        this.s_elements = null;
        this.s_otherInfo = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_elements = new ElementSetName(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_elements = null;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis ExtendedServicesRequest: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 3;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_packageName != null) {
            ++k;
        }
        if (this.s_userId != null) {
            ++k;
        }
        if (this.s_retentionTime != null) {
            ++k;
        }
        if (this.s_permissions != null) {
            ++k;
        }
        if (this.s_description != null) {
            ++k;
        }
        if (this.s_taskSpecificParameters != null) {
            ++k;
        }
        if (this.s_elements != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        aberencoding[l++] = this.s_function.ber_encode(128, 3);
        aberencoding[l++] = this.s_packageType.ber_encode(128, 4);
        if (this.s_packageName != null) {
            aberencoding[l++] = this.s_packageName.ber_encode(128, 5);
        }
        if (this.s_userId != null) {
            aberencoding[l++] = this.s_userId.ber_encode(128, 6);
        }
        if (this.s_retentionTime != null) {
            aberencoding[l++] = this.s_retentionTime.ber_encode(128, 7);
        }
        if (this.s_permissions != null) {
            aberencoding[l++] = this.s_permissions.ber_encode(128, 8);
        }
        if (this.s_description != null) {
            aberencoding[l++] = this.s_description.ber_encode(128, 9);
        }
        if (this.s_taskSpecificParameters != null) {
            aberencoding[l++] = this.s_taskSpecificParameters.ber_encode(128, 10);
        }
        aberencoding[l++] = this.s_waitAction.ber_encode(128, 11);
        if (this.s_elements != null) {
            aberencoding[l++] = this.s_elements.ber_encode();
        }
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("function ");
        stringbuffer.append(this.s_function);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("packageType ");
        stringbuffer.append(this.s_packageType);
        ++i;
        if (this.s_packageName != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("packageName ");
            stringbuffer.append(this.s_packageName);
            ++i;
        }
        if (this.s_userId != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("userId ");
            stringbuffer.append(this.s_userId);
            ++i;
        }
        if (this.s_retentionTime != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("retentionTime ");
            stringbuffer.append(this.s_retentionTime);
            ++i;
        }
        if (this.s_permissions != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("permissions ");
            stringbuffer.append(this.s_permissions);
            ++i;
        }
        if (this.s_description != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("description ");
            stringbuffer.append(this.s_description);
            ++i;
        }
        if (this.s_taskSpecificParameters != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("taskSpecificParameters ");
            stringbuffer.append(this.s_taskSpecificParameters);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("waitAction ");
        stringbuffer.append(this.s_waitAction);
        ++i;
        if (this.s_elements != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("elements ");
            stringbuffer.append(this.s_elements);
            ++i;
        }
        if (this.s_otherInfo != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

