/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1Boolean;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.InternationalString;
import z3950.v3.Options;
import z3950.v3.OtherInformation;
import z3950.v3.ProtocolVersion;
import z3950.v3.ReferenceId;

public final class InitializeResponse
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public ProtocolVersion s_protocolVersion;
    public Options s_options;
    public ASN1Integer s_preferredMessageSize;
    public ASN1Integer s_exceptionalRecordSize;
    public ASN1Boolean s_result;
    public InternationalString s_implementationId;
    public InternationalString s_implementationName;
    public InternationalString s_implementationVersion;
    public ASN1External s_userInformationField;
    public OtherInformation s_otherInfo;

    public InitializeResponse() {
    }

    public InitializeResponse(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis InitializeResponse: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis InitializeResponse: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis InitializeResponse: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        this.s_protocolVersion = new ProtocolVersion(berencoding1, true);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis InitializeResponse: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        this.s_options = new Options(berencoding1, true);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis InitializeResponse: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 5 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis InitializeResponse: bad tag in s_preferredMessageSize\n");
        }
        this.s_preferredMessageSize = new ASN1Integer(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis InitializeResponse: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 6 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis InitializeResponse: bad tag in s_exceptionalRecordSize\n");
        }
        this.s_exceptionalRecordSize = new ASN1Integer(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis InitializeResponse: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 12 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis InitializeResponse: bad tag in s_result\n");
        }
        this.s_result = new ASN1Boolean(berencoding1, false);
        ++j;
        this.s_implementationId = null;
        this.s_implementationName = null;
        this.s_implementationVersion = null;
        this.s_userInformationField = null;
        this.s_otherInfo = null;
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 110 && berencoding1.tag_type_get() == 128) {
            this.s_implementationId = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 111 && berencoding1.tag_type_get() == 128) {
            this.s_implementationName = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 112 && berencoding1.tag_type_get() == 128) {
            this.s_implementationVersion = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 11 && berencoding1.tag_type_get() == 128) {
            BERConstructed berconstructed1;
            try {
                berconstructed1 = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis InitializeResponse: bad BER encoding: s_userInformationField tag bad\n");
            }
            if (berconstructed1.number_components() != 1) {
                throw new ASN1EncodingException("Verbis InitializeResponse: bad BER encoding: s_userInformationField tag bad\n");
            }
            this.s_userInformationField = new ASN1External(berconstructed1.elementAt(0), true);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis InitializeResponse: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 5;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_implementationId != null) {
            ++k;
        }
        if (this.s_implementationName != null) {
            ++k;
        }
        if (this.s_implementationVersion != null) {
            ++k;
        }
        if (this.s_userInformationField != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        aberencoding[l++] = this.s_protocolVersion.ber_encode();
        aberencoding[l++] = this.s_options.ber_encode();
        aberencoding[l++] = this.s_preferredMessageSize.ber_encode(128, 5);
        aberencoding[l++] = this.s_exceptionalRecordSize.ber_encode(128, 6);
        aberencoding[l++] = this.s_result.ber_encode(128, 12);
        if (this.s_implementationId != null) {
            aberencoding[l++] = this.s_implementationId.ber_encode(128, 110);
        }
        if (this.s_implementationName != null) {
            aberencoding[l++] = this.s_implementationName.ber_encode(128, 111);
        }
        if (this.s_implementationVersion != null) {
            aberencoding[l++] = this.s_implementationVersion.ber_encode(128, 112);
        }
        if (this.s_userInformationField != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[]{this.s_userInformationField.ber_encode()};
            aberencoding[l++] = new BERConstructed(128, 11, aberencoding1);
        }
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("protocolVersion ");
        stringbuffer.append(this.s_protocolVersion);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("options ");
        stringbuffer.append(this.s_options);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("preferredMessageSize ");
        stringbuffer.append(this.s_preferredMessageSize);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("exceptionalRecordSize ");
        stringbuffer.append(this.s_exceptionalRecordSize);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("result ");
        stringbuffer.append(this.s_result);
        ++i;
        if (this.s_implementationId != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("implementationId ");
            stringbuffer.append(this.s_implementationId);
            ++i;
        }
        if (this.s_implementationName != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("implementationName ");
            stringbuffer.append(this.s_implementationName);
            ++i;
        }
        if (this.s_implementationVersion != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("implementationVersion ");
            stringbuffer.append(this.s_implementationVersion);
            ++i;
        }
        if (this.s_userInformationField != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("userInformationField ");
            stringbuffer.append(this.s_userInformationField);
            ++i;
        }
        if (this.s_otherInfo != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

