/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.OtherInformation;
import z3950.v3.PresentRequest_recordComposition;
import z3950.v3.Range;
import z3950.v3.ReferenceId;
import z3950.v3.ResultSetId;

public final class PresentRequest
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public ResultSetId s_resultSetId;
    public ASN1Integer s_resultSetStartPoint;
    public ASN1Integer s_numberOfRecordsRequested;
    public Range[] s_additionalRanges;
    public PresentRequest_recordComposition s_recordComposition;
    public ASN1ObjectIdentifier s_preferredRecordSyntax;
    public ASN1Integer s_maxSegmentCount;
    public ASN1Integer s_maxRecordSize;
    public ASN1Integer s_maxSegmentSize;
    public OtherInformation s_otherInfo;

    public PresentRequest() {
    }

    public PresentRequest(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis PresentRequest: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis PresentRequest: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis PresentRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        this.s_resultSetId = new ResultSetId(berencoding1, true);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis PresentRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 30 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis PresentRequest: bad tag in s_resultSetStartPoint\n");
        }
        this.s_resultSetStartPoint = new ASN1Integer(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis PresentRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 29 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis PresentRequest: bad tag in s_numberOfRecordsRequested\n");
        }
        this.s_numberOfRecordsRequested = new ASN1Integer(berencoding1, false);
        ++j;
        this.s_additionalRanges = null;
        this.s_recordComposition = null;
        this.s_preferredRecordSyntax = null;
        this.s_maxSegmentCount = null;
        this.s_maxRecordSize = null;
        this.s_maxSegmentSize = null;
        this.s_otherInfo = null;
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 212 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_additionalRanges = new Range[k];
                for (int l = 0; l < k; ++l) {
                    this.s_additionalRanges[l] = new Range(berconstructed1.elementAt(l), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_recordComposition = new PresentRequest_recordComposition(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_recordComposition = null;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 104 && berencoding1.tag_type_get() == 128) {
            this.s_preferredRecordSyntax = new ASN1ObjectIdentifier(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 204 && berencoding1.tag_type_get() == 128) {
            this.s_maxSegmentCount = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 206 && berencoding1.tag_type_get() == 128) {
            this.s_maxRecordSize = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 207 && berencoding1.tag_type_get() == 128) {
            this.s_maxSegmentSize = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis PresentRequest: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 3;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_additionalRanges != null) {
            ++k;
        }
        if (this.s_recordComposition != null) {
            ++k;
        }
        if (this.s_preferredRecordSyntax != null) {
            ++k;
        }
        if (this.s_maxSegmentCount != null) {
            ++k;
        }
        if (this.s_maxRecordSize != null) {
            ++k;
        }
        if (this.s_maxSegmentSize != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        aberencoding[l++] = this.s_resultSetId.ber_encode();
        aberencoding[l++] = this.s_resultSetStartPoint.ber_encode(128, 30);
        aberencoding[l++] = this.s_numberOfRecordsRequested.ber_encode(128, 29);
        if (this.s_additionalRanges != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_additionalRanges.length];
            for (int i1 = 0; i1 < this.s_additionalRanges.length; ++i1) {
                aberencoding1[i1] = this.s_additionalRanges[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 212, aberencoding1);
        }
        if (this.s_recordComposition != null) {
            aberencoding[l++] = this.s_recordComposition.ber_encode();
        }
        if (this.s_preferredRecordSyntax != null) {
            aberencoding[l++] = this.s_preferredRecordSyntax.ber_encode(128, 104);
        }
        if (this.s_maxSegmentCount != null) {
            aberencoding[l++] = this.s_maxSegmentCount.ber_encode(128, 204);
        }
        if (this.s_maxRecordSize != null) {
            aberencoding[l++] = this.s_maxRecordSize.ber_encode(128, 206);
        }
        if (this.s_maxSegmentSize != null) {
            aberencoding[l++] = this.s_maxSegmentSize.ber_encode(128, 207);
        }
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++j;
        }
        if (j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("resultSetId ");
        stringbuffer.append(this.s_resultSetId);
        if (++j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("resultSetStartPoint ");
        stringbuffer.append(this.s_resultSetStartPoint);
        if (++j > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("numberOfRecordsRequested ");
        stringbuffer.append(this.s_numberOfRecordsRequested);
        ++j;
        if (this.s_additionalRanges != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("additionalRanges ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_additionalRanges.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_additionalRanges[i]);
            }
            stringbuffer.append("}");
            ++j;
        }
        if (this.s_recordComposition != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("recordComposition ");
            stringbuffer.append(this.s_recordComposition);
            ++j;
        }
        if (this.s_preferredRecordSyntax != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("preferredRecordSyntax ");
            stringbuffer.append(this.s_preferredRecordSyntax);
            ++j;
        }
        if (this.s_maxSegmentCount != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("maxSegmentCount ");
            stringbuffer.append(this.s_maxSegmentCount);
            ++j;
        }
        if (this.s_maxRecordSize != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("maxRecordSize ");
            stringbuffer.append(this.s_maxRecordSize);
            ++j;
        }
        if (this.s_maxSegmentSize != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("maxSegmentSize ");
            stringbuffer.append(this.s_maxSegmentSize);
            ++j;
        }
        if (this.s_otherInfo != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++j;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

