/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import z3950.v3.Operand;
import z3950.v3.RPNStructure_rpnRpnOp;

public final class RPNStructure
extends ASN1Any {
    private static final Logger logger = LoggerFactory.getLogger(RPNStructure.class);
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public Operand c_op;
    public RPNStructure_rpnRpnOp c_rpnRpnOp;

    public RPNStructure() {
    }

    public RPNStructure(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        logger.error("nevolat!");
    }

    public RPNStructure(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        this.ber_decode(berencoding, flag, encoding);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        this.c_op = null;
        this.c_rpnRpnOp = null;
        if (berencoding.tag_get() == 0 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed;
            try {
                berconstructed = (BERConstructed)berencoding;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis RPNStructure: bad BER form\n");
            }
            if (berconstructed.number_components() != 1) {
                throw new ASN1EncodingException("Verbis RPNStructure: bad BER form\n");
            }
            this.c_op = new Operand(berconstructed.elementAt(0), true, encoding);
            int i = 2;
            return;
        }
        if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
            this.c_rpnRpnOp = new RPNStructure_rpnRpnOp(berencoding, false, encoding);
            return;
        }
        throw new ASN1Exception("Verbis RPNStructure: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding obj = null;
        if (this.c_op != null) {
            BEREncoding[] aberencoding = new BEREncoding[]{this.c_op.ber_encode()};
            obj = new BERConstructed(128, 0, aberencoding);
        }
        if (this.c_rpnRpnOp != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            obj = this.c_rpnRpnOp.ber_encode(128, 1);
        }
        if (obj == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return obj;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis RPNStructure: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_op != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: op> ");
            }
            flag = true;
            stringbuffer.append("op ");
            stringbuffer.append(this.c_op);
        }
        if (this.c_rpnRpnOp != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: rpnRpnOp> ");
            }
            flag = true;
            stringbuffer.append("rpnRpnOp ");
            stringbuffer.append(this.c_rpnRpnOp);
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

