/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1ObjectIdentifier;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.Specification_elementSpec;

public final class Specification
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1ObjectIdentifier s_schema;
    public Specification_elementSpec s_elementSpec;

    public Specification() {
    }

    public Specification(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis Specification: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        this.s_schema = null;
        this.s_elementSpec = null;
        if (i <= j) {
            return;
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_schema = new ASN1ObjectIdentifier(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            BERConstructed berconstructed1;
            try {
                berconstructed1 = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis Specification: bad BER encoding: s_elementSpec tag bad\n");
            }
            if (berconstructed1.number_components() != 1) {
                throw new ASN1EncodingException("Verbis Specification: bad BER encoding: s_elementSpec tag bad\n");
            }
            this.s_elementSpec = new Specification_elementSpec(berconstructed1.elementAt(0), true);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis Specification: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.s_schema != null) {
            ++k;
        }
        if (this.s_elementSpec != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_schema != null) {
            aberencoding[l++] = this.s_schema.ber_encode(128, 1);
        }
        if (this.s_elementSpec != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[]{this.s_elementSpec.ber_encode()};
            aberencoding[l++] = new BERConstructed(128, 2, aberencoding1);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_schema != null) {
            stringbuffer.append("schema ");
            stringbuffer.append(this.s_schema);
            ++i;
        }
        if (this.s_elementSpec != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("elementSpec ");
            stringbuffer.append(this.s_elementSpec);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

