/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BEREncoding;
import z3950.v3.InternationalString;

public final class StringOrNumeric
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public InternationalString c_string;
    public ASN1Integer c_numeric;

    public StringOrNumeric() {
    }

    public StringOrNumeric(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        this.c_string = null;
        this.c_numeric = null;
        if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
            this.c_string = new InternationalString(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 2 && berencoding.tag_type_get() == 128) {
            this.c_numeric = new ASN1Integer(berencoding, false);
            return;
        }
        throw new ASN1Exception("Verbis StringOrNumeric: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding berencoding = null;
        if (this.c_string != null) {
            berencoding = this.c_string.ber_encode(128, 1);
        }
        if (this.c_numeric != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_numeric.ber_encode(128, 2);
        }
        if (berencoding == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return berencoding;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis StringOrNumeric: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_string != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: string> ");
            }
            flag = true;
            stringbuffer.append("string ");
            stringbuffer.append(this.c_string);
        }
        if (this.c_numeric != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: numeric> ");
            }
            flag = true;
            stringbuffer.append("numeric ");
            stringbuffer.append(this.c_numeric);
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

