create or alter procedure LOG_IN_USER20 (
    JMENO type of STRING_40,
    CISLO_UZIVATELE type of GENERATORY_NULL)
returns (
    ID_UZIV SMALL_NULL,
    UROVEN SMALL_NULL,
    ID_GROUP SMALL_NULL,
    TISK_JMENO STRING_60,
    ROW_ID GENERATORY_NOTNULL,
    DB_UZIV STRING_30,
    JE_SERVIS_WWW SMALL_NULL,
    VAL_KOD_WWW STRING_20)
as
begin
    id_uziv = NULL;
    row_id = rdb$get_context('USER_SESSION', 'LOGIN_SESSION_ID');
    db_uziv = CURRENT_USER;

    for select def_uziv.fk_uziv, uroven, fk_group, tisk_jmeno, je_servis_www, val_kod_www
            from osoby join def_uziv on osoby.fk_uziv = def_uziv.fk_uziv where osoby.username = :jmeno and def_uziv.fk_uziv = :cislo_uzivatele and je_povol = 1
            into :id_uziv, :uroven, :id_group, :tisk_jmeno, :je_servis_www, :VAL_KOD_WWW
    do begin
        rdb$set_context('USER_SESSION', 'LOGGED_USER_ID', :id_uziv);
        if (row_id is not null) then
        begin
            if (CURRENT_USER = 'KATALOG') then
            begin
                update log_uziv set fk_uziv = :id_uziv, posl_cas = 'NOW' where id = :row_id;
                update log_uziv set logoff_time = coalesce(posl_cas, login_time), connected = 0
                    where connected = 1 and fk_uziv = :id_uziv and (current_timestamp - POSL_CAS) > 1;
                db_uziv = 'KATALOG_UPD';
            end
            if (CURRENT_USER = 'SQLKPWIN') then
            begin
                update log_uziv_kpwinsql set logoff_time = 'NOW' where id = :row_id and logoff_time is null;
                insert into log_uziv_kpwinsql (client_ip, login_time, logoff_time, id, fk_uziv) values (rdb$get_context('SYSTEM', 'CLIENT_ADDRESS'), 'NOW', null, :row_id, :id_uziv);
            end
            if (CURRENT_USER = 'OPAC') then
            begin
                insert into log_uziv_opac_edit (fk_uziv, client_ip, login_time, logoff_time, connected, posl_cas)
                    values (:id_uziv, rdb$get_context('SYSTEM', 'CLIENT_ADDRESS'), 'NOW', null, 1, 'NOW')
                    returning (id) into :row_id;
            end
        end
        suspend;
    end
end
^

GRANT SELECT ON OSOBY TO PROCEDURE LOG_IN_USER20
^
GRANT SELECT ON DEF_UZIV TO PROCEDURE LOG_IN_USER20
^
GRANT SELECT,UPDATE ON LOG_UZIV TO PROCEDURE LOG_IN_USER20
^
GRANT SELECT,INSERT,UPDATE ON LOG_UZIV_KPWINSQL TO PROCEDURE LOG_IN_USER20
^
GRANT INSERT ON LOG_UZIV_OPAC_EDIT TO PROCEDURE LOG_IN_USER20
^

GRANT EXECUTE ON PROCEDURE LOG_IN_USER20 TO KATALOG
^
GRANT EXECUTE ON PROCEDURE LOG_IN_USER20 TO OPAC
^
GRANT EXECUTE ON PROCEDURE LOG_IN_USER20 TO SQLKPWIN
^

