
UPDATE DEF_GRIDEDIT_GRID SET 
    TABULKA = 'CTENARI'
WHERE (FK_GRIDEDIT_FORM = 5024) AND
      (TABULKA = 'UZIVATELE') AND
      (POLE = 'POZNAMKA')
      ^

UPDATE DEF_GRIDEDIT_GRID SET 
    TABULKA = 'CTENARI'
WHERE (FK_GRIDEDIT_FORM = 5024) AND
      (TABULKA = 'UZIVATELE') AND
      (POLE = 'VZKAZ')
      ^

CREATE OR ALTER VIEW VIEW_TISK_REZERVACE_UTIL(
    IP_ADDR,
    FK_VYPUC,
    FK_UZIV_CTEN,
    OZNACENI,
    CTENAR,
    ZAMESTNANI,
    CIS_LEG,
    BAR_COD,
    FK_ZAZ,
    FK_DOKFOND,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    FK_EX,
    PRIR_CISLO,
    SIGNATURA,
    FK_STATUS,
    BAR_COD_EXEMP,
    CIS_REZE,
    DAT_REZE,
    ZAJEM_DO,
    FK_LOKACE,
    LOKACE,
    KOD_LOKACE,
    FK_VYPKAT,
    FK_CTENKAT,
    VYPKAT,
    FK_PUJC,
    VYP_PUJC,
    VALID_PUJC,
    CTEN_PUJC,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    EMAIL,
    SMS,
    TRIDSIGN,
    P1064,
    JE_VYPUC,
    DAT_TISK)
AS
select POZ_REZ.ip_addr,VYPUC.FK_VYPUC,
VYPUC.FK_UZIV_CTEN, VYPUC.oznac, uzi.zobr_jmeno, os.zamestnani, ctenari.CIS_LEG,
ctenari.BAR_COD, VYPUC.FK_ZAZ, kat1_4.fk_dokfond, KAT1_4.NAZEV, KAT1_4.autor, KAT1_4.nakl, KAT1_4.isbn, KAT1_4.rok_od, KAT1_5.ID_EX,
kat1_5.prir_cislo,
kat1_5.signatura,
kat1_5.fk_status,
kat1_5.bar_cod,
VYPUC.CIS_REZE, VYPUC.DAT_PROL, VYPUC.DAT_PROL + VYPUC.dob_vyp,
kat1_5.FK_LOKACE, DEF_LOKACE.nazev, DEF_LOKACE.kod_lokace,
kat1_5.FK_VYPKAT,
ctenari.fk_ctenkat, DEF_VYPKAT.popis,
VYPUC.FK_PUJC, DP1.nazev, POZ_REZ.pujcovny, DP2.nazev,
prim_kontakt.trv_MI, prim_kontakt.trv_UL, prim_kontakt.trv_PSC, 
 CTENARI.TYP_TISK_REZE, CTENARI.TYP_TISK_UPOM, prim_kontakt.email, prim_kontakt.sms,
 KAT1_5.tridsign,
 null, 
 (select first 1 fk_ex from vypuc v2 where v2.fk_ex = kat1_5.id_ex and cis_reze != 53), vypuc.dat_predup
from vypuc join kat1_4 on id_zaz = vypuc.fk_zaz
  join def_pujc dp1 on dp1.id_pujc = vypuc.fk_pujc
  join ctenari on ctenari.fk_uziv = vypuc.fk_uziv_cten 
  join uzivatele uzi on ctenari.fk_uziv = uzi.id_uziv
  left join osoby os on os.fk_uziv = uzi.id_uziv
  join def_ctenkat on fk_ctenkat = id_ctenkat
  join def_pujc dp2 on dp2.id_pujc = ctenari.fk_pujc
  join kat1_5 on kat1_5.fk_zaz = vypuc.fk_zaz and (vypuc.fk_ex is null or vypuc.fk_ex = kat1_5.id_ex)
  left join def_lokace on id_lokace = kat1_5.fk_lokace
  left join def_vypkat on id_vypkat = kat1_5.fk_vypkat
  left join poz_rez on poz_rez.fk_vypuc = vypuc.fk_vypuc
  left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenari.fk_uziv 
where
    cis_reze = 53
^

CREATE OR ALTER VIEW VIEW_TISK_UPOMINKY_NETISK(
    FK_VYPUC, FK_UZIV_CTEN,
    CTENAR, PRIJMENI, JMENO, TITUL, TITUL_ZA,
    PUJC_CTEN, BLOK_CTEN, CIS_LEG,
    EMAIL, SMS,
    TYP_TISK_REZE, TYP_TISK_UPOM, FK_CTENKAT, BAR_COD_CTEN,
    FK_ZAZ,
    FK_DOKFOND, NAZEV, AUTOR, NAKLADATEL, ISBN, ROKVYD,
    FK_EX, OZNAC, DAT_PROL, DAT_VYP, POC_PROL, DOB_VYP, CENA,
    FK_LOKACE, FK_VYPKAT, CIS_UPOM, FK_PUJC, FK_TYPPUJC,
    DAT_GEN, DAT_TISK,
    TRV_MI, TRV_UL, TRV_PSC, TRV_STAT,
    PRIR_CISLO, SIGNATURA, BAR_COD_EXEMP,
    FK_PUJC_NADR, NAZEV_PUJC_NADR,
    ISSUE_CISLO, ISSUE_EVID_CIS, VOLUME_CISLO, VOLUME_ROK, ISSUE_ISSVOL,
    CASTKA,
    POZNAMKA,
    EMAIL_KOPIE, EMAIL_ZAKZAST,
    ZAKZAST_PRIJMENI, ZAKZAST_JMENO, ZAKZAST_MI, ZAKZAST_UL, ZAKZAST_PSC,
    ZAKZAST_CISOP, ZAKZAST_DATNAR, ZAKZAST_TITUL, ZAKZAST_KOR_MI, ZAKZAST_KOR_UL, ZAKZAST_KOR_PSC, ZAKZAST_EMAIL, ZAKZAST_SMS, ZAKZAST_TELEFON,
    NAZEV_FIRMY, ICO, DIC, OBCH_REJSTRIK, FUNKCE,
    VZDELANI,
    POCET_KUSU_TIT)
AS
select
    VYPUC.FK_VYPUC, VYPUC.FK_UZIV_CTEN,
    uzi.zobr_jmeno, os.PRIJMENI, os.JMENO, os.TITUL, os.TITUL_ZA,
    CTENAR.fk_pujc, ctenar.je_blokovan, ctenar.CIS_LEG,
    prim_kontakt.email, prim_kontakt.sms,
    CTENAR.TYP_TISK_REZE, CTENAR.TYP_TISK_UPOM, CTENAR.fk_ctenkat, ctenar.bar_cod,
    VYPUC.FK_ZAZ,
    kat1_4.fk_dokfond,  KAT1_4.NAZEV,  KAT1_4.autor,  KAT1_4.nakl,  KAT1_4.isbn,  KAT1_4.rok_od,
    VYPUC.FK_EX,  VYPUC.OZNAC,  VYPUC.DAT_PROL,  VYPUC.dat_vyp,  VYPUC.POC_PROL,  VYPUC.DAT_PROL + VYPUC.DOB_VYP,  VYPUC.CENA,
    VYPUC.FK_LOKACE, VYPUC.FK_VYPKAT, VYPUC.CIS_UPOM, VYPUC.FK_PUJC, VYPUC.FK_TYPPUJC,
    UPOMINKY.DAT_GEN,  UPOMINKY.DAT_TISK,
    prim_kontakt.trv_MI, prim_kontakt.trv_UL, prim_kontakt.trv_PSC, prim_kontakt.TRV_STAT,
    kat1_5.prir_cislo, kat1_5.signatura, kat1_5.bar_cod,
    (select fk_nadr from def_pujc where id_pujc = vypuc.fk_pujc),
    (select nadr.nazev from def_pujc nadr join def_pujc podr on nadr.id_pujc = podr.fk_nadr where podr.id_pujc = vypuc.fk_pujc),
    issues.issue, issues.evcislo, volume.cis_vol, volume.rok_vol, issues.issue || '/' || volume.cis_vol,
    (select sum(castka) from platby where platby.fk_uziv_vlastnik = vypuc.fk_uziv_cten and fk_popl = 3),
    vypuc.poznamka,
    prim_kontakt.email_kopie, zak_zast.email,
    zak_zast.prijmeni, zak_zast.jmeno, zak_zast.trv_mi, zak_zast.trv_ul, zak_zast.trv_psc,
    zak_zast.cisop, zak_zast.datnar, ZAK_ZAST.TITUL, ZAK_ZAST.kor_MI, ZAK_ZAST.kor_UL, ZAK_ZAST.kor_PSC, ZAK_ZAST.EMAIL, ZAK_ZAST.SMS, ZAK_ZAST.TELEFON,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik,
    os.funkce, os.VZDELANI,
    (select sum(zmena) from vypuc_titper where vypuc.fk_vypuc = vypuc_titper.fk_vypuc)
from vypuc  join upominky on vypuc.fk_vypuc = upominky.fk_vypuc and vypuc.cis_upom = upominky.cis_upom
            join kat1_4 on vypuc.fk_zaz = kat1_4.id_zaz
            left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
            join ctenari ctenar on  vypuc.fk_uziv_cten = ctenar.fk_uziv
            join uzivatele uzi on ctenar.fk_uziv = uzi.id_uziv
            left join osoby os on os.fk_uziv = uzi.id_uziv
            left join instituce on instituce.fk_uziv = uzi.id_uziv
            join def_ctenkat on ctenar.fk_ctenkat = id_ctenkat
            join def_pujc on vypuc.fk_pujc = id_pujc
            left join issues on kat1_5.id_ex = issues.fk_ex
            left join volume on issues.fk_vol = volume.id_vol
            left join VIEW_PRIMARNI_ZASTUPCI zak_zast on ctenar.fk_uziv = zak_zast.fk_uziv
            left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenar.fk_uziv
where upominky.dat_tisk is null
^


CREATE OR ALTER VIEW VIEW_TISK_UPOMINKY(
    FK_VYPUC,
    FK_UZIV_CTEN,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,   
    TITUL_ZA,
    PUJC_CTEN,
    BLOK_CTEN,
    CIS_LEG,
    EMAIL,
    SMS,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    FK_CTENKAT,
    BAR_COD_CTEN,
    FK_ZAZ,
    FK_DOKFOND,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    FK_EX,
    OZNAC,
    DAT_PROL,
    DAT_VYP,
    POC_PROL,
    DOB_VYP,
    CENA,
    FK_LOKACE,
    FK_VYPKAT,
    CIS_UPOM,
    FK_PUJC,
    FK_TYPPUJC,
    DAT_GEN,
    DAT_TISK,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    PRIR_CISLO,
    SIGNATURA,
    BAR_COD_EXEMP,
    FK_PUJC_NADR,
    NAZEV_PUJC_NADR,
    ISSUE_CISLO,
    ISSUE_EVID_CIS,
    VOLUME_CISLO,
    VOLUME_ROK,
    ISSUE_ISSVOL,
    CASTKA,
    POZNAMKA,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_CISOP,
    ZAKZAST_DATNAR,
    ZAKZAST_TITUL,
    ZAKZAST_KOR_MI,
    ZAKZAST_KOR_UL,
    ZAKZAST_KOR_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMS,
    ZAKZAST_TELEFON,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    VZDELANI,
    POCET_KUSU_TIT)
AS
select
    VYPUC.FK_VYPUC,
    VYPUC.FK_UZIV_CTEN,
    uzi.zobr_jmeno, os.PRIJMENI, os.JMENO, os.TITUL, os.TITUL_ZA,
    CTENAR.fk_pujc,
    ctenar.je_blokovan,
    ctenar.CIS_LEG,
    prim_kontakt.email,
    prim_kontakt.sms,
    CTENAR.TYP_TISK_REZE,
    CTENAR.TYP_TISK_UPOM,
    CTENAR.fk_ctenkat,
    ctenar.bar_cod,
    VYPUC.FK_ZAZ, kat1_4.fk_dokfond,
    KAT1_4.NAZEV, KAT1_4.autor, KAT1_4.nakl, KAT1_4.isbn, KAT1_4.rok_od,
    VYPUC.FK_EX, VYPUC.OZNAC, VYPUC.DAT_PROL, VYPUC.dat_vyp, VYPUC.POC_PROL, VYPUC.DAT_PROL + VYPUC.DOB_VYP, VYPUC.CENA,
    VYPUC.FK_LOKACE,
    VYPUC.FK_VYPKAT,
    VYPUC.CIS_UPOM,
    VYPUC.FK_PUJC,
    VYPUC.FK_TYPPUJC,
    UPOMINKY.DAT_GEN, UPOMINKY.DAT_TISK,
    prim_kontakt.trv_mi, prim_kontakt.trv_ul, prim_kontakt.trv_psc, prim_kontakt.trv_stat,
    kat1_5.prir_cislo,
    kat1_5.signatura,
    kat1_5.bar_cod,
    (select fk_nadr from def_pujc where id_pujc = vypuc.fk_pujc),
    (select nadr.nazev from def_pujc nadr join def_pujc podr on nadr.id_pujc = podr.fk_nadr where podr.id_pujc = vypuc.fk_pujc),
    issues.issue,
    issues.evcislo,
    volume.cis_vol,
    volume.rok_vol,
    issues.issue || '/' || volume.cis_vol,
    (select sum(castka) from platby where platby.fk_uziv_vlastnik = vypuc.fk_uziv_cten and fk_popl = 3),
    vypuc.poznamka,
    prim_kontakt.EMAIL_KOPIE,
    zak_zast.email, zak_zast.prijmeni, zak_zast.jmeno, zak_zast.trv_mi, zak_zast.trv_ul, zak_zast.trv_psc,
    zak_zast.cisop, zak_zast.datnar, ZAK_ZAST.TITUL, ZAK_ZAST.kor_MI, ZAK_ZAST.kor_UL, ZAK_ZAST.kor_PSC, ZAK_ZAST.EMAIL, ZAK_ZAST.SMS, ZAK_ZAST.TELEFON,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik,
    os.funkce, os.vzdelani,
    (select sum(zmena) from vypuc_titper where vypuc.fk_vypuc = vypuc_titper.fk_vypuc)
from vypuc  join upominky on vypuc.fk_vypuc = upominky.fk_vypuc and vypuc.cis_upom = upominky.cis_upom
            join kat1_4 on vypuc.fk_zaz = kat1_4.id_zaz
            left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
            join ctenari ctenar on vypuc.fk_uziv_cten = ctenar.fk_uziv
            join uzivatele uzi on ctenar.fk_uziv = uzi.id_uziv
            left join osoby os on os.fk_uziv = uzi.id_uziv
            left join instituce on instituce.fk_uziv = uzi.id_uziv
            join def_ctenkat on ctenar.fk_ctenkat = id_ctenkat
            join def_pujc on vypuc.fk_pujc = id_pujc
            left join issues on kat1_5.id_ex = issues.fk_ex
            left join volume on issues.fk_vol = volume.id_vol
            left join VIEW_PRIMARNI_ZASTUPCI zak_zast on ctenar.fk_uziv = zak_zast.fk_uziv
            left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenar.fk_uziv
            ^
            
CREATE OR ALTER VIEW VIEW_PRIMARNI_KONTAKTY(
    FK_UZIV,
    TRV_ADRESA,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    KOR_MI,
    KOR_UL,
    KOR_PSC,
    KOR_STAT,
    EMAIL,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    SMS,
    TELEFON)
AS
select
    uzivatel.id_uziv,
    coalesce(trv_adresa.MI, '') || coalesce(', ' || trv_adresa.UL, '') || coalesce(', ' || trv_adresa.PSC, ''), 
    trv_adresa.MI,
    trv_adresa.UL,
    trv_adresa.PSC,
    trv_adresa.STAT,
    kor_adresa.MI,
    kor_adresa.UL,
    kor_adresa.PSC,
    kor_adresa.STAT,
    (SELECT first 1 hodnota FROM uziv_kontakty email WHERE email.typ = 2 and uzivatel.id_uziv = email.fk_uziv order by poradi) as email_hodnota,
    (SELECT first 1 skip 1 hodnota FROM uziv_kontakty email_kopie WHERE email_kopie.typ = 2 and uzivatel.id_uziv = email_kopie.fk_uziv order by poradi) as email_kopie_hodnota, '',
    (SELECT first 1 hodnota FROM uziv_kontakty sms WHERE sms.typ = 0 and uzivatel.id_uziv = sms.fk_uziv order by poradi) as sms_hodnota,
    (SELECT first 1 hodnota FROM uziv_kontakty tel WHERE tel.typ = 1 and uzivatel.id_uziv = tel.fk_uziv order by poradi) as tel_hodnota
from uzivatele uzivatel
left join uziv_adresy trv_ua on trv_ua.id_uziv_adresy = (select first 1 id_uziv_adresy from uziv_adresy where je_trv = 1 and uzivatel.id_uziv = fk_uziv)
left join adresy trv_adresa on trv_ua.fk_adresy = trv_adresa.id_adresy
left join uziv_adresy kor_ua on kor_ua.id_uziv_adresy = (select first 1 id_uziv_adresy from uziv_adresy where je_kor = 1 and uzivatel.id_uziv = fk_uziv)
left join adresy kor_adresa on kor_ua.fk_adresy = kor_adresa.id_adresy
^            
            
CREATE OR ALTER VIEW VIEW_TISK_VYPUJCEK(
    ID_VYPUC,
    FK_UZIV_CTEN,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,
    CIS_LEG,
    BAR_COD_CTEN,
    EMAIL,
    MISTO,
    ULICE,
    PSC,
    ZAMESTNANI,
    FK_CTENKAT,
    FK_ZAZ,
    FK_EX,
    OZNAC,
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    POC_PROL,
    DOB_VYP,
    CENA,
    DAT_VR,
    FK_TEMSKUP,
    FK_LOKACE,
    FK_KATVYP,
    CIS_UPOM,
    ZPET_KATAL,
    FK_PUJC,
    FK_TYPPUJC,
    DATCAS,
    FK_UZIV,
    PUJCOVNA,
    FK_BUDOVA,
    BAR_COD_PRIR,
    SIGNATURA,
    PRIRUSTEK,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    FOND,
    DAT_UPOM_GEN,
    DAT_UPOM_TISK,
    UPOZ_KON_VYP,
    DAT_PREDUP,
    NEPOSILAT_PREDUPOM,
    ISSUE_ISSUE,
    ISSUE_EVID_CIS,
    ISSUE_VOLUME,
    ISSUE_ROK,
    ISSUE_ISSVOL,
    NAZEV_PUJC,
    POZNAMKA,
    TITUL_ZA,
    EMAIL_KOPIE,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    MVS_KNIHOVNA_SIGLA,
    MVS_KNIHOVNA_NAZEV,
    MVS_KNIHOVNA_MISTO,
    MVS_EVID_CISLO,
    SMSCISLO,
    ADR_ZAM,
    TELEFON,
    MOBIL,
    POCET_KUSU_TIT,
    EXEMP_POZNAMKA,
    EMAIL_ZAKZAST)
AS
select
   vypuc.FK_VYPUC, vypuc.FK_UZIV_CTEN,
   uzi.zobr_jmeno,
    os.PRIJMENI, os.JMENO, os.TITUL,
    ctenar.CIS_LEG, ctenar.BAR_COD, prim_kontakt.email,
    prim_kontakt.kor_mi, prim_kontakt.kor_ul, prim_kontakt.kor_psc,
    os.zamestnani, CTENAR.FK_CTENKAT,
    vypuc.FK_ZAZ, vypuc.FK_EX, vypuc.OZNAC, vypuc.CIS_REZE, vypuc.DAT_VYP, vypuc.DAT_PROL, vypuc.POC_PROL, vypuc.DOB_VYP, vypuc.CENA,
    vypuc.DAT_PROL + vypuc.DOB_VYP, vypuc.FK_TEMSKUP, vypuc.FK_LOKACE, vypuc.FK_VYPKAT, vypuc.CIS_UPOM, vypuc.ZPET_KATAL, vypuc.FK_PUJC, vypuc.FK_TYPPUJC, VYPUC.DATCAS,
    VYPUC.FK_UZIV,
    DEF_PUJC.NAZEV,
    DEF_PUJC.FK_NADR,
    KAT1_5.bar_cod, KAT1_5.signatura, KAT1_5.prir_cislo,
    KAT1_4.NAZEV, KAT1_4.autor, KAT1_4.nakl, KAT1_4.isbn, KAT1_4.rok_od, KAT1_4.fk_dokfond,
    case cis_upom
        when 1 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 2 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 3 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 4 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 5 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        else null
    end,
    case cis_upom
        when 1 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 2 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 3 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 4 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 5 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        else null 
    end  ,
    def_vypkat.upoz_kon_vyp, vypuc.dat_predup, ctenar.neposilat_predupom,
    coalesce(issues.issue, kat1_5.rozm_cisel),
    issues.evcislo,
    coalesce(volume.cis_vol, kat1_5.volume),
    coalesce(volume.rok_vol, kat1_5.rok_vol),
    issues.issue || '/' || volume.cis_vol,
    (select nazev from def_PUJC where id_PUJC = kat1_5.fk_PUJC),
    vypuc.poznamka, os.TITUL_ZA, prim_kontakt.EMAIL_KOPIE,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik, os.funkce,
    os.titul,
    os.jmeno,
    os.prijmeni,
    (select evid_cislo from mvs where mvs.fk_vypuc = vypuc.fk_vypuc),
    prim_kontakt.SMS,
    os.ADR_ZAM, prim_kontakt.TELEFON, prim_kontakt.SMS,
    (select sum(zmena) from vypuc_titper where vypuc.fk_vypuc = vypuc_titper.fk_vypuc), kat1_5.poznamka,
    prim_kontakt.email_zakzast
from vypuc
    left join def_pujc on vypuc.fk_pujc = def_pujc.id_pujc
    left join kat1_4 on kat1_4.id_zaz = vypuc.fk_zaz
    left join def_vypkat on vypuc.fk_vypkat = def_vypkat.id_vypkat
    left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
    join ctenari as ctenar on ctenar.fk_uziv = vypuc.fk_uziv_cten
    join uzivatele uzi on ctenar.fk_uziv = uzi.id_uziv
    left join osoby os on os.fk_uziv = uzi.id_uziv
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = vypuc.fk_uziv_cten
    left join issues on kat1_5.id_ex = issues.fk_ex
    left join volume on issues.fk_vol = volume.id_vol
    left join instituce on instituce.fk_uziv = uzi.id_uziv
^                        