alter table kat1_5 alter rozm_cisel type string_100
^

update def_gridedit_grid set delka_pole = 100 where pole = 'ROZM_CISEL'
^

execute procedure sproc_obnov_invalid('KAT1_5', 'ROZM_CISEL')
^

update def_tabcols set nazev = 'FK_LOKACE' where tabulka like '%RezervaceGrid%' and nazev = 'LOKACE'
^

CREATE OR ALTER VIEW VIEW_TISK_DODAVANYCH_TIT(
    ROK_PRIR,
    CIS_VOL,
    POC_KS,
    ZAC_DAT,
    KON_DAT,
    POZNAMKA,
    PRVNICISLO,
    NAZEV,
    NAKL,
    ISBN,
    FK_LOKACE,
    FK_DOKFOND,
    FK_UCTU,
    FK_PUJC,
    FK_STATUS,
    ISSUE,
    EVCISLO,
    FK_ZAZ,
    CENA,
    DATUM)
AS
select rok_vol.rok,
       volume.cis_vol,
       volume.poc_ks,
       volume.zac_dat,
       volume.kon_dat,
       volume.poznamka,
       volume.prvnicislo,
       kat1_4.nazev,
       kat1_4.nakl,
       kat1_4.isbn,
       kat1_5.fk_lokace,
       kat1_5.fk_dokfond,
       kat1_5.fk_uctu,
       kat1_5.fk_pujc,
       kat1_5.fk_status,
       issues.issue,
       issues.evcislo,
       kat1_4.id_zaz,
       kat1_5.cena,
       kat1_5.datum

from rok_vol, volume, issues, kat1_5, kat1_4

where rok_vol.fk_vol = volume.id_vol AND
      issues.fk_vol = rok_vol.fk_vol and
      issues.fk_ex = kat1_5.id_ex and
      kat1_4.id_zaz = volume.fk_zaz
      ^
      
CREATE OR ALTER trigger trg_seq_vypuc2 for vypuc2
active before insert position 0
as
begin
    if (new.ID_VYPUC is null or new.id_vypuc = 0) then
        new.id_vypuc = next value for seq_id_vypuc;
end
^

GRANT SELECT ON DEF_VYKONYAUT TO KATALOG
^

UPDATE OR INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR)
VALUES (40, 'EXT_ZDROJE', 'POPL_CTEN', 'Definice skriptu pro výpočet poplatku za výpujčku, který bude naúčtován čtenáři', NULL, NULL, NULL, 'SCALAR', 'INI_SCRIPT', 0)
MATCHING (FK_SEKCE, ID_KLIC)
^
