CREATE OR ALTER trigger trg_vypuc2_ad0_logvypuc for vypuc2
active before delete position 0
AS
begin

    update log_vypuc set fk_vypuc = null where fk_vypuc = old.id_vypuc;

    insert into log_vypuc (fk_VYPUC,fk_vypakce, DAT_VYP, DOBA_VYP, cis_reze, CIS_UPOM, fk_uziv_cten)
        values (NULL, 102, old.dat_vyp, old.dob_vyp, old.cis_reze, old.cis_upom, old.fk_uziv_cten);

    update platby set fk_vypuc = null where platby.fk_vypuc = old.id_vypuc;

end
^

alter table kat1_5 alter dodavatel type utf_250
^

CREATE OR ALTER VIEW VIEW_PRIMARNI_KONTAKTY(
    FK_UZIV,
    TRV_ADRESA,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    KOR_MI,
    KOR_UL,
    KOR_PSC,
    KOR_STAT,
    EMAIL,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    SMS,
    TELEFON)
AS
select
    uzivatel.id_uziv,
    coalesce(trv_adresa.MI, '') || coalesce(', ' || trv_adresa.UL, '') || coalesce(', ' || trv_adresa.PSC, ''), 
    trv_adresa.MI,
    trv_adresa.UL,
    trv_adresa.PSC,
    trv_adresa.STAT,
    kor_adresa.MI,
    kor_adresa.UL,
    kor_adresa.PSC,
    kor_adresa.STAT,
    coalesce((SELECT first 1 hodnota FROM uziv_kontakty email WHERE email.typ = 2 and uzivatel.id_uziv = email.fk_uziv order by poradi),
             (select first 1 hodnota from uziv_kontakty email join uziv_vazby on email.fk_uziv = uziv_vazby.fk_uziv_cil where uziv_vazby.fk_uziv = uzivatel.id_uziv and uziv_vazby.uziv_role = 0 and email.typ = 2 order by poradi)) as email_hodnota,
    (SELECT first 1 skip 1 hodnota FROM uziv_kontakty email_kopie WHERE email_kopie.typ = 2 and uzivatel.id_uziv = email_kopie.fk_uziv order by poradi) as email_kopie_hodnota,
    (select first 1 hodnota from uziv_kontakty email join uziv_vazby on email.fk_uziv = uziv_vazby.fk_uziv_cil where uziv_vazby.fk_uziv = uzivatel.id_uziv and uziv_vazby.uziv_role = 0 and email.typ = 2),
    coalesce((SELECT first 1 hodnota FROM uziv_kontakty sms WHERE sms.typ = 0 and uzivatel.id_uziv = sms.fk_uziv order by poradi),
             (SELECT first 1 hodnota FROM uziv_kontakty sms join uziv_vazby on sms.fk_uziv = uziv_vazby.fk_uziv_cil WHERE uziv_vazby.fk_uziv = uzivatel.id_uziv and uziv_vazby.uziv_role = 0 and sms.typ = 0 order by poradi)) as sms_hodnota,
    (SELECT first 1 hodnota FROM uziv_kontakty tel WHERE tel.typ = 1 and uzivatel.id_uziv = tel.fk_uziv order by poradi) as tel_hodnota
from uzivatele uzivatel
left join uziv_adresy trv_ua on trv_ua.id_uziv_adresy = (select first 1 id_uziv_adresy from uziv_adresy where je_trv = 1 and uzivatel.id_uziv = fk_uziv)
left join adresy trv_adresa on trv_ua.fk_adresy = trv_adresa.id_adresy
left join uziv_adresy kor_ua on kor_ua.id_uziv_adresy = (select first 1 id_uziv_adresy from uziv_adresy where je_kor = 1 and uzivatel.id_uziv = fk_uziv)
left join adresy kor_adresa on kor_ua.fk_adresy = kor_adresa.id_adresy
^