CREATE TABLE VAZBA_VYMSOUB (
    FK_VSOUB INT_NONULL,
    FK_PUJC SMALL_NOTNULL,
    FK_UZIV GENERATORY_NOTNULL,
    JE_PLATNY SMALL_NOTNULL,
    DATCAS DATETIME NOT NULL)
^

GRANT SELECT ON VAZBA_VYMSOUB TO KATALOG
^

ALTER TABLE VAZBA_VYMSOUB ADD CONSTRAINT FK_VAZBA_VYMSOUB_PUJC FOREIGN KEY (FK_PUJC) REFERENCES DEF_PUJC (ID_PUJC)
^
ALTER TABLE VAZBA_VYMSOUB ADD CONSTRAINT FK_VAZBA_VYMSOUB_UZIV FOREIGN KEY (FK_UZIV) REFERENCES UZIVATELE (ID_UZIV)
^
ALTER TABLE VAZBA_VYMSOUB ADD CONSTRAINT FK_VAZBA_VYMSOUB_VSOUB FOREIGN KEY (FK_VSOUB) REFERENCES HL_VYMSOUB (ID_VSOUB)
^

insert into vazba_vymsoub (fk_vsoub, fk_pujc, fk_uziv, je_platny, datcas)
select id_vsoub, id_pujc, 1, 1, current_timestamp from def_pujc, hl_vymsoub where je_exemp > 0 and def_pujc.je_online > 0 and hl_vymsoub.fk_uziv is null
^

insert into vazba_vymsoub (fk_vsoub, fk_pujc, fk_uziv, je_platny, datcas)
select id_vsoub, id_pujc, 1, 1, current_timestamp from def_pujc, hl_vymsoub where je_exemp > 0 and def_pujc.je_online > 0 and hl_vymsoub.fk_uziv is not null and (select uroven from def_uziv where def_uziv.fk_uziv = hl_vymsoub.fk_uziv) = 0
^

insert into vazba_vymsoub (fk_vsoub, fk_pujc, fk_uziv, je_platny, datcas)
select id_vsoub, id_pujc, hl_vymsoub.fk_uziv, 1, current_timestamp from hl_vymsoub join vaz_uziv_pujc on hl_vymsoub.fk_uziv = vaz_uziv_pujc.fk_uziv
    join def_pujc on def_pujc.id_pujc = vaz_uziv_pujc.fk_pujc
    join def_uziv on def_uziv.fk_uziv = hl_vymsoub.fk_uziv
where def_pujc.je_exemp > 0 and def_pujc.je_online > 0 and hl_vymsoub.fk_uziv is not null and def_uziv.uroven > 0
^

drop view view_hl_vymsoub
^

