drop table record_name
^

drop index UNQ_KAT1_4_RECORD
^

alter table kat1_4 drop record_id
^

drop index UNQ_KATAUT_4_RECORD
^

alter table kataut_4 drop record_id
^

drop table record
^

ALTER DOMAIN UUIDKEY ADD CHECK (VALUE = lower(VALUE))
^

ALTER DOMAIN UUIDKEY_NULL ADD CHECK (VALUE = lower(VALUE))
^

CREATE TABLE RECORD (
    ID UUIDKEY NOT NULL
)
^

ALTER TABLE RECORD ADD CONSTRAINT PK_RECORD PRIMARY KEY (ID)
^

ALTER TABLE KAT1_4 ADD RECORD_ID UUIDKEY_NULL
^

CREATE UNIQUE INDEX UNQ_KAT1_4_RECORD ON KAT1_4 (RECORD_ID)
^

alter trigger TRG_KAT1_4_BU0_SETUSER_CONTROL inactive
^

update kat1_4 set record_id = lower(uuid_to_char(gen_uuid()))
^

alter trigger TRG_KAT1_4_BU0_SETUSER_CONTROL active
^

insert into record (id) select record_id from kat1_4
^

ALTER TABLE KAT1_4 ADD CONSTRAINT FK_KAT1_4_RECORD FOREIGN KEY (RECORD_ID) REFERENCES RECORD(ID)
^

ALTER TABLE KATAUT_4 ADD RECORD_ID UUIDKEY_NULL
^

CREATE UNIQUE INDEX UNQ_KATAUT_4_RECORD ON KATAUT_4 (RECORD_ID)
^

update kataut_4 set record_id = lower(uuid_to_char(gen_uuid()))
^

insert into record (id) select record_id from kataut_4
^

ALTER TABLE kataut_4 ADD CONSTRAINT FK_KATAUT_4_RECORD FOREIGN KEY (RECORD_ID) REFERENCES RECORD(ID)
^

CREATE TABLE RECORD_NAME (
    ID UUIDKEY primary key,
    record_id UUIDKEY not null,
    name utf_250 not null,
    name_type_id small_notnull,
    flat_name string_100 not null,
    sort_name string_100 not null,
    sort_key string_1000 not null
)
^

ALTER TABLE RECORD_NAME ADD CONSTRAINT CHK_RECORD_NAME_TYPE CHECK (name_type_id in (1,2))
^

CREATE INDEX IDX_RECORD_NAME ON RECORD_NAME (NAME)
^

CREATE INDEX IDX_RECORD_NAME_TYPE_ID ON RECORD_NAME (NAME_TYPE_ID)
^

CREATE INDEX IDX_RECORD_FLAT_NAME ON RECORD_NAME (FLAT_NAME)
^

CREATE INDEX IDX_RECORD_SORT_NAME ON RECORD_NAME (SORT_NAME)
^

CREATE INDEX IDX_RECORD_SORT_KEY ON RECORD_NAME (SORT_KEY)
^

ALTER TABLE RECORD_NAME ADD CONSTRAINT FK_RECORD_NAME_RECORD FOREIGN KEY (RECORD_ID) REFERENCES RECORD (ID) ON DELETE CASCADE
^