CREATE OR ALTER VIEW VIEW_TISK_VYPUJCEK(
    ID_VYPUC,
    FK_UZIV_CTEN,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,
    CIS_LEG,
    BAR_COD_CTEN,
    EMAIL,
    MISTO,
    ULICE,
    PSC,
    MISTO_TRV,
    ULICE_TRV,
    PSC_TRV,
    ZAMESTNANI,
    FK_CTENKAT,
    FK_ZAZ,
    FK_EX,
    OZNAC,
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    POC_PROL,
    DOB_VYP,
    CENA,
    DAT_VR,
    FK_TEMSKUP,
    FK_LOKACE,
    FK_KATVYP,
    CIS_UPOM,
    ZPET_KATAL,
    FK_PUJC,
    FK_TYPPUJC,
    DATCAS,
    FK_UZIV,
    PUJCOVNA,
    FK_BUDOVA,
    BAR_COD_PRIR,
    SIGNATURA,
    PRIRUSTEK,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    FOND,
    DAT_UPOM_GEN,
    DAT_UPOM_TISK,
    UPOZ_KON_VYP,
    DAT_PREDUP,
    NEPOSILAT_PREDUPOM,
    POSILAT_PREDUPOM,
    ISSUE_ISSUE,
    ISSUE_EVID_CIS,
    ISSUE_VOLUME,
    ISSUE_ROK,
    ISSUE_ISSVOL,
    NAZEV_PUJC,
    POZNAMKA,
    TITUL_ZA,
    EMAIL_KOPIE,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    MVS_KNIHOVNA_SIGLA,
    MVS_KNIHOVNA_NAZEV,
    MVS_KNIHOVNA_MISTO,
    MVS_EVID_CISLO,
    SMSCISLO,
    ADR_ZAM,
    TELEFON,
    MOBIL,
    POCET_KUSU_TIT,
    EXEMP_POZNAMKA,
    EMAIL_ZAKZAST,
    BUDOVA)
AS
select
   vypuc.FK_VYPUC, vypuc.FK_UZIV_CTEN,
   uzi.zobr_jmeno,
    os.PRIJMENI, os.JMENO, os.TITUL,
    ctenar.CIS_LEG, ctenar.BAR_COD, prim_kontakt.email,
    prim_kontakt.kor_mi, prim_kontakt.kor_ul, prim_kontakt.kor_psc,
    prim_kontakt.trv_mi, prim_kontakt.trv_ul, prim_kontakt.trv_psc,
    os.zamestnani, CTENAR.FK_CTENKAT,
    vypuc.FK_ZAZ, vypuc.FK_EX, vypuc.OZNAC, vypuc.CIS_REZE, vypuc.DAT_VYP, vypuc.DAT_PROL, vypuc.POC_PROL, vypuc.DOB_VYP, vypuc.CENA,
    vypuc.DAT_PROL + vypuc.DOB_VYP, vypuc.FK_TEMSKUP, vypuc.FK_LOKACE, vypuc.FK_VYPKAT, vypuc.CIS_UPOM, vypuc.ZPET_KATAL, vypuc.FK_PUJC, vypuc.FK_TYPPUJC, VYPUC.DATCAS,
    VYPUC.FK_UZIV,
    DEF_PUJC.NAZEV,
    DEF_PUJC.FK_NADR,
    KAT1_5.bar_cod, KAT1_5.signatura, KAT1_5.prir_cislo,
    KAT1_4.NAZEV, KAT1_4.autor, KAT1_4.nakl, KAT1_4.isbn, KAT1_4.rok_od, KAT1_4.fk_dokfond,
    case cis_upom
        when 1 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 2 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 3 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 4 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 5 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        else null
    end,
    case cis_upom
        when 1 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 2 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 3 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 4 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 5 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        else null
    end  ,
    def_vypkat.upoz_kon_vyp, vypuc.dat_predup, ctenar.neposilat_predupom,
    coalesce((select val from uziv_prefs where uziv_prefs.fk_uziv = vypuc.fk_uziv_cten and fk_key = 9), 'true'),
    coalesce(issues.issue, kat1_5.rozm_cisel),
    issues.evcislo,
    coalesce(volume.cis_vol, kat1_5.volume),
    coalesce(volume.rok_vol, kat1_5.rok_vol),
    issues.issue || '/' || volume.cis_vol,
    (select nazev from def_PUJC where id_PUJC = kat1_5.fk_PUJC),
    vypuc.poznamka, os.TITUL_ZA, prim_kontakt.EMAIL_KOPIE,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik, os.funkce,
    os.titul,
    os.jmeno,
    os.prijmeni,
    (select evid_cislo from mvs where mvs.fk_vypuc = vypuc.fk_vypuc),
    prim_kontakt.SMS,
    os.ADR_ZAM, prim_kontakt.TELEFON, prim_kontakt.SMS,
    (select sum(zmena) from vypuc_titper where vypuc.fk_vypuc = vypuc_titper.fk_vypuc), kat1_5.poznamka,
    prim_kontakt.email_zakzast,
    (select nazev from def_pujc as budovy where budovy.id_pujc = kat1_5.fk_pujc)
from vypuc
    left join def_pujc on vypuc.fk_pujc = def_pujc.id_pujc
    left join kat1_4 on kat1_4.id_zaz = vypuc.fk_zaz
    left join def_vypkat on vypuc.fk_vypkat = def_vypkat.id_vypkat
    left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
    join ctenari as ctenar on ctenar.fk_uziv = vypuc.fk_uziv_cten
    join uzivatele uzi on ctenar.fk_uziv = uzi.id_uziv
    left join osoby os on os.fk_uziv = uzi.id_uziv
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = vypuc.fk_uziv_cten
    left join issues on kat1_5.id_ex = issues.fk_ex
    left join volume on issues.fk_vol = volume.id_vol
    left join instituce on instituce.fk_uziv = uzi.id_uziv
^
