ALTER TABLE OBALKYKNIH ADD CONSTRAINT OBALKYKNIH_PK PRIMARY KEY (FK_ZAZ)
^

create or alter procedure SPROC_SROVNEJ_REVIZI (
    CIS_REVIZE INT_NONULL,
    STR_WHERE UTF_2000)
returns (
    ID_EX GENERATORY_NULL,
    BAR_COD STRING_15,
    SIGNATURA STRING_30,
    PRIR_CISLO STRING_30,
    NAZEV UTF_250,
    STAV_REVIZE SMALL_NOTNULL,
    PORADI INT_NONULL,
    TYP_NACTENI SMALL_NULL,
    POZICE SMALL_NULL,
    TMP_PORADI INT_NULL,
    LIST_ID STRING_30000)
as
declare variable SQL_CMD UTF_2000;
declare variable POSLEDNI_POZICE INT_NONULL;
declare variable TRIDSIGN STRING_30;
declare variable POSLEDNI_PORADI INT_NONULL;
declare variable CIS_ZAZ GENERATORY;
declare variable PORADI_5 INT_NULL;
declare variable PORADI_REVI INT_NULL;
begin

    sql_cmd = 'select signatura, prir_cislo, coalesce(bar_cod, kod), coalesce(a1.poradi, 1), coalesce(fk_zaz, -1) as fk_zaz, tridsign, coalesce((select id_ex from kat1_5 k2 where SQL_WHERE and k1.id_ex = k2.id_ex), -1) as je_v_revizi, coalesce(a1.poradi, 1) as poradi_razeni, (select count(*) from kat1_5 k2 where SQL_WHERE and k1.tridsign >= k2.tridsign) as pocet_pred, a1.typ_zadani from aux_revi_CIS_REVI a1 left join kat1_5 k1 on bar_cod = kod ';
    sql_cmd = sql_cmd || ' union ';
    sql_cmd = sql_cmd || 'select signatura, prir_cislo, bar_cod, coalesce(a1.poradi, -1), fk_zaz, tridsign, id_ex, coalesce(a1.poradi, (select min(a2.poradi) from aux_revi_CIS_REVI a2 join kat1_5 k3 on k3.bar_cod = a2.kod where k3.tridsign > k1.tridsign), 999999), (select count(*) from kat1_5 k2 where SQL_WHERE and k1.tridsign >= k2.tridsign) as pocet_pred, a1.typ_zadani from kat1_5 k1 left join aux_revi_CIS_REVI a1 on k1.bar_cod = a1.kod where SQL_WHERE';
    sql_cmd = sql_cmd || ' order by 8, 6';

    sql_cmd = replace(sql_cmd, 'CIS_REVI', cis_revize);
    sql_cmd = replace(sql_cmd, 'SQL_WHERE', str_where);

    tmp_poradi = 0;
    list_id = '';
    poradi_revi = null;

    for execute statement :sql_cmd into :signatura, :prir_cislo, :bar_cod, :poradi_revi, :cis_zaz, :tridsign, :id_ex, :poradi, :poradi_5, :typ_nacteni
    do begin

        nazev = '';
        stav_revize = 10;
        select nazev from kat1_4 where id_zaz = :cis_zaz into :nazev;
        select stav_revi from pol_revi where cis_ex = :id_ex and fk_revi = :cis_revize into :stav_revize;

        list_id = 'ID_EX = ' || id_ex || ', poradi_revi = ' || poradi_revi || ', poradi_5 = ' || poradi_5 || ', cis_zaz = ' || cis_zaz;

        pozice = 0;
        /* Vubec nebyl nacteny */
        if (poradi_revi <= 0) then begin
            pozice = 1;
            tmp_poradi = tmp_poradi + 1;
        /* Nepatri do revize */
        end else if (cis_zaz <= 0) then begin
            pozice = 21;
            tmp_poradi = tmp_poradi - 1;
        /* Vubec neni v databazi */
        end else if (id_ex <= 0) then begin
            pozice = 22;
            tmp_poradi = tmp_poradi - 1;
        /* Typ nacteni je vypujcka, nebo zalozeni prirustku - to jde mimo poradi */
        end else if (typ_nacteni = 2) then begin
            pozice = 2;
        /* Poradi se shoduje s predpokladanym */
        end else if (poradi_5 = (poradi + tmp_poradi)) then begin
            pozice = 3;
        /* Poradi se je drive nez predpokladal */
        end else if (poradi_5 > (poradi + tmp_poradi)) then begin
            pozice = 11;
            if (posledni_pozice in (11, 12, 13) and poradi_5 = (posledni_poradi + 1)) then
                pozice = 12;
            if (posledni_poradi = poradi_5) then begin
                pozice = 23;
                tmp_poradi = tmp_poradi - 1;
            end
        /* Poradi se je pozdeji nez predpokladal */
        end else if (poradi_5 < (poradi + tmp_poradi)) then begin
            pozice = 15;
            if (posledni_pozice in (15, 16, 17) and poradi_5 = (posledni_poradi + 1)) then
                pozice = 16;
            if (posledni_poradi = poradi_5) then begin
                pozice = 23;
                tmp_poradi = tmp_poradi - 1;
            end
        end else begin
           pozice = -1;
        end

        posledni_pozice = pozice;
        posledni_poradi = poradi_5;
        suspend;

    end

end
^


GRANT EXECUTE ON PROCEDURE SPROC_SROVNEJ_REVIZI TO KATALOG
^

CREATE OR ALTER TRIGGER TRG_HL_REVI_BI1_CREATE FOR HL_REVI
ACTIVE BEFORE INSERT POSITION 1
AS
declare variable tab_index string_10;
declare variable sql_command string_512;
begin
    tab_index = new.id_revi;
    if (new.id_revi < 10) then tab_index = '00' || tab_index;
    else if (new.id_revi < 100) then tab_index = '0' || tab_index;

    sql_command = 'CREATE TABLE AUX_REVI_' || tab_index || ' (KOD STRING_30, POCET  SMALL_NULL, TYP_ZADANI SMALL_NULL, PORADI SMALL_NULL)';
    in autonomous transaction do
        execute statement sql_command;
    sql_command = 'GRANT SELECT ON AUX_REVI_' || tab_index || ' TO KATALOG';
    in autonomous transaction do
        execute statement sql_command;
    sql_command = 'GRANT SELECT, UPDATE, INSERT ON AUX_REVI_' || tab_index || ' TO PROCEDURE SPROC_ZAPIS_DO_REVIZE_DATA';
    in autonomous transaction do
        execute statement sql_command;
    sql_command = 'CREATE SEQUENCE SEQ_AUX_REVI_' || tab_index || ';';
    in autonomous transaction do
        execute statement sql_command;
    sql_command = 'CREATE INDEX IDX_AUX_REVI_' || tab_index || ' ON AUX_REVI_' || tab_index || ' (KOD)';
    in autonomous transaction do
        execute statement sql_command;
    sql_command = 'CREATE OR ALTER TRIGGER TRG_AUX_REVI_' || tab_index || 'BI0 FOR AUX_REVI_' || tab_index || ' ACTIVE BEFORE INSERT POSITION 0 AS begin if (new.typ_zadani is null) then new.typ_zadani = 0; if (new.poradi is null or new.poradi = 0) then new.poradi =  next value for seq_aux_revi_' || tab_index || '; end';
    in autonomous transaction do
        execute statement sql_command;
end
^


