update def_akce set
  fk_akce_nadr = 1000
  where id_akce between 10000 and 10999 and fk_akce_nadr != 1000
^

update def_akce set
  fk_akce_nadr = 2000
  where id_akce between 11000 and 11999 and fk_akce_nadr != 2000 and fk_akce_nadr != 7000
^

UPDATE OR INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR) 
VALUES (54, 'CTEN', 'SKRYT_MVS_KNIHOVNY', 'Pokud chcete skrýt MVS knihovny z modulu Čtenáři a výpůjčky - nastavte na ANO. Výchozí hodnota je NE', 1, 'NE', NULL, 'SCALAR', NULL, 0)
MATCHING (FK_SEKCE, ID_KLIC)
^

CREATE OR ALTER procedure SPROC_ZAPIS_DO_REVIZE_DATA (
    BC STRING_30,
    SG STRING_30,
    LOK STRING_20,
    PUJC SMALL_NULL,
    FOND SMALL_NOTNULL)
as
declare variable REVI_LOK STRING_512;
declare variable REVI_ID SMALL_NOTNULL;
declare variable REVI_FOND SMALL_NULL;
declare variable REVI_SG_OD STRING_30;
declare variable REVI_SG_DO STRING_30;
declare variable REVI_PUJC SMALL_NULL;
declare variable SG_OK BOOLEAN;
begin
    lok = trim(lok);
    bc = trim(bc);
    sg = trim(sg);

    for select id_revi, revi_lokace, fk_dokfond, sign_pref, sign_do, fk_pujc
        from hl_revi where status < 2
        into :revi_id, :revi_lok, :revi_fond, :revi_sg_od, :revi_sg_do, :revi_PUJC
    do begin
        revi_lok = ';' || revi_lok || ';';
        if (revi_sg_do = '') then revi_sg_do = null;
        if (revi_sg_od = '') then revi_sg_od = null;

        if (revi_fond is null or revi_fond = fond) then
        begin
            if (revi_PUJC is null or revi_PUJC = PUJC) then
            begin
                if (revi_lok is null or position(';' || lok || ';' in revi_lok) > 0) then
                begin

                    select sg_ok from sproc_revize_sign_ok(:sg, :revi_sg_od, :revi_sg_do) into :sg_ok;

                    if (sg_ok > 0) then
                    begin
                        
                        UPDATE OR INSERT INTO REVI_CAPTURE (ID_REVI_CAPTURE, FK_REVI, KOD, CIS_EX, POCET, TYP_ZADANI)
                        VALUES (0, :revi_id, :bc, NULL, 0, 2)
                        MATCHING (fk_revi, kod);

end end end end end end
^

CREATE OR ALTER procedure SPROC_REVIDUJ_EXEMP (
    ID_EX GENERATORY,
    ID_REVI SMALL_NOTNULL)
returns (
    STAV SMALL_NOTNULL)
as
declare variable BC STRING_30;
declare variable SG STRING_50;
declare variable PC STRING_30;
declare variable POCET_EX SMALL_NULL;
declare variable POCET SMALL_NULL;
declare variable TYP SMALL_NULL;
declare variable ROZDIL SMALL_NULL;
declare variable BC_VALID_LEN SMALL_NOTNULL;
begin
  /* stav 0 == nenalezen */
  STAV = 0;
  ROZDIL = 0;
  BC_VALID_LEN = 12;

  select HODNOTA
  from INI_FILE
  where FK_SEKCE = 'VYPUC' and
        FK_KLIC = 'BCVALIDLEN' and
        FK_PUJC is null
  into :BC_VALID_LEN;

  select BAR_COD, SIGNATURA, PRIR_CISLO, POCET_KS
  from KAT1_5
  where ID_EX = :ID_EX
  into :BC, :SG, :PC, :POCET_EX;

  if (POCET_EX is null) then
    POCET_EX = 0;

  if (BC is null and
      SG is null and
      PC is null) then
  begin
    suspend;
    exit;
  end
  /* Kontroloa zda je v nactenych kodech */
  for select pocet, typ_zadani from revi_capture where (kod = :bc or kod = :sg or kod = :pc or substring(kod from 1 for :BC_VALID_LEN) = :bc) and fk_revi = :id_revi
        into :POCET, :TYP
  do
  begin

    if (POCET is null) then
      POCET = 1;

    if (POCET_EX = 0) then
    begin
      if (TYP = 1) then
        STAV = 4;
      else
        STAV = 1;
      execute procedure SPROC_REVIDUJ_EXEMP_ZAPIS(:ID_EX, :ID_REVI, :STAV, 0);
      suspend;
      exit;
    end

    if (POCET_EX <= POCET) then
    begin
      if (TYP = 1) then
        STAV = 4;
      else
        STAV = 1;
      execute procedure SPROC_REVIDUJ_EXEMP_ZAPIS(:ID_EX, :ID_REVI, :STAV, 0);
      suspend;
      exit;
    end

    ROZDIL = POCET_EX - POCET;

  end

  /* Kontrola zda neni vypujcen */
  for select OZNAC
      from VYPUC
      where FK_EX = :ID_EX
      into :SG
  do
  begin

    STAV = 2;
    execute procedure SPROC_REVIDUJ_EXEMP_ZAPIS(:ID_EX, :ID_REVI, :STAV, 0);
    suspend;
    exit;

  end

  /* Kontrola vymenneho fondu */
  for select FK_LOKACE
      from POL_VYMSOUB
      where FK_EX = :ID_EX
      into :SG
  do
  begin

    STAV = 5;
    execute procedure SPROC_REVIDUJ_EXEMP_ZAPIS(:ID_EX, :ID_REVI, :STAV, 0);
    suspend;
    exit;

  end

  execute procedure SPROC_REVIDUJ_EXEMP_ZAPIS(:ID_EX, :ID_REVI, :STAV, :ROZDIL);
  suspend;
end
^

DROP TRIGGER TRG_HL_REVI_BI1_CREATE
^

drop procedure SPROC_DOPLN_PORADI_REVIZE
^