alter table log_exemp add temskup string_004
^

update log_exemp set temskup = (select fk_temskup from kat1_5 where id_ex = log_exemp.fk_ex)
^

CREATE OR ALTER trigger trg_kat1_5_ad3_logex for kat1_5
active after delete position 3
AS
begin
    insert into log_exemp (fk_ex, bar_cod, signatura, prir_cislo, lokace, kat_vyp, status, fk_pujc, fk_uziv, datcas, ip_addr, akce, fk_zaz, temskup)
    values (NULL, old.bar_cod, old.signatura, old.prir_cislo, old.fk_lokace, old.fk_vypkat, old.fk_status, old.fk_pujc,
            rdb$get_context('USER_SESSION', 'LOGGED_USER_ID'), 'NOW', rdb$get_context('SYSTEM', 'CLIENT_ADDRESS'), 'DEL', old.fk_zaz, old.fk_temskup);
end
^

CREATE OR ALTER trigger trg_kat1_5_ai3_logex for kat1_5
active after insert position 3
AS
begin

    if (new.id_ex < 0) then
        exception exc_out_of_range;
    if (new.id_ex = 0 and new.fk_zaz > 0) then
        exception exc_out_of_range;

    insert into log_exemp (fk_ex, bar_cod, signatura, prir_cislo, lokace, kat_vyp, status, fk_pujc, fk_uziv, datcas, ip_addr, akce, fk_zaz, temskup)
    values (new.id_ex, new.bar_cod, new.signatura, new.prir_cislo, new.fk_lokace, new.fk_vypkat, new.fk_status, new.fk_pujc,
            rdb$get_context('USER_SESSION', 'LOGGED_USER_ID'), 'NOW', rdb$get_context('SYSTEM', 'CLIENT_ADDRESS'), 'INS', new.fk_zaz, new.fk_temskup);
end
^

CREATE OR ALTER trigger trg_kat1_5_au3_logex for kat1_5
active after update position 3
AS
    declare variable akce string_03;
begin
    if (new.id_ex < 0) then 
      exception exc_out_of_range;
    if (new.id_ex = 0 and new.fk_zaz > 0) then 
      exception exc_out_of_range;
    if (new.fk_ubytek > 0 and old.fk_ubytek is distinct from new.fk_ubytek) then 
      akce = 'VYR';
    else 
      akce = 'UPD';
    if (new.fk_zaz != old.fk_zaz and akce = 'UPD') then 
      akce = 'TIT';
    if (new.rfid_uid != old.rfid_uid) then 
      akce = 'RID';
    if (new.id_ex > 0) then
        insert into log_exemp (fk_ex, bar_cod, signatura, prir_cislo, lokace, kat_vyp, status, fk_pujc, fk_uziv, datcas, ip_addr, akce, fk_zaz, temskup)
          values (new.id_ex, new.bar_cod, new.signatura, new.prir_cislo, new.fk_lokace, new.fk_vypkat, new.fk_status, new.fk_pujc,
          rdb$get_context('USER_SESSION', 'LOGGED_USER_ID'), 'NOW', rdb$get_context('SYSTEM', 'CLIENT_ADDRESS'), :akce, new.fk_zaz, new.fk_temskup);
end
^

CREATE OR ALTER VIEW VIEW_LOG_EXEMP(
    TYP,
    FK_EX,
    BAR_COD,
    SIGNATURA,
    PRIR_CISLO,
    LOKACE,
    KAT_VYP,
    TEMSKUP,
    STATUS,
    FK_PUJC,
    UZIVATEL,
    DATCAS,
    AKCE,
    IP_ADDR)
AS
select 1, FK_EX, BAR_COD, SIGNATURA, PRIR_CISLO,
coalesce((select nazev from def_lokace where cast(id_lokace as string_30) = LOKACE), LOKACE),
coalesce((select popis from def_vypkat where id_vypkat = KAT_VYP), KAT_VYP),
coalesce((select popis from def_temskup where id_temskup = TEMSKUP), TEMSKUP),
coalesce((select popis from def_status where id_status = STATUS), STATUS),
coalesce((select nazev from def_PUJC where id_PUJC = FK_PUJC), FK_PUJC),
coalesce((select zobr_jmeno from uzivatele uz where uz.id_uziv = log_exemp.FK_UZIV), FK_UZIV),
DATCAS, AKCE, IP_ADDR
from log_exemp
union
select 0, id_ex, bar_cod, signatura, prir_cislo,
coalesce((select nazev from def_lokace where id_lokace = fk_lokace), fk_lokace),
coalesce((select popis from def_vypkat where id_vypkat = fk_vypkat), fk_vypkat),
coalesce((select popis from def_temskup where id_temskup = fk_TEMSKUP), fk_TEMSKUP),
coalesce((select popis from def_status where id_status = fk_status), fk_STATUS),
coalesce((select nazev from def_PUJC where id_PUJC = fk_PUJC), fk_PUJC),
null,
null, null, null
from kat1_5
^


INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND) 
  VALUES (NULL, 'ZobrazHistExempForm_sgDostupnost', 12, 'TEMSKUP', 'Tem.skupina', 90, 1, 'Tematická skupina', 0)
^

create view view_seq_konfigurace (nejvyssi)
as
select max(pk_ctenkat) from def_ctenkat
union
select max(pk_ctenvyp)  from def_ctenvyp
union
select max(pk_duvubyt)  from def_duvubyt
union
select max(id_lokace)  from def_lokace
union
select max(pk_popl)  from def_popl
union
select max(id_prircis)  from def_prircis_rady
union
select max(pk_pujcovna)  from def_pujc
union
select max(id_sign)  from def_sign_rady
union
select max(pk_status)  from def_status
union
select max(pk_stavz)  from def_stavz
union
select max(pk_temskup)  from def_temskup
union
select max(id_trideni)  from def_trideni
union
select max(id_ubyt_rady)  from def_ubyt_rady
union
select max(pk_uctu)  from def_ucty
union
select max(pk_zpnab)  from def_zpnab
union
select max(pk_vypkat)  from def_vypkat
union
select max(pk_zpnahr)  from def_zpnahr
union
select max(id_svatky)  from svatky
^

update def_temskup set id_temskup = trim(id_temskup)
^

ALTER TRIGGER trg_kat1_5_aiud0_task_queue INACTIVE
^
ALTER TRIGGER trg_kat1_5_au3_logex INACTIVE
^

update kat1_5 set fk_temskup = trim(fk_temskup)
^

ALTER TRIGGER trg_kat1_5_aiud0_task_queue ACTIVE
^
ALTER TRIGGER trg_kat1_5_au3_logex ACTIVE
^
