INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE)
              VALUES (0, 'KATALOGIZACE', 'POVINNA_POLE', 'Pokud potřebujete aby systém vyžadoval vyplnit v konkrétním fondu konkretní čísla polí - nastavte jejich seznam oddělený středníkem - pozor nepoužívejte bez čísla fondu, jinak bude vyžadován stejný výčet polí v dokumentech i autoritách!', null, '', NULL)
^

INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
  select FK_UZIV,TABULKA,7,'FK_DOKFOND','Fond',SIRKA,JE_VYCHOZI,POPUP,CIS_FOND
  from def_tabcols where tabulka = 'KolekcePanel_PolKolekceGrid' and poradi = 1 and (select count(*) from def_tabcols dt2 where dt2.tabulka = 'KolekcePanel_PolKolekceGrid' and poradi = 7) = 0
^

CREATE OR ALTER TRIGGER TRG_LOG_AUTOMAT_BI0 FOR LOG_AUTOMAT
ACTIVE BEFORE INSERT POSITION 0
AS
begin

    if (new.id_log_automat is null or new.id_log_automat < 1) then
        new.id_log_automat = next value for seq_log_automat;

end
^

update def_gridedit_grid set delka_pole = 200 where tabulka = 'KAT1_5' and pole = 'DODAVATEL' and delka_pole < 200
^
update def_gridedit_grid set delka_pole = 200 where tabulka = 'KAT1_5' and pole = 'POZNAMKA' and delka_pole < 200
^

CREATE OR ALTER VIEW VIEW_VYPUC(
    ID_VYPUC,
    FK_UZIV_CTEN,
    FK_ZAZ,
    FK_EX,
    OZNAC,
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    POC_PROL,
    DOB_VYP,
    CENA,
    DAT_VR,
    FK_TEMSKUP,
    FK_LOKACE,
    FK_KATVYP,
    CIS_UPOM,
    ZPET_KATAL,
    FK_PUJC,
    FK_TYPPUJC,
    DATCAS,
    FK_UZIV,
    PUJCOVNA,
    FK_BUDOVA,
    NAZEV,
    FOND,
    POC_KS,
    DAT_PREDUP,
    DAT_UPOM_GEN,
    DAT_UPOM_TISK,
    ISSUE,
    ROK_VOL,
    VOLUME,
    PRIR_CISLO,
    SIGNATURA,
    BAR_COD,
    POZNAMKA,
    RFID_UID,
    POCET_REZE,
    VALID_PUJC)
AS
select
     vypuc.FK_VYPUC,
     vypuc.FK_UZIV_CTEN,
     vypuc.FK_ZAZ,
     vypuc.FK_EX,
     vypuc.OZNAC,
     vypuc.CIS_REZE,
     vypuc.DAT_VYP,
     vypuc.DAT_PROL,
     vypuc.POC_PROL,
     vypuc.DOB_VYP,
     vypuc.CENA,
     vypuc.DAT_PROL + vypuc.DOB_VYP,
     vypuc.FK_TEMSKUP,
     vypuc.FK_LOKACE,
     vypuc.FK_VYPKAT,
     vypuc.CIS_UPOM,
     vypuc.ZPET_KATAL,
     vypuc.FK_PUJC,
     vypuc.FK_TYPPUJC,
     VYPUC.DATCAS,
     VYPUC.FK_UZIV,
     DEF_PUJC.NAZEV,
     DEF_PUJC.FK_BUDOVA,
     KAT1_4.NAZEV,
     KAT1_4.fk_dokfond,
     case fk_typpujc
        when 1 then
            (select sum(zmena) from vypuc_titper where vypuc_titper.fk_vypuc = vypuc.fk_vypuc)
        else NULL
     end,
     VYPUC.dat_predup,
     case
        when cis_upom between 1 and 5 then
            (select first 1 upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc order by dat_gen desc)
        else null
     end,
     case
        when cis_upom between 1 and 5 then
            (select first 1 upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc order by dat_gen desc)
        else null
     end,
    coalesce(issues.issue, kat1_5.rozm_cisel),
    coalesce(volume.rok_vol, kat1_5.rok_vol),
    coalesce(volume.cis_vol, kat1_5.volume),
    kat1_5.PRIR_CISLO,
    kat1_5.SIGNATURA,
    kat1_5.BAR_COD,
    vypuc.Poznamka,
    kat1_5.rfid_uid,
    (select count(*) from vypuc rezervace where rezervace.fk_zaz = kat1_4.id_zaz and rezervace.cis_reze between 1 and 50 and rezervace.fk_ex is null),
    (select pujcovny from poz_rez where poz_rez.fk_vypuc = vypuc.fk_vypuc)
from vypuc
    left join def_pujc on vypuc.fk_pujc = def_pujc.id_pujc
    left join kat1_4 on kat1_4.id_zaz = vypuc.fk_zaz
    left join issues on vypuc.fk_ex = issues.fk_ex
    left join volume on issues.fk_vol = volume.id_vol
    left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
^

CREATE OR ALTER VIEW VIEW_TISK_REZERVACE(
    FK_VYPUC,
    FK_UZIV_CTEN,
    OZNACENI,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,
    TITUL_ZA,
    ZAMESTNANI,
    CTENAR_POZNAMKA,
    CIS_LEG,
    BAR_COD,
    FK_ZAZ,
    FK_DOKFOND,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    FK_EX,
    PRIR_CISLO,
    SIGNATURA,
    BAR_COD_EXEMP,
    CIS_REZE,
    DAT_REZE,
    ZAJEM_DO,
    FK_LOKACE,
    LOKACE,
    FK_VYPKAT,
    FK_CTENKAT,
    FK_TEMSKUP,
    TEMSKUP_NAZEV,
    VYPKAT,
    FK_PUJC,
    VYP_PUJC,
    VALID_PUJC,
    FK_PUJC_CTEN,
    CTEN_PUJC,
    KOR_MISTO,
    KOR_ULICE,
    KOR_PSC,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    EMAIL,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    SMS,
    TRIDSIGN,
    FK_BUDOVA,
    BUDOVA,
    ISSUE_CISLO,
    ISSUE_EVID_CIS,
    VOLUME_CISLO,
    VOLUME_ROK,
    ISSUE_ISSVOL,
    IP_ADDR,
    P1064,
    VYPUC_POZNAMKA,
    EXEMP_POZNAMKA,
    STAVENI,
    DAT_POZ,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    ROZSAH,
    VYBAVENI,
    STAV_ZNAK,
    VOLNE_LOKACE,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_DATNAR,
    ZAKZAST_CISOP,
    ZAKZAST_TITUL,
    ZAKZAST_PRE_MI,
    ZAKZAST_PRE_UL,
    ZAKZAST_PRE_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMSCISLO,
    ZAKZAST_TELEFON,
    MVS_DAT_POZ,
    MVS_DAT_OBJ,
    MVS_DAT_VYR,
    MVS_DAT_ODE,
    MVS_CISLO_MVS,
    MVS_EVID_CISLO,
    MVS_CENA,
    MVS_BAR_COD,
    MVS_ROCNIK,
    MVS_STRANKA,
    MVS_CLANEK,
    MVS_POZNAMKA,
    MVS_SIGNATURA,
    MVS_LZE_FOTOKOPIE,
    MVS_LZE_REZERVACE,
    MVS_LZE_PREZENCNI,
    MVS_LZE_ZAHRANICNI)
AS
select
    VYPUC.FK_VYPUC, VYPUC.FK_UZIV_CTEN, coalesce(VYPUC.oznac, (select list(distinct signatura) from kat1_5 k1 where k1.fk_zaz = vypuc.fk_zaz and k1.signatura is not null)),
    uzi.zobr_jmeno,
    os.PRIJMENI, os.JMENO, os.TITUL, os.TITUL_ZA,
    os.zamestnani, ctenar.poznamka, ctenar.CIS_LEG, ctenar.BAR_COD,
    VYPUC.FK_ZAZ,
    kat1_4.fk_dokfond, KAT1_4.NAZEV, KAT1_4.autor, KAT1_4.nakl, KAT1_4.isbn, KAT1_4.rok_od,
    VYPUC.FK_EX,
    kat1_5.prir_cislo, coalesce(kat1_5.signatura, (select first 1 signatura from kat1_5 k2 where k2.fk_zaz = vypuc.fk_zaz and k2.signatura is not null)), kat1_5.bar_cod,
    VYPUC.CIS_REZE, VYPUC.DAT_PROL, VYPUC.DAT_PROL + VYPUC.dob_vyp,
    coalesce(VYPUC.FK_LOKACE, (select list(distinct fk_lokace) from kat1_5 k_p where k_p.fk_zaz = vypuc.fk_zaz and fk_ubytek is null)),
    coalesce(DEF_LOKACE.nazev, (select list(distinct d_l.nazev) from kat1_5 k_p join def_lokace d_l on k_p.fk_lokace = d_l.id_lokace where k_p.fk_zaz = vypuc.fk_zaz and fk_ubytek is null)),
    VYPUC.FK_VYPKAT, ctenar.fk_ctenkat,
    coalesce(kat1_5.fk_temskup, (select list(distinct fk_temskup) from kat1_5 k4 where k4.fk_zaz = vypuc.fk_zaz)),
    coalesce((select popis from def_temskup where id_temskup = kat1_5.fk_temskup),
             (select list(distinct popis) from kat1_5 k4 join def_temskup on id_temskup = k4.fk_temskup where k4.fk_zaz = vypuc.fk_zaz)),
    DEF_VYPKAT.popis,
    VYPUC.FK_PUJC, DP1.nazev, POZ_REZ.pujcovny, ctenar.fk_pujc, DP2.nazev,
    prim_kontakt.kor_mi, prim_kontakt.kor_ul, prim_kontakt.kor_psc,
    CTENAR.TYP_TISK_REZE, CTENAR.TYP_TISK_UPOM, prim_kontakt.email, prim_kontakt.EMAIL_KOPIE,
    prim_zast.EMAIL,
    prim_kontakt.sms,
    KAT1_5.tridsign,
    coalesce(kat1_5.fk_PUJC, vypuc.fk_pujc),
    coalesce((select def_PUJC.nazev from def_PUJC where id_PUJC = kat1_5.fk_PUJC),
             (select def_PUJC.nazev from def_PUJC where id_pujc = vypuc.fk_pujc)),
    coalesce(issues.issue, kat1_5.rozm_cisel),
    issues.evcislo,
    coalesce(volume.cis_vol, kat1_5.volume),
    coalesce(volume.rok_vol, kat1_5.rok_vol),
    issues.issue || '/' || volume.cis_vol,
    poz_rez.ip_addr,
    cast(substrlen((select first 1 kat1_1.obsah from kat1_1 where kat1_1.fk_zaz = kat1_4.id_zaz and kat1_1.cis_pol = 1064), 3, 100) as utf_100),
    vypuc.poznamka, kat1_5.poznamka,
    cast(coalesce(substrlen((select first 1 kat1_1.obsah from kat1_1 where kat1_1.fk_zaz = kat1_4.id_zaz and kat1_1.cis_pol = 563), 3, 100), kat1_5.pomocne) as utf_100),
    poz_rez.dat_poz,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik,
    os.funkce,
    rozsah, vybaveni,
    coalesce(kat1_5.pomocne, (select list(distinct pomocne) from kat1_5 k152 join def_pujc dp152 on k152.fk_pujc = dp152.id_pujc where k152.fk_zaz = kat1_4.id_zaz and dp152.je_uk = 1 and k152.fk_ubytek is null and pomocne is not null and pomocne != '')),
    (select list(distinct def_lokace.nazev)
        from kat1_5 join def_lokace on fk_lokace = id_lokace where kat1_5.fk_zaz = vypuc.fk_zaz and (select first 1 fk_ex from vypuc where fk_ex = id_ex) is null),
    prim_zast.PRIJMENI,
    prim_zast.JMENO,
    prim_zast.MI,
    prim_zast.UL,
    prim_zast.PSC,
    prim_zast.DATNAR,
    prim_zast.CISOP,
    prim_zast.TITUL,
    prim_zast.KOR_MI,
    prim_zast.KOR_UL,
    prim_zast.KOR_PSC,
    prim_zast.EMAIL,
    prim_zast.SMS,
    prim_zast.TELEFON,
    MVS.DAT_POZ,
    MVS.DAT_OBJ,
    MVS.DAT_VYR,
    MVS.DAT_ODE,
    MVS.CISLO_MVS,
    MVS.EVID_CISLO,
    MVS.CENA,
    MVS.BAR_COD,
    MVS.ROCNIK,
    MVS.STRANKA,
    MVS.CLANEK,
    MVS.POZNAMKA,
    MVS.SIGNATURA,
    MVS.LZE_FOTOKOPIE,
    MVS.LZE_REZERVACE,
    MVS.LZE_PREZENCNI,
    MVS.LZE_ZAHRANICNI
from vypuc 
        join kat1_4 on id_zaz = vypuc.fk_zaz
        left join def_lokace on id_lokace = fk_lokace
        left join def_vypkat on id_vypkat = fk_vypkat
        join def_pujc dp1 on dp1.id_pujc = vypuc.fk_pujc
        join ctenari as ctenar on ctenar.fk_uziv = vypuc.fk_uziv_cten
        join def_ctenkat on fk_ctenkat = id_ctenkat
        join def_pujc dp2 on dp2.id_pujc = ctenar.fk_pujc
        left join  kat1_5 on vypuc.fk_ex = kat1_5.id_ex
        left join poz_rez on poz_rez.fk_vypuc = vypuc.fk_vypuc
        left join issues on kat1_5.id_ex = issues.fk_ex
        left join volume on issues.fk_vol = volume.id_vol
        left join vazba on kat1_5.id_ex = vazba.fk_ex
        join uzivatele uzi on ctenar.fk_uziv = uzi.id_uziv
        left join osoby os on os.fk_uziv = uzi.id_uziv
        left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = vypuc.fk_uziv_cten
        left join VIEW_PRIMARNI_ZASTUPCI prim_zast on prim_zast.fk_uziv = vypuc.fk_uziv_cten
        left join instituce on instituce.fk_uziv = uzi.id_uziv
        left join mvs on mvs.fk_vypuc = vypuc.fk_vypuc
^


insert into def_tabcols
select FK_UZIV,TABULKA,max(PORADI) + 1,'VALID_PUJC','Validní půjčovny',80,0,'Validní půjčovny rezervace',0
from def_tabcols dt1 where fk_uziv is null and tabulka in ('tsVypuc_grdVypuc', 'tsRezervace_grdReze', 'tsObjednavky_grdObjed') and (select count(*) from def_tabcols dt2 where dt2.tabulka = dt1.tabulka and nazev = 'VALID_PUJC') = 0
group by fk_uziv, tabulka
^

CREATE TABLE PLATBY_PLACENI_CSOB (
    RESPONSECODE       SMALL_NOTNULL,
    CASTKA             MONEY,
    TRANSACTION_TYPE   STRING_02,
    PAN                STRING_20,
    CARD_BRAND         STRING_20,
    CASOVERAZITKO      DATETIME ,
    APPROVAL_CODE      STRING_10,
    SEQUENCE_ID        STRING_10,
    DATA_TRANSAKCE     STRING_512,
    CURRENCY           STRING_03,
    JEUZAVRENO         SMALL_NOTNULL,
    FK_PLATBY_PLACENI  GENERATORY NOT NULL
)
^

ALTER TABLE PLATBY_PLACENI_CSOB ADD CONSTRAINT FK_PLATBY_PLACENI_CSOB_PLACENI FOREIGN KEY (FK_PLATBY_PLACENI) REFERENCES PLATBY_PLACENI (ID_PLATBY_PLACENI)
^

GRANT SELECT ON PLATBY_PLACENI_CSOB TO KATALOG
^
GRANT SELECT ON PLATBY_PLACENI_CSOB TO OPAC
^

CREATE OR ALTER VIEW VIEW_TISK_PLATBY(
    ID_PLATBY,
    FK_UZIV_CTEN,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,
    CIS_LEG,
    BAR_COD,
    EMAIL,
    MISTO,
    ULICE,
    PSC,
    FK_CTENKAT,
    KONEC_REGISTRACE,
    DATUM,
    CASTKA,
    POPLATEK,
    ID_POPL,
    SERVIS,
    ZAPL_NA,
    FK_UZIV,
    UZIV_JMENO,
    VRACENO,
    PUJCOVNA,
    TITUL_ZA,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    POZNAMKA,
    ID_PLATBY_PLACENI,
    PROVIDER,
    CAS_VYTVORENI,
    CAS_ZRUSENI,
    CAS_ZAPLACENI,
    CAS_REFUNDACE,
    CAS_VYPRSENI,
    GPE_RESPONSECODE,
    GPE_CASTKA,
    GPE_CASTKACASHBACK,
    GPE_AUTHORIZATIONCODE,
    GPE_PRIMARYACCOUNTNUMBER,
    GPE_CARDNAME,
    GPE_CASOVERAZITKO,
    GPE_UNIQUETRNID,
    GPE_TERMINALID,
    GPE_SEQUENCENUMBER,
    GPE_RECEIPT,
    GPE_CURRENCY,
    GPE_JEUZAVRENO,
    GOPAY_PAYMENT_ID,
    CSOB_RESPONSECODE,
    CSOB_CASTKA,
    CSOB_TRANSACTION_TYPE,
    CSOB_PAN,
    CSOB_CARD_BRAND,
    CSOB_CASOVERAZITKO,
    CSOB_APPROVAL_CODE,
    CSOB_SEQUENCE_ID,
    CSOB_DATA_TRANSAKCE,
    CSOB_CURRENCY,
    CSOB_JEUZAVRENO)
AS
select
       platby.id_platby,
       platby.fk_uziv_vlastnik,
       uzivatele.zobr_jmeno,
       coalesce(osoby.PRIJMENI, uzivatele.zobr_jmeno),
       osoby.JMENO,
       osoby.TITUL,
       ctenari.CIS_LEG,
       ctenari.BAR_COD,
       prim_kontakt.email,
       prim_kontakt.trv_MI,
       prim_kontakt.trv_UL,
       prim_kontakt.trv_PSC,
       ctenari.fk_ctenkat,
       CTENARI.kon_reg,
       platby.datum,
       platby.castka,
       (select nazev from def_popl where id_popl = platby.fk_popl),
       PLATBY.fk_popl,
       PLATBY.servis,
       PLATBY.fk_pujc,
       PLATBY.fk_uziv,
       (select zobr_jmeno from uzivatele where id_uziv = platby.fk_uziv),
       PLATBY.vraceno,
       (select nazev from def_pujc where platby.fk_pujc = id_pujc),
       osoby.TITUL_ZA,
       prim_kontakt.EMAIL_KOPIE,
       zak_zast.EMAIL,
       coalesce(CTENARI.typ_tisk_reze, 0),
       coalesce(ctenari.typ_tisk_upom, 0),
       zak_zast.prijmeni,
       zak_zast.jmeno,
       zak_zast.mi,
       zak_zast.ul,
       zak_zast.psc,
       instituce.nazev,
       instituce.ico,
       instituce.dic,
       instituce.obch_rejstrik,
       osoby.funkce,
       platby.poznamka,
       PLATBY_PLACENI.ID_PLATBY_PLACENI,
       platby_placeni.PROVIDER,
       platby_placeni.CAS_VYTVORENI,
       platby_placeni.CAS_ZRUSENI,
       platby_placeni.CAS_ZAPLACENI,
       platby_placeni.CAS_REFUNDACE,
       platby_placeni.CAS_VYPRSENI,
       platby_placeni_gpe.RESPONSECODE,
       platby_placeni_gpe.CASTKA,
       platby_placeni_gpe.CASTKACASHBACK,
       platby_placeni_gpe.AUTHORIZATIONCODE,
       platby_placeni_gpe.PRIMARYACCOUNTNUMBER,
       platby_placeni_gpe.CARDNAME,
       platby_placeni_gpe.CASOVERAZITKO,
       platby_placeni_gpe.UNIQUETRNID,
       platby_placeni_gpe.TERMINALID,
       platby_placeni_gpe.SEQUENCENUMBER,
       platby_placeni_gpe.RECEIPT,
       platby_placeni_gpe.CURRENCY,
       platby_placeni_gpe.JEUZAVRENO,
       platby_placeni_gopay.gopay_payment_id,
       platby_placeni_csob.RESPONSECODE,
       platby_placeni_csob.CASTKA,
       platby_placeni_csob.TRANSACTION_TYPE,
       platby_placeni_csob.PAN,
       platby_placeni_csob.CARD_BRAND,
       platby_placeni_csob.CASOVERAZITKO,
       platby_placeni_csob.APPROVAL_CODE,
       platby_placeni_csob.SEQUENCE_ID,
       platby_placeni_csob.DATA_TRANSAKCE,
       platby_placeni_csob.CURRENCY,
       platby_placeni_csob.JEUZAVRENO
from platby join uzivatele on uzivatele.id_uziv = platby.fk_uziv_vlastnik
       left join ctenari on ctenari.fk_uziv = platby.fk_uziv_vlastnik
       left join osoby on osoby.fk_uziv = platby.fk_uziv_vlastnik
       left join vypuc2 on fk_vypuc = id_vypuc
       left join kat1_4 on vypuc2.fk_zaz = id_zaz
       left join platby_placeni on platby.fk_platby_placeni = platby_placeni.id_platby_placeni
       left join platby_placeni_gpe on platby_placeni.id_platby_placeni = platby_placeni_gpe.fk_platby_placeni
       left join platby_placeni_gopay on platby_placeni.id_platby_placeni = platby_placeni_gopay.fk_platby_placeni
       left join platby_placeni_csob on platby_placeni.id_platby_placeni = platby_placeni_csob.fk_platby_placeni
       left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenari.fk_uziv
       left join view_primarni_zastupci zak_zast on zak_zast.fk_uziv = ctenari.fk_uziv
       left join instituce on instituce.fk_uziv = uzivatele.id_uziv
where PLATBY.castka >= 0
   or PLATBY.vraceno is not null

union

select
       platby.id_platby,
       platby.fk_uziv_vlastnik,
       uzivatele.zobr_jmeno,
       coalesce(osoby.PRIJMENI, uzivatele.zobr_jmeno),
       osoby.JMENO,
       osoby.TITUL,
       ctenari.CIS_LEG,
       ctenari.BAR_COD,
       prim_kontakt.email,
       prim_kontakt.trv_MI,
       prim_kontakt.trv_UL,
       prim_kontakt.trv_PSC,
       ctenari.fk_ctenkat,
       CTENARI.kon_reg,
       platby.vraceno,
       -1 * platby.castka,
       (select nazev from def_popl where id_popl = platby.fk_popl),
       PLATBY.fk_popl,
       PLATBY.servis,
       PLATBY.fk_pujc,
       PLATBY.fk_uziv,
       (select zobr_jmeno from uzivatele where id_uziv = platby.fk_uziv),
       PLATBY.vraceno,
       (select nazev from def_pujc where platby.fk_pujc = id_pujc),
       osoby.TITUL_ZA,
       prim_kontakt.EMAIL_KOPIE,
       zak_zast.EMAIL,
       coalesce(CTENARI.typ_tisk_reze, 0),
       coalesce(ctenari.typ_tisk_upom, 0),
       zak_zast.prijmeni,
       zak_zast.jmeno,
       zak_zast.mi,
       zak_zast.ul,
       zak_zast.psc,
       instituce.nazev,
       instituce.ico,
       instituce.dic,
       instituce.obch_rejstrik,
       osoby.funkce,
       platby.poznamka,
       PLATBY_PLACENI.ID_PLATBY_PLACENI,
       platby_placeni.PROVIDER,
       platby_placeni.CAS_VYTVORENI,
       platby_placeni.CAS_ZRUSENI,
       platby_placeni.CAS_ZAPLACENI,
       platby_placeni.CAS_REFUNDACE,
       platby_placeni.CAS_VYPRSENI,
       platby_placeni_gpe.RESPONSECODE,
       platby_placeni_gpe.CASTKA,
       platby_placeni_gpe.CASTKACASHBACK,
       platby_placeni_gpe.AUTHORIZATIONCODE,
       platby_placeni_gpe.PRIMARYACCOUNTNUMBER,
       platby_placeni_gpe.CARDNAME,
       platby_placeni_gpe.CASOVERAZITKO,
       platby_placeni_gpe.UNIQUETRNID,
       platby_placeni_gpe.TERMINALID,
       platby_placeni_gpe.SEQUENCENUMBER,
       platby_placeni_gpe.RECEIPT,
       platby_placeni_gpe.CURRENCY,
       platby_placeni_gpe.JEUZAVRENO,
       platby_placeni_gopay.gopay_payment_id,
       platby_placeni_csob.RESPONSECODE,
       platby_placeni_csob.CASTKA,
       platby_placeni_csob.TRANSACTION_TYPE,
       platby_placeni_csob.PAN,
       platby_placeni_csob.CARD_BRAND,
       platby_placeni_csob.CASOVERAZITKO,
       platby_placeni_csob.APPROVAL_CODE,
       platby_placeni_csob.SEQUENCE_ID,
       platby_placeni_csob.DATA_TRANSAKCE,
       platby_placeni_csob.CURRENCY,
       platby_placeni_csob.JEUZAVRENO
from platby join uzivatele on uzivatele.id_uziv = platby.fk_uziv_vlastnik
       left join ctenari on ctenari.fk_uziv = platby.fk_uziv_vlastnik
       left join osoby on osoby.fk_uziv = platby.fk_uziv_vlastnik
       left join vypuc2 on fk_vypuc = id_vypuc
       left join kat1_4 on vypuc2.fk_zaz = id_zaz
       left join platby_placeni on platby.fk_platby_placeni = platby_placeni.id_platby_placeni
       left join platby_placeni_gpe on platby_placeni.id_platby_placeni = platby_placeni_gpe.fk_platby_placeni
       left join platby_placeni_gopay on platby_placeni.id_platby_placeni = platby_placeni_gopay.fk_platby_placeni
       left join platby_placeni_csob on platby_placeni.id_platby_placeni = platby_placeni_csob.fk_platby_placeni
       left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenari.fk_uziv
       left join view_primarni_zastupci zak_zast on zak_zast.fk_uziv = ctenari.fk_uziv
       left join instituce on instituce.fk_uziv = uzivatele.id_uziv
where PLATBY.castka > 0
  and PLATBY.vraceno is not null
  ^
  
CREATE OR ALTER TRIGGER TRG_LOG_AUTOMAT_BI0 FOR LOG_AUTOMAT
ACTIVE BEFORE INSERT POSITION 0
AS
begin

    if (new.id_log_automat is null or new.id_log_automat < 1) then
        new.id_log_automat = next value for seq_log_automat;

end
^

INSERT INTO INI_KEYS (FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE)
              VALUES ('VYM_FOND', 'KONTROLOVAT_ZAZNAM', 'Pokud chcete, aby vás systém upozornil na skutečnost, že cílová knihovna má právě přidávaný titul ve svém fondu nastavte na ANO, výchozí hodnotou je NE - nekontrolovat', 1, 'NE', NULL)
^

CREATE OR ALTER VIEW VIEW_SMS_SEZNAM(
    ID_SMS,
    FK_UZIV_PRIJEMCE,
    NAZEV_FIRMY,
    CTENAR,
    FK_UZIV_ODESILATEL,
    KNIHOVNIK,
    TEL_CISLO,
    DATCAS_ODESLANO,
    DATCAS_PRIJATO,
    TEXT,
    STATUS,
    TYP_SMS)
AS
select
    ID_SMS,
    prijemce_uz.id_uziv,
    instituce.nazev,
    prijemce_uz.zobr_jmeno,
    odesilatel_uz.id_uziv,
    odesilatel_uz.zobr_jmeno,
    TEL_CISLO,
    DATCAS_ODESLANO,
    DATCAS_PRIJATO,
    TEXT,
    STATUS,
    TYP_SMS
from sms
join uzivatele prijemce_uz on sms.fk_uziv_prijemce = prijemce_uz.id_uziv
left join osoby prijemce_os on prijemce_os.fk_uziv = prijemce_uz.id_uziv
join uzivatele odesilatel_uz on sms.fk_uziv_odesilatel = odesilatel_uz.id_uziv
left join instituce on instituce.fk_uziv = prijemce_uz.id_uziv
^

CREATE OR ALTER VIEW VIEW_TISK_VYPUJCEK(
    ID_VYPUC,
    FK_UZIV_CTEN,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,
    CIS_LEG,
    BAR_COD_CTEN,
    EMAIL,
    MISTO,
    ULICE,
    PSC,
    MISTO_TRV,
    ULICE_TRV,
    PSC_TRV,
    ZAMESTNANI,
    FK_CTENKAT,
    FK_ZAZ,
    FK_EX,
    OZNAC,
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    POC_PROL,
    DOB_VYP,
    CENA,
    DAT_VR,
    FK_TEMSKUP,
    FK_LOKACE,
    FK_KATVYP,
    CIS_UPOM,
    ZPET_KATAL,
    FK_PUJC,
    FK_TYPPUJC,
    DATCAS,
    FK_UZIV,
    PUJCOVNA,
    FK_BUDOVA,
    BAR_COD_PRIR,
    SIGNATURA,
    PRIRUSTEK,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    FOND,
    DAT_UPOM_GEN,
    DAT_UPOM_TISK,
    UPOZ_KON_VYP,
    DAT_PREDUP,
    NEPOSILAT_PREDUPOM,
    ISSUE_ISSUE,
    ISSUE_EVID_CIS,
    ISSUE_VOLUME,
    ISSUE_ROK,
    ISSUE_ISSVOL,
    NAZEV_PUJC,
    POZNAMKA,
    TITUL_ZA,
    EMAIL_KOPIE,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    MVS_KNIHOVNA_SIGLA,
    MVS_KNIHOVNA_NAZEV,
    MVS_KNIHOVNA_MISTO,
    MVS_EVID_CISLO,
    SMSCISLO,
    ADR_ZAM,
    TELEFON,
    MOBIL,
    POCET_KUSU_TIT,
    EXEMP_POZNAMKA,
    EMAIL_ZAKZAST)
AS
select
   vypuc.FK_VYPUC, vypuc.FK_UZIV_CTEN,
   uzi.zobr_jmeno,
    os.PRIJMENI, os.JMENO, os.TITUL,
    ctenar.CIS_LEG, ctenar.BAR_COD, prim_kontakt.email,
    prim_kontakt.kor_mi, prim_kontakt.kor_ul, prim_kontakt.kor_psc,
    prim_kontakt.trv_mi, prim_kontakt.trv_ul, prim_kontakt.trv_psc,
    os.zamestnani, CTENAR.FK_CTENKAT,
    vypuc.FK_ZAZ, vypuc.FK_EX, vypuc.OZNAC, vypuc.CIS_REZE, vypuc.DAT_VYP, vypuc.DAT_PROL, vypuc.POC_PROL, vypuc.DOB_VYP, vypuc.CENA,
    vypuc.DAT_PROL + vypuc.DOB_VYP, vypuc.FK_TEMSKUP, vypuc.FK_LOKACE, vypuc.FK_VYPKAT, vypuc.CIS_UPOM, vypuc.ZPET_KATAL, vypuc.FK_PUJC, vypuc.FK_TYPPUJC, VYPUC.DATCAS,
    VYPUC.FK_UZIV,
    DEF_PUJC.NAZEV,
    DEF_PUJC.FK_NADR,
    KAT1_5.bar_cod, KAT1_5.signatura, KAT1_5.prir_cislo,
    KAT1_4.NAZEV, KAT1_4.autor, KAT1_4.nakl, KAT1_4.isbn, KAT1_4.rok_od, KAT1_4.fk_dokfond,
    case cis_upom
        when 1 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 2 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 3 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 4 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 5 then (select upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        else null
    end,
    case cis_upom
        when 1 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 2 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 3 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 4 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        when 5 then (select upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc)
        else null 
    end  ,
    def_vypkat.upoz_kon_vyp, vypuc.dat_predup, ctenar.neposilat_predupom,
    coalesce(issues.issue, kat1_5.rozm_cisel),
    issues.evcislo,
    coalesce(volume.cis_vol, kat1_5.volume),
    coalesce(volume.rok_vol, kat1_5.rok_vol),
    issues.issue || '/' || volume.cis_vol,
    (select nazev from def_PUJC where id_PUJC = kat1_5.fk_PUJC),
    vypuc.poznamka, os.TITUL_ZA, prim_kontakt.EMAIL_KOPIE,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik, os.funkce,
    os.titul,
    os.jmeno,
    os.prijmeni,
    (select evid_cislo from mvs where mvs.fk_vypuc = vypuc.fk_vypuc),
    prim_kontakt.SMS,
    os.ADR_ZAM, prim_kontakt.TELEFON, prim_kontakt.SMS,
    (select sum(zmena) from vypuc_titper where vypuc.fk_vypuc = vypuc_titper.fk_vypuc), kat1_5.poznamka,
    prim_kontakt.email_zakzast
from vypuc
    left join def_pujc on vypuc.fk_pujc = def_pujc.id_pujc
    left join kat1_4 on kat1_4.id_zaz = vypuc.fk_zaz
    left join def_vypkat on vypuc.fk_vypkat = def_vypkat.id_vypkat
    left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
    join ctenari as ctenar on ctenar.fk_uziv = vypuc.fk_uziv_cten
    join uzivatele uzi on ctenar.fk_uziv = uzi.id_uziv
    left join osoby os on os.fk_uziv = uzi.id_uziv
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = vypuc.fk_uziv_cten
    left join issues on kat1_5.id_ex = issues.fk_ex
    left join volume on issues.fk_vol = volume.id_vol
    left join instituce on instituce.fk_uziv = uzi.id_uziv
^

