CREATE OR ALTER VIEW VIEW_TISK_UBYTKY(
    ID_EX,
    FK_ZAZ,
    UBYT_PRIRC,
    SIGNATURA,
    FK_LOKACE,
    LOKACE,
    FK_VYPKAT,
    VYPKAT,
    FK_TEMSKUP,
    TEMSKUP,
    FK_UBYTEK,
    UBYT_CISLO,
    DATUM_UBYT,
    DUVOD_UBY,
    ZPUS_NAHR,
    CENA_UBY,
    CIS_PORADY,
    DATCAS,
    FK_UZIV,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    TRIDPRIC,
    TRIDSIGN,
    TRIDUBY,
    ROK_PRIR,
    FK_DOKFOND,
    FK_UCTU,
    FK_PUJC,
    PUJC,
    CENA_PRIR,
    FK_STATUS)
AS
select
kat1_5.ID_EX,
kat1_5.FK_ZAZ,
kat1_5.PRIR_CISLO,
Kat1_5.signatura,
kat1_5.FK_LOKACE,
def_lokace.nazev,
kat1_5.FK_VYPKAT,
def_vypkat.popis,
kat1_5.FK_TEMSKUP,
def_temskup.popis,
kat1_5.FK_UBYTEK,
ubytky.ubyt_cislo,
ubytky.datum_ubyt,
ubytky.duvod_uby,
ubytky.zpus_nahr,
ubytky.cena_uby,
ubytky.cis_porady,
kat1_5.DATCAS,
kat1_5.FK_UZIV,
KAT1_4.NAZEV,
KAT1_4.autor,
KAT1_4.nakl,
KAT1_4.isbn,
KAT1_4.rok_od,
kat1_5.tridpric,
kat1_5.tridsign,
ubytky.triduby,
kat1_5.rok_prir,
KAT1_4.fk_dokfond,
kat1_5.fk_uctu,
kat1_5.fk_PUJC,
(select nazev from def_PUJC where id_PUJC = kat1_5.fk_PUJC),
kat1_5.cena,
kat1_5.fk_status
from kat1_5 left join vazba on id_ex = fk_ex
join def_lokace on fk_lokace = id_lokace
join def_vypkat on fk_vypkat = id_vypkat
join def_temskup on id_temskup = fk_temskup
join ubytky on id_ubytek = fk_ubytek
join kat1_4 on kat1_5.fk_zaz = kat1_4.id_zaz
where kat1_5.typ_cisla != 1
^

CREATE OR ALTER trigger trg_mvs_zadanky_bi0_init for mvs_zadanky
active before insert position 0
AS
begin

    new.id_mvszadanky = next value for SEQ_ID_MVS_ZADANKY;
    new.dat_podani = current_timestamp;
    if (new.LZE_ZAHRANICNI is null) then
        new.LZE_ZAHRANICNI = 0;

end
^

CREATE OR ALTER VIEW VIEW_MVS_ZADANKY(
    ID_MVSZADANKY,
    JE_AKTIV,
    ZADATEL,
    DAT_PODANI,
    DAT_PREVODU,
    DAT_ZAJEMDO,
    CISLO_MVS,
    ROCNIK,
    STRANKA,
    CLANEK,
    POZNAMKA,
    SIGNATURA,
    LZE_FOTOKOPIE,
    LZE_REZERVACE,
    LZE_PREZENCNI,
    LZE_ZAHRANICNI,
    NAZEV,
    AUTOR,
    ISBN,
    NAKL,
    ROK,
    FK_PUJC_VYT)
AS
select
    ID_MVSZADANKY,
    JE_AKTIV,
    coalesce(uzc.zobr_jmeno, uzk.zobr_jmeno, ''),
    DAT_PODANI,
    DAT_PREVODU,
    DAT_ZAJEMDO,
    CISLO_MVS,
    ROCNIK,
    STRANKA,
    CLANEK,
    MVS_ZADANKY.POZNAMKA,
    SIGNATURA,
    LZE_FOTOKOPIE,
    LZE_REZERVACE,
    LZE_PREZENCNI,
    LZE_ZAHRANICNI,
    coalesce(KAT1_4.Nazev, MVS_ZADANKY.NAZEV, ''),
    coalesce(KAT1_4.Autor, MVS_ZADANKY.AUTOR, ''),
    coalesce(KAT1_4.Isbn, MVS_ZADANKY.ISBN, ''),
    coalesce(KAT1_4.nakl, MVS_ZADANKY.NAKL, ''),
    coalesce(KAT1_4.rok_od, MVS_ZADANKY.ROK, ''),
    FK_PUJC_VYT
from mvs_zadanky left join uzivatele uzc on mvs_zadanky.fk_uziv_cten = uzc.id_uziv
                 left join uzivatele uzk on mvs_zadanky.fk_uziv_knih = uzk.id_uziv
                 left join kat1_4 on mvs_zadanky.fk_zaz = id_zaz
where mvs_zadanky.dat_prevodu is null
^

GRANT SELECT ON LOG_UZIV_DIALOGS TO KATALOG
^

INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'GridFrame_ZobrGrid57', 1, 'TYP_DIALOGU', 'Typ', 40, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'GridFrame_ZobrGrid57', 2, 'DATCAS', 'Datum', 100, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'GridFrame_ZobrGrid57', 3, 'FK_UZIV', 'Knihovník', 80, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'GridFrame_ZobrGrid57', 4, 'CIS_DIALOGU', 'Dialogové okno', 200, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'GridFrame_ZobrGrid57', 5, 'POPIS', 'Popis akce', 300, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'GridFrame_ZobrGrid57', 6, 'VYSLEDEK', 'Výsledek akce', 80, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'GridFrame_ZobrGrid57', 7, 'CIS_SESSION', 'ID připojení', 80, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'GridFrame_ZobrGrid57', 8, 'TYP_DIALOGU_KOD', 'TYP_DIALOGU_KOD', 10, 0, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'GridFrame_ZobrGrid57', 9, 'VYSLEDEK_KOD', 'VYSLEDEK_KOD', 10, 0, NULL, 0)
                 ^
