UPDATE OR INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR)
  VALUES (12, 'VYPUC', 'NACESTE_DNI', 'Kolik dní zůstane kniha po vrácení na cizí budově ve stavu "na cestě". Nula znamená nikdy.', NULL, '0', NULL, 'SCALAR', NULL, 0)
^


UPDATE OR INSERT INTO DEF_STATUS (ID_STATUS, POPIS, JE_VYPUC, JE_REZE) VALUES (21, 'Na cestě', 0, 1) MATCHING (ID_STATUS)
^

CREATE TABLE NACESTE (
    FK_EX INT_NONULL,
    DATUM_IN TYPEDATE NOT NULL,
    DATUM_OUT TYPEDATE,
    FK_STATUS INT_NONULL,
    ID UUIDKEY)
^

grant select on NACESTE to OPAC
^

CREATE OR ALTER trigger naceste_bi0 for NACESTE
active before insert position 0
AS
begin
    if (new.id is null) then
        new.id=lower(uuid_to_char(gen_uuid()));
end
^

ALTER TABLE NACESTE
ADD CONSTRAINT PK_NACESTE
PRIMARY KEY (ID)
^

ALTER TABLE NACESTE
ADD CONSTRAINT FK_NACESTE_KAT1_5
FOREIGN KEY (FK_EX)
REFERENCES KAT1_5(ID_EX)
^

ALTER TABLE NACESTE
ADD CONSTRAINT FK_NACESTE_STATUS
FOREIGN KEY (FK_STATUS)
REFERENCES DEF_STATUS(ID_STATUS)
^




