CREATE OR ALTER VIEW VIEW_EXEMP_SVAZKY(
    ID_EX,
    FK_ZAZ,
    BAR_COD,
    PRIR_CISLO,
    TRIDPRIC,
    SIGNATURA,
    TRIDSIGN,
    FK_LOKACE,
    LOKACE,
    FK_VYPKAT,
    KATEGORIE,
    FK_TEMSKUP,
    TEMSKUP,
    FK_ZPNAB,
    ZPNAB,
    FK_STATUS,
    STATUS,
    DATUM,
    FK_POLFAK,
    CIS_FAK,
    FAKTURA,
    DODAVATEL,
    FK_UBYTEK,
    UBYT_CISLO,
    UBYT_DATUM,
    POZNAMKA,
    PRILOHY,
    PORADI,
    UZIVATEL,
    POMOCNE,
    CENA,
    ROK_PRIR,
    FK_PUJC,
    PUJC,
    POCET_KS,
    VOLUME,
    ROK_VOL,
    ROZM_CISEL,
    DATCAS,
    FK_UZIV,
    ROZSAH,
    VYBAVENI,
    FK_ZPUS_ZAL,
    CIS_UCTU,
    RFID_UID)
AS
select
    kat1_5.ID_EX,
    kat1_5.FK_ZAZ,
    kat1_5.BAR_COD,
    kat1_5.PRIR_CISLO,
    kat1_5.TRIDPRIC,
    kat1_5.SIGNATURA,
    kat1_5.TRIDSIGN,
    kat1_5.FK_LOKACE,
    def_lokace.nazev,
    kat1_5.FK_VYPKAT,
    def_vypkat.popis,
    kat1_5.FK_TEMSKUP,
    def_temskup.popis,
    kat1_5.FK_ZPNAB,
    def_zpnab.popis,
    kat1_5.FK_STATUS,
    def_status.popis,
    kat1_5.DATUM,
    kat1_5.FK_POLFAK,
    coalesce((select hl_fak.cis_fak_akv from pol_fak join hl_fak on pol_fak.fk_fak = hl_fak.id_fak where id_polfak = kat1_5.fk_polfak), kat1_5.CIS_FAK),
    coalesce((select hl_fak.cis_fak_akv from pol_fak join hl_fak on pol_fak.fk_fak = hl_fak.id_fak where id_polfak = kat1_5.fk_polfak), kat1_5.CIS_FAK),
    coalesce((select nazev from pol_fak join hl_fak on pol_fak.fk_fak = hl_fak.id_fak 
                                        join kataut_4 on fk_dod = id_aut where id_polfak = kat1_5.fk_polfak
             ), kat1_5.DODAVATEL),
    kat1_5.FK_UBYTEK,
    ubytky.ubyt_cislo,
    ubytky.datum_ubyt,
    kat1_5.POZNAMKA,
    kat1_5.PRILOHY,
    kat1_5.PORADI,
    kat1_5.UZIVATEL,
    kat1_5.POMOCNE,
    kat1_5.CENA,
    kat1_5.ROK_PRIR,
    kat1_5.FK_PUJC,
    def_PUJC.nazev,
    kat1_5.POCET_KS,
    kat1_5.VOLUME,
    kat1_5.ROK_VOL,
    kat1_5.ROZM_CISEL,
    kat1_5.DATCAS,
    kat1_5.FK_UZIV,
    vazba.ROZSAH,
    vazba.VYBAVENI,
    kat1_5.FK_ZPUS_ZAL,
    (select popis from def_ucty where id_uctu = kat1_5.fk_uctu),
    kat1_5.rfid_uid
from kat1_5 left join vazba on id_ex = fk_ex join def_lokace on fk_lokace = id_lokace
                 join def_vypkat on fk_vypkat = id_vypkat
                 join def_temskup on id_temskup = fk_temskup
                 join def_zpnab on id_zpnab = fk_zpnab
                 join def_status on id_status = fk_status
                 left join def_PUJC on id_PUJC = fk_PUJC
                 left join ubytky on id_ubytek = fk_ubytek
where kat1_5.typ_cisla != 1
^

alter table kat1_5 alter prilohy type string_255
^

execute procedure sproc_obnov_invalid('KAT1_5', 'PRILOHY')
^

update def_gridedit_grid set delka_pole = 250 where pole = 'PRILOHY' and delka_pole < 250
^

UPDATE OR INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA)
VALUES (6413, 'Přiřadit soubor k pobočkám', 1, 88, 6400, 0, 13)
^

UPDATE OR INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA)
VALUES (2621, 'Načti záznam přes kód svazku', 1, 87, 2600, 0, 44)
^