CREATE TABLE task_queue_event (
    RECORD_ID UUIDKEY_NULL,
    record_old_id GENERATORY_NOTNULL,
    of_authority BOOLEAN,
    create_date DATETIME NOT NULL,
    task_queue_event_type_id SMALL_NOTNULL
)
^

CREATE TABLE task_queue_event_type (
    ID SMALL_NOTNULL,
    name STRING_40 NOT NULL,
    description STRING_150 NOT NULL
)
^

ALTER TABLE task_queue_event_type ADD CONSTRAINT PK_task_queue_event_type PRIMARY KEY (ID)
^

ALTER TABLE task_queue_event_type ADD CONSTRAINT UNQ1_task_queue_event_type_name UNIQUE (name)
^

ALTER TABLE task_queue_event ADD CONSTRAINT FK_task_queue_event_type FOREIGN KEY (task_queue_event_type_id) REFERENCES task_queue_event_type(ID) USING INDEX FK_task_queue_event_type
^

insert into task_queue_event_type (ID, name, description) values (1, 'REINDEX_NE_KATX_3',  'Reindex pouze v Lucene, nedotkne se rejstříků')
^

insert into task_queue_event_type (ID, name, description) values (2, 'REINDEX',  'Kompletní reindex')
^

insert into task_queue_event_type (ID, name, description) values (3, 'REULOZENI_KATX4',  'Reuložení KAT1_4, KATAUT_4 + reindex')
^

insert into task_queue_event_type (ID, name, description) values (4, 'REULOZENI',  'Kompletní reuložení záznamu + reindex')
^

insert into task_queue_event_type (ID, name, description) values (5, 'POSLAT_DO_CI',  'Odeslání záznamu do cetralního(ch) indexu(ů)')
^

insert into task_queue_event_type (ID, name, description) values (6, 'SROVNAT_FULLTEXT', 'Scrub fulltext')
^

insert into task_queue_event_type (ID, name, description) values (8, 'POUZE_KATX_3',  'Reindex pouze rejstříky')
^

insert into task_queue_event (record_id, record_old_id, of_authority, create_date, task_queue_event_type_id) select RECORD_ID, CIS_ZAZ, JE_AUT, DATCAS, FK_TASKQUEUE_TYP from LOG_TASKQUEUE
^

drop table LOG_TASKQUEUE
^

drop table DEF_TASKQUEUE_TYP
^