<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
    <!-- NB. namespaces removed from original -->
    <!-- NB. template name="uri" not included (or imported) in this stylesheet
             template name="relatedTitle" not included (or imported) in this stylesheet
    -->
    <xsl:template match="/">
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="record">
        <!-- NB. original selected leader as attribute of record -->
        <xsl:variable name="leader" select="leader"/>
        <xsl:variable name="leader6" select="substring($leader,7,1)"/>
        <xsl:variable name="leader7" select="substring($leader,8,1)"/>
        <xsl:variable name="controlField008" select="controlfield[@tag=008]"/>

        <dc>
            <xsl:for-each select="datafield[@tag=245]">
                <title>
                    <xsl:value-of select="subfield[@code='a']"/>
                    <xsl:text></xsl:text>
                    <xsl:value-of select="subfield[@code='b']"/>
                    <xsl:text></xsl:text>
                    <xsl:value-of select="subfield[@code='f']"/>
                    <xsl:text></xsl:text>
                    <xsl:value-of select="subfield[@code='g']"/>
                    <xsl:text></xsl:text>
                    <xsl:value-of select="subfield[@code='h']"/>
                    <xsl:text></xsl:text>
                    <xsl:value-of select="subfield[@code='k']"/>
                </title>
            </xsl:for-each>


            <xsl:for-each
                    select="datafield[@tag=100]|datafield[@tag=110]|datafield[@tag=111]|datafield[@tag=700]|datafield[@tag=710]|datafield[@tag=711]|datafield[@tag=720]">
                <creator>
                    <xsl:value-of select="."/>
                </creator>
            </xsl:for-each>

            <type>
                <xsl:if test="$leader7='c'">
                    <xsl:attribute name="collection">yes</xsl:attribute>
                </xsl:if>

                <xsl:if test="$leader6='d' or $leader6='f' or $leader6='p' or $leader6='t'">
                    <xsl:attribute name="manuscript">yes</xsl:attribute>
                </xsl:if>

                <xsl:choose>
                    <xsl:when test="$leader6='a' or $leader6='t'">text</xsl:when>
                    <xsl:when test="$leader6='e' or $leader6='f'">cartographic</xsl:when>
                    <xsl:when test="$leader6='c' or $leader6='d'">notated music</xsl:when>
                    <xsl:when test="$leader6='i' or $leader6='j'">sound recording</xsl:when>
                    <xsl:when test="$leader6='k'">still image</xsl:when>
                    <xsl:when test="$leader6='g'">moving image</xsl:when>
                    <xsl:when test="$leader6='r'">three dimensional object</xsl:when>
                    <xsl:when test="$leader6='m'">software, multimedia</xsl:when>
                    <xsl:when test="$leader6='p'">mixed material</xsl:when>
                </xsl:choose>
            </type>

            <xsl:for-each select="datafield[@tag=655]">
                <type>
                    <xsl:value-of select="."/>
                </type>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=260]">
                <publisher>
                    <xsl:value-of select="subfield[@code='a']"/>
                    <xsl:value-of select="subfield[@code='b']"/>
                </publisher>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=260]/subfield[@code='c']">
                <date>
                    <xsl:value-of select="."/>
                </date>
            </xsl:for-each>

            <language>
                <xsl:value-of select="substring($controlField008,36,3)"/>
            </language>

            <xsl:for-each select="datafield[@tag=856]/subfield[@code='q']">
                <format>
                    <xsl:value-of select="."/>
                </format>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=520]">
                <description>
                    <xsl:value-of select="subfield[@code='a']"/>
                </description>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=521]">
                <description>
                    <xsl:value-of select="subfield[@code='a']"/>
                </description>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=500]">
                <description>
                    <xsl:value-of select="subfield[@code='a']"/>
                </description>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=505]">
                <description type="table of contents">

                    <!--    template not included (or imported) in this stylesheet
        <xsl:call-template name="uri"/>
                    -->
                    <xsl:value-of select="subfield[@code='a']"/>
                </description>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=511]">
                <description type="performers">

                    <!--    template not included (or imported) in this stylesheet
                            <xsl:call-template name="uri"/>
                    -->
                    <xsl:value-of select="subfield[@code='a']"/>
                </description>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=518]">
                <description type="venue">

                    <!--    template not included (or imported) in this stylesheet
                            <xsl:call-template name="uri"/>
                    -->
                    <xsl:value-of select="subfield[@code='a']"/>
                </description>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=600]">
                <subject>
                    <xsl:value-of select="subfield[@code='a']"/>
                    <xsl:value-of select="subfield[@code='b']"/>
                    <xsl:value-of select="subfield[@code='c']"/>
                    <xsl:value-of select="subfield[@code='d']"/>
                    <xsl:value-of select="subfield[@code='q']"/>
                </subject>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=610]">
                <subject>
                    <xsl:value-of select="subfield[@code='a']"/>
                    <xsl:value-of select="subfield[@code='b']"/>
                    <xsl:value-of select="subfield[@code='c']"/>
                    <xsl:value-of select="subfield[@code='d']"/>
                    <xsl:value-of select="subfield[@code='q']"/>
                </subject>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=611]">
                <subject>
                    <xsl:value-of select="subfield[@code='a']"/>
                    <xsl:value-of select="subfield[@code='b']"/>
                    <xsl:value-of select="subfield[@code='c']"/>
                    <xsl:value-of select="subfield[@code='d']"/>
                    <xsl:value-of select="subfield[@code='q']"/>
                </subject>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=630]">
                <subject>
                    <xsl:value-of select="subfield[@code='a']"/>
                    <xsl:value-of select="subfield[@code='b']"/>
                    <xsl:value-of select="subfield[@code='c']"/>
                    <xsl:value-of select="subfield[@code='d']"/>
                    <xsl:value-of select="subfield[@code='q']"/>
                </subject>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=650]">
                <subject>
                    <xsl:value-of select="subfield[@code='a']"/>
                    <xsl:value-of select="subfield[@code='b']"/>
                    <xsl:value-of select="subfield[@code='c']"/>
                    <xsl:value-of select="subfield[@code='d']"/>
                    <xsl:value-of select="subfield[@code='q']"/>
                </subject>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=653]">
                <subject>
                    <xsl:value-of select="subfield[@code='a']"/>
                    <xsl:value-of select="subfield[@code='b']"/>
                    <xsl:value-of select="subfield[@code='c']"/>
                    <xsl:value-of select="subfield[@code='d']"/>
                    <xsl:value-of select="subfield[@code='q']"/>
                </subject>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=752]">
                <coverage>
                    <geographic>
                        <country>
                            <xsl:value-of select="subfield[@code='a']"/>
                        </country>
                        <state>
                            <xsl:value-of select="subfield[@code='b']"/>
                        </state>
                        <county>
                            <xsl:value-of select="subfield[@code='c']"/>
                        </county>
                        <city>
                            <xsl:value-of select="subfield[@code='d']"/>
                        </city>
                    </geographic>
                </coverage>
            </xsl:for-each>


            <xsl:for-each select="datafield[@tag=534]">
                <relation type="original">
                    <!--    template not included (or imported) in this stylesheet
        <xsl:call-template name="relatedTitle"/>
                    -->
                    <xsl:for-each select="subfield[@code='x']">
                        <identifier type="issn">
                            <xsl:value-of select="."/>
                        </identifier>
                    </xsl:for-each>
                    <xsl:for-each select="subfield[@code='z']">
                        <identifier type="isbn">
                            <xsl:value-of select="."/>
                        </identifier>
                    </xsl:for-each>
                </relation>
            </xsl:for-each>

            <xsl:for-each
                    select="datafield[@tag=760]|datafield[@tag=762]|datafield[@tag=765]|datafield[@tag=767]|datafield[@tag=770]|datafield[@tag=772]|datafield[@tag=773]|datafield[@tag=774]|datafield[@tag=775]|datafield[@tag=776]|datafield[@tag=777]|datafield[@tag=780]|datafield[@tag=785]|datafield[@tag=786]|datafield[@tag=787]">
                <relation>
                    <xsl:value-of select="."/>
                </relation>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=856]">
                <identifier type="uri">
                    <xsl:value-of select="subfield[@code='u']"/>
                </identifier>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=506]">
                <rights type="restrictionOnAccess">
                    <xsl:value-of select="subfield[@code='a']"/>
                </rights>
            </xsl:for-each>

            <xsl:for-each select="datafield[@tag=540]">
                <rights type="useAndReproduction">
                    <xsl:value-of select="subfield[@code='a']"/>
                </rights>
            </xsl:for-each>
        </dc>
    </xsl:template>
</xsl:stylesheet><!-- Stylus Studio meta-information - (c)1998-2002 eXcelon Corp.
<metaInformation>
<scenarios ><scenario default="no" name="White House Website" userelativepaths="yes" url="..\james&#x2D;b3\house.xml" htmlbaseurl="" processortype="internal" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/><scenario default="no" name="Symphony 39" userelativepaths="yes" url="..\james&#x2D;b3\39.xml" htmlbaseurl="" processortype="internal" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/><scenario default="no" name="Buffett" userelativepaths="yes" url="..\james&#x2D;b3\buffett.xml" htmlbaseurl="" processortype="xalan" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/><scenario default="no" name="Map" userelativepaths="yes" url="..\james&#x2D;b3\map.xml" htmlbaseurl="" processortype="internal" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/><scenario default="no" name="Randy's MARC Records" userelativepaths="yes" url="..\james&#x2D;b3\modsrecs.xml" htmlbaseurl="" processortype="internal" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/><scenario default="yes" name="Frost" userelativepaths="yes" url="http://www.loc.gov/standards/marcxml/Frost/frost.xml" htmlbaseurl="" processortype="internal" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/></scenarios><MapperInfo srcSchemaPath="" srcSchemaRoot="" srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/>
</metaInformation>
-->