INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA)
              VALUES (4570, 'Nastavení Z-Serverů', 1, 77, 4400, 1, 48)
              ^
INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA)
              VALUES (4571, 'Nový server', 1, 4, 4570, 30051, 48)
              ^
INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA)
              VALUES (4572, 'Upravit', 1, 6, 4570, 30052, 48)
              ^
INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA)
              VALUES (4573, 'Smazat', 0, 8, 4570, 30053, 48)
              ^
INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA)
              VALUES (4574, 'Posunout nahoru', 1, 53, 4570, 0, 48)
              ^
INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA)
              VALUES (4575, 'Posunout dolů', 1, 54, 4570, 0, 48)
              ^

CREATE OR ALTER procedure SPROC_SLUC_AUTORITY (
    CILOVA_AUTORITA GENERATORY,
    SLUCOVANA_AUTORITA GENERATORY)
as
declare variable CIS_AUT GENERATORY;
declare variable CIS_FOND SMALL_NULL;
declare variable CIS_UZIV SMALL_NULL;
declare variable CIS_FULL_CIL INT_NULL;
declare variable CIS_FULL_SLUC INT_NULL;
declare variable CIS_IMG_CIL GENERATORY_NULL;
declare variable CIS_IMG_SLUC GENERATORY_NULL;
declare variable POSUN SMALL_NOTNULL;
begin

    select fk_autfond from kataut_4 where id_aut = :cilova_autorita into :cis_fond;
    cis_uziv = cast(rdb$get_context('USER_SESSION', 'LOGGED_USER_ID') as smallint);

    for select id_aut from kataut_4 where fk_aut = :slucovana_autorita
        into :cis_aut do
    begin
        update kat1_7 set fk_aut = :cilova_autorita where fk_aut = :cis_aut;
    end

    update kataut_4 set status4 = 99, fk_aut = :cilova_autorita where fk_aut = :slucovana_autorita;
    delete from kataut_3 where fk_aut = :slucovana_autorita;
    delete from kataut_1 where fk_aut = :slucovana_autorita;
    insert into vykony_aut values (:cis_uziv, 'NOW', :slucovana_autorita, 6, :cis_fond);

    cis_full_cil = NULL;
    cis_img_cil = NULL;
    cis_full_sluc = NULL;
    cis_img_sluc = NULL;
    select fk_fulltext_skupiny, fk_fulltext_image from kataut_4 where id_aut = :cilova_autorita into :cis_full_cil, :cis_img_cil;
    select fk_fulltext_skupiny, fk_fulltext_image from kataut_4 where id_aut = :slucovana_autorita into :cis_full_sluc, :cis_img_sluc;

    if (cis_img_cil is null and cis_img_sluc is not null) then
        update kataut_4 set fk_fulltext_image = :cis_img_sluc where id_aut = :cilova_autorita;

    if (cis_full_cil is null) then
    begin
        update kataut_4 set fk_fulltext_skupiny = :cis_full_sluc  where id_aut = :cilova_autorita;
        cis_full_cil = cis_full_sluc;
    end else begin

        posun = 0;
        select max(poradi) from fulltext_soubory where fk_fulltext_skupiny = :cis_full_cil into :posun;
        if (posun is null) then
            posun = 0;

        update fulltext_skupiny set fk_nadr = :cis_full_cil where fk_nadr = :cis_full_sluc;
        update fulltext_soubory set fk_fulltext_skupiny = :cis_full_cil, poradi = poradi + :posun where fk_fulltext_skupiny = :cis_full_sluc;

    end

end
^

INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZServerFrame_ZobrGrid54', 1, 'JE_AUTORITNI', 'Autoritní', 60, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZServerFrame_ZobrGrid54', 2, 'PORADI', 'Pořadí', 60, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZServerFrame_ZobrGrid54', 3, 'POPIS', 'Název', 180, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZServerFrame_ZobrGrid54', 4, 'ADRESA', 'Adresa', 120, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZServerFrame_ZobrGrid54', 5, 'DATABAZE', 'Databáze', 90, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZServerFrame_ZobrGrid54', 6, 'CHARSET', 'Znaková sada', 90, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZServerFrame_ZobrGrid54', 7, 'FORMAT', 'Formát', 60, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZServerFrame_ZobrGrid54', 8, 'VALIDFOND', 'Fondy', 100, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZServerFrame_ZobrGrid54', 9, 'PRENOS', 'Stahovat po..', 90, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZServerFrame_ZobrGrid54', 10, 'UZIVATEL', 'Přihlašovací jméno', 115, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZServerFrame_ZobrGrid54', 11, 'HESLO', 'Heslo', 90, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZServerFrame_ZobrGrid54', 12, 'TIMEOUT', 'Timeout', 90, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZServerFrame_ZobrGrid54', 13, 'ID_ZSERVER', 'ID_ZSERVER', 60, 0, NULL, 0)
                 ^

INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR) 
  VALUES (5, 'ZSERVERAUT_UPDATE', 'ZPRACOVATEL', 'Při zakládání nové autority do databáze Národních autorit by mělo být vyplněné pole 900 - pokud nechcete text vyplňovat ručně, nastavte jej zde', NULL, '', NULL, 'SCALAR', NULL, 0)
^
                                                                                                                     
INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR) 
  VALUES (58, 'KATALOGIZACE', 'REVIZE_VYRADITAZPODRUHE', 'Standardně revizní modul vyřazuje nenalezené svazky až poté co nejsou nalezené ve dvou po sobě jdoucích revizích (svazku), pokud chcete aby vyřazoval i při prvním nenalezení - nastavte na NE. Pokud ne - ponechte ANO', 1, 'ANO', NULL, 'SCALAR', NULL, 0)
^

alter table hl_revi add prir_od string_30
^
alter table hl_revi add prir_do string_30
^ 


INSERT INTO DEF_GRIDEDIT_FORM (ID_GRIDEDIT_FORM, JAZYK, CAPTION, WIDTH, FIXED_WIDTH, OK_HINT, KO_HINT) VALUES (4571, 'cze', 'Nastavení Z-Serveru', 450, 150, NULL, NULL)
^

INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4571, 'cze', 1, 'DEF_ZSERVER', 'JE_AUTORITNI', 'Autoritní?', 6, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4571, 'cze', 2, 'DEF_ZSERVER', 'PORADI', 'Pořadí', 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4571, 'cze', 3, 'DEF_ZSERVER', 'POPIS', 'Popis', 1, NULL, NULL, NULL, NULL, NULL, 100, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4571, 'cze', 4, 'DEF_ZSERVER', 'ADRESA', 'Adresa', 1, NULL, NULL, NULL, NULL, NULL, 255, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4571, 'cze', 5, 'DEF_ZSERVER', 'DATABAZE', 'Databáze', 1, NULL, NULL, NULL, NULL, NULL, 255, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4571, 'cze', 6, 'DEF_ZSERVER', 'CHARSET', 'Znaková sada', 1, 'INI_VALHOD', 'OBSAH', 'POPIS', 'ID_VALHOD = 20', 'PORADI', 10, 0, NULL, NULL, NULL, 'UTF8')
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4571, 'cze', 7, 'DEF_ZSERVER', 'FORMAT', 'Formát', 1, 'INI_VALHOD', 'OBSAH', 'POPIS', 'ID_VALHOD = 21', 'POPIS', 10, 0, NULL, NULL, NULL, 'ISO2709')
                       ^ 
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4571, 'cze', 8, 'DEF_ZSERVER', 'VALIDFOND', 'Validní fondy', 7, 'DEF_FOND', 'ID_FOND', 'NAZEV', 'JE_AUTORITNI = 0', 'PORADI', 100, 0, NULL, NULL, ',', NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4571, 'cze', 9, 'DEF_ZSERVER', 'PRENOS', 'Stahovat po...', 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, '50')
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4571, 'cze', 10, 'DEF_ZSERVER', 'UZIVATEL', 'Přihlašovací jméno', 1, NULL, NULL, NULL, NULL, NULL, 100, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4571, 'cze', 11, 'DEF_ZSERVER', 'HESLO', 'Heslo', 1, NULL, NULL, NULL, NULL, NULL, 100, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4571, 'cze', 12, 'DEF_ZSERVER', 'TIMEOUT', 'Timeout', 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL)
                       ^