ALTER TABLE VYPUC2 DROP CONSTRAINT FK_VYPUC2_CTEN
^

UPDATE CTENARI SET DATUM_SMAZ='25.5.2018' WHERE DATUM_SMAZ IS NULL AND JE_POVOL=0
^

ALTER TABLE SKRIPT ADD    FK_TRIDA       SMALL_NOTNULL NOT NULL
^

ALTER TABLE SKRIPT ADD    UUID           STRING_40
^

ALTER TABLE SKRIPT ADD    SYSTEMOVY      SMALL_NOTNULL DEFAULT 0
^

CREATE TABLE DEF_SKRIPT_TRIDA (
    ID_SKRIPT_TRIDA  SMALL_NOTNULL NOT NULL /* SMALL_NOTNULL = SMALLINT DEFAULT 0 NOT NULL */,
    TRIDA            STRING_150 /* STRING_150 = VARCHAR(150) */,
    NAZEV            STRING_100 /* STRING_100 = VARCHAR(100) */,
    POPISEK          STRING_2048 /* STRING_2048 = VARCHAR(2048) */,
    SABLONA          UTF_8000 /* UTF_8000 = VARCHAR(8000) */
)
^

ALTER TABLE DEF_SKRIPT_TRIDA ADD CONSTRAINT UNQ_DEF_SKRIPT_TRIDA_TRIDA UNIQUE (TRIDA)
^

ALTER TABLE DEF_SKRIPT_TRIDA ADD CONSTRAINT DEF_SKRIPT_TRIDA_PK PRIMARY KEY (ID_SKRIPT_TRIDA)
^

COMMENT ON COLUMN DEF_SKRIPT_TRIDA.SABLONA IS 
'Sablona, do ktere se vlozi konkretni implementace. Je mozno importovat namespacy, pripadne delat dalsi wifikundace

Kod se vlozi na misto oznacene jako #KOD#, pripadne se pripoji na konec sablony pokud sekvence #KOD# neexistuje'
^

GRANT ALL ON DEF_SKRIPT_TRIDA TO SQLKPWIN WITH GRANT OPTION
^

INSERT INTO DEF_SKRIPT_TRIDA (ID_SKRIPT_TRIDA, TRIDA, NAZEV, POPISEK, SABLONA) VALUES (0, 'java.lang.Object', 'ROOT', 'Generická metoda vracející cokoliv', NULL)
^
INSERT INTO DEF_SKRIPT_TRIDA (ID_SKRIPT_TRIDA, TRIDA, NAZEV, POPISEK, SABLONA) VALUES (1, 'cz.kpsys.db.cpk.GeneratorPolePrirustky', 'Generátor polí s přírůstky', 'Využití hlavně pro CPK', NULL)
^
INSERT INTO DEF_SKRIPT_TRIDA (ID_SKRIPT_TRIDA, TRIDA, NAZEV, POPISEK, SABLONA) VALUES (2, 'cz.kpsys.db.GeneratorRezuInterface', 'Obecné rozhraní pro generátor řezů', 'Umožní definovat CUSTOM generátor řezu ve Scale', NULL)
^

UPDATE SKRIPT SET FK_TRIDA=1 WHERE IDENTIFIKATOR='cz.kpsys.db.cpk.GeneratorPolePrirustky'
^
UPDATE SKRIPT SET FK_TRIDA=2 WHERE IDENTIFIKATOR='cz.kpsys.db.GeneratorRezuInterface'
^
UPDATE SKRIPT SET FK_TRIDA=0 WHERE FK_TRIDA IS NULL
^


ALTER TABLE SKRIPT
ADD CONSTRAINT SKRIPT_FK_TRIDA
FOREIGN KEY (FK_TRIDA)
REFERENCES DEF_SKRIPT_TRIDA(ID_SKRIPT_TRIDA)
ON UPDATE CASCADE
USING INDEX SKRIPT_FK_TRIDA
^






