ALTER TRIGGER TRG_CTEN_AUPD0_LOGCTEN INACTIVE
^
delete from stat_verdenik where datum in (select dat_reg from ctenari where dat_reg > '1.1.2018' and dat_obnov is null)
^
insert into log_cten (datum, akce, hodnota, fk_uziv_cten)
select dat_reg, 'OBNC', dat_reg, fk_uziv from ctenari where dat_reg > '1.1.2018' and dat_obnov is null
^
update ctenari set dat_obnov = dat_reg where dat_reg > '1.1.2018' and dat_obnov is null
^
ALTER TRIGGER TRG_CTEN_AUPD0_LOGCTEN ACTIVE
^

alter VIEW VIEW_TISK_PLATBY (ID_PLATBY, FK_UZIV_CTEN, CTENAR, PRIJMENI, JMENO, TITUL, CIS_LEG, BAR_COD, EMAIL, MISTO, ULICE, PSC, FK_CTENKAT, KONEC_REGISTRACE, DATUM, CASTKA, POPLATEK, ID_POPL, SERVIS, ZAPL_NA, FK_UZIV, UZIV_JMENO, VRACENO, PUJCOVNA, 
TITUL_ZA, EMAIL_KOPIE, EMAIL_ZAKZAST, TYP_TISK_REZE, TYP_TISK_UPOM, ZAKZAST_PRIJMENI, ZAKZAST_JMENO, ZAKZAST_MI, ZAKZAST_UL, ZAKZAST_PSC, NAZEV_FIRMY, ICO, DIC, OBCH_REJSTRIK, FUNKCE, POZNAMKA, 
ID_PLATBY_PLACENI, PROVIDER, CAS_VYTVORENI, CAS_ZRUSENI, CAS_ZAPLACENI, CAS_REFUNDACE, CAS_VYPRSENI, GPE_RESPONSECODE, GPE_CASTKA, GPE_CASTKACASHBACK, GPE_AUTHORIZATIONCODE, GPE_PRIMARYACCOUNTNUMBER, GPE_CARDNAME, GPE_CASOVERAZITKO, GPE_UNIQUETRNID, GPE_TERMINALID, GPE_SEQUENCENUMBER, GPE_RECEIPT, GPE_CURRENCY, GPE_JEUZAVRENO, GOPAY_PAYMENT_ID)
AS 
select
       platby.id_platby,
       platby.fk_uziv_vlastnik,
       osoby.PRIJMENI || coalesce(' ' || osoby.JMENO, '') || coalesce(' ' || osoby.TITUL, ''),
       osoby.PRIJMENI,
       osoby.JMENO,
       osoby.TITUL,
       ctenari.CIS_LEG,
       ctenari.BAR_COD,
       prim_kontakt.email,
       prim_kontakt.trv_MI,
       prim_kontakt.trv_UL,
       prim_kontakt.trv_PSC,
       ctenari.fk_ctenkat,
       CTENARI.kon_reg,
       platby.datum,
       platby.castka,
       (select nazev from def_popl where id_popl = platby.fk_popl),
       PLATBY.fk_popl,
       PLATBY.servis,
       PLATBY.fk_pujc,
       PLATBY.fk_uziv,
       (select zobr_jmeno from uzivatele where id_uziv = platby.fk_uziv),
       PLATBY.vraceno,
       (select nazev from def_pujc where platby.fk_pujc = id_pujc),
       osoby.TITUL_ZA,
       prim_kontakt.EMAIL_KOPIE,
       zak_zast.EMAIL,
       CTENARI.typ_tisk_reze,
       ctenari.typ_tisk_upom,
       zak_zast.prijmeni,
       zak_zast.jmeno,
       zak_zast.mi,
       zak_zast.ul,
       zak_zast.psc,
       instituce.nazev,
       instituce.ico,
       instituce.dic,
       instituce.obch_rejstrik,
       osoby.funkce,
       platby.poznamka,
       PLATBY_PLACENI.ID_PLATBY_PLACENI,
       platby_placeni.PROVIDER,
       platby_placeni.CAS_VYTVORENI,
       platby_placeni.CAS_ZRUSENI,
       platby_placeni.CAS_ZAPLACENI,
       platby_placeni.CAS_REFUNDACE,
       platby_placeni.CAS_VYPRSENI,
       platby_placeni_gpe.RESPONSECODE,
       platby_placeni_gpe.CASTKA,
       platby_placeni_gpe.CASTKACASHBACK,
       platby_placeni_gpe.AUTHORIZATIONCODE,
       platby_placeni_gpe.PRIMARYACCOUNTNUMBER,
       platby_placeni_gpe.CARDNAME,
       platby_placeni_gpe.CASOVERAZITKO,
       platby_placeni_gpe.UNIQUETRNID,
       platby_placeni_gpe.TERMINALID,
       platby_placeni_gpe.SEQUENCENUMBER,
       platby_placeni_gpe.RECEIPT,
       platby_placeni_gpe.CURRENCY,
       platby_placeni_gpe.JEUZAVRENO,
       platby_placeni_gopay.gopay_payment_id
from platby
       join ctenari on ctenari.fk_uziv = platby.fk_uziv_vlastnik
       join uzivatele on uzivatele.id_uziv = ctenari.fk_uziv
       join osoby on osoby.fk_uziv = ctenari.fk_uziv
       left join vypuc2 on fk_vypuc = id_vypuc
       left join kat1_4 on vypuc2.fk_zaz = id_zaz
       left join platby_placeni on platby.fk_platby_placeni = platby_placeni.id_platby_placeni
       left join platby_placeni_gpe on platby_placeni.id_platby_placeni = platby_placeni_gpe.fk_platby_placeni
       left join platby_placeni_gopay on platby_placeni.id_platby_placeni = platby_placeni_gopay.fk_platby_placeni
       left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenari.fk_uziv
       left join view_primarni_zastupci zak_zast on zak_zast.fk_uziv = ctenari.fk_uziv
       left join instituce on instituce.fk_uziv = uzivatele.id_uziv
where PLATBY.castka >= 0
   or PLATBY.vraceno is not null

union

select
       platby.id_platby,
       platby.fk_uziv_vlastnik,
       osoby.PRIJMENI || coalesce(' ' || osoby.JMENO, '') || coalesce(' ' || osoby.TITUL, ''),
       osoby.PRIJMENI,
       osoby.JMENO,
       osoby.TITUL,
       ctenari.CIS_LEG,
       ctenari.BAR_COD,
       prim_kontakt.email,
       prim_kontakt.trv_MI,
       prim_kontakt.trv_UL,
       prim_kontakt.trv_PSC,
       ctenari.fk_ctenkat,
       CTENARI.kon_reg,
       platby.vraceno,
       -1 * platby.castka,
       (select nazev from def_popl where id_popl = platby.fk_popl),
       PLATBY.fk_popl,
       PLATBY.servis,
       PLATBY.fk_pujc,
       PLATBY.fk_uziv,
       (select zobr_jmeno from uzivatele where id_uziv = platby.fk_uziv),
       PLATBY.vraceno,
       (select nazev from def_pujc where platby.fk_pujc = id_pujc),
       osoby.TITUL_ZA,
       prim_kontakt.EMAIL_KOPIE,
       zak_zast.EMAIL,
       CTENARI.typ_tisk_reze,
       ctenari.typ_tisk_upom,
       zak_zast.prijmeni,
       zak_zast.jmeno,
       zak_zast.mi,
       zak_zast.ul,
       zak_zast.psc,
       instituce.nazev,
       instituce.ico,
       instituce.dic,
       instituce.obch_rejstrik,
       osoby.funkce,
       platby.poznamka,
       PLATBY_PLACENI.ID_PLATBY_PLACENI,
       platby_placeni.PROVIDER,
       platby_placeni.CAS_VYTVORENI,
       platby_placeni.CAS_ZRUSENI,
       platby_placeni.CAS_ZAPLACENI,
       platby_placeni.CAS_REFUNDACE,
       platby_placeni.CAS_VYPRSENI,
       platby_placeni_gpe.RESPONSECODE,
       platby_placeni_gpe.CASTKA,
       platby_placeni_gpe.CASTKACASHBACK,
       platby_placeni_gpe.AUTHORIZATIONCODE,
       platby_placeni_gpe.PRIMARYACCOUNTNUMBER,
       platby_placeni_gpe.CARDNAME,
       platby_placeni_gpe.CASOVERAZITKO,
       platby_placeni_gpe.UNIQUETRNID,
       platby_placeni_gpe.TERMINALID,
       platby_placeni_gpe.SEQUENCENUMBER,
       platby_placeni_gpe.RECEIPT,
       platby_placeni_gpe.CURRENCY,
       platby_placeni_gpe.JEUZAVRENO,
       platby_placeni_gopay.gopay_payment_id
from platby
       join ctenari on ctenari.fk_uziv = platby.fk_uziv_vlastnik
       join uzivatele on uzivatele.id_uziv = ctenari.fk_uziv
       join osoby on osoby.fk_uziv = ctenari.fk_uziv
       left join vypuc2 on fk_vypuc = id_vypuc
       left join kat1_4 on vypuc2.fk_zaz = id_zaz
       left join platby_placeni on platby.fk_platby_placeni = platby_placeni.id_platby_placeni
       left join platby_placeni_gpe on platby_placeni.id_platby_placeni = platby_placeni_gpe.fk_platby_placeni
       left join platby_placeni_gopay on platby_placeni.id_platby_placeni = platby_placeni_gopay.fk_platby_placeni
       left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenari.fk_uziv
       left join view_primarni_zastupci zak_zast on zak_zast.fk_uziv = ctenari.fk_uziv
       left join instituce on instituce.fk_uziv = uzivatele.id_uziv
where PLATBY.castka > 0
  and PLATBY.vraceno is not null
^


INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA) VALUES (6411, 'Importovat VF soubor', 1, 38, 6400, 0, 13)
^
INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA) VALUES (6412, 'Odstranit VF soubor a smazat exempláře z databáze', 1, 67, 6400, 0, 13)
^

alter table kat1_5 alter signatura type string_50
^

execute procedure sproc_obnov_invalid ( 'KAT1_5', 'SIGNATURA' )
^

alter table log_exemp alter signatura type string_50
^
execute procedure sproc_obnov_invalid ( 'LOG_EXEMP', 'SIGNATURA' )
^

CREATE OR ALTER trigger trg_kat1_5_ai6_revize for kat1_5
active after insert position 6
AS declare variable bc string_50;
begin
    bc = new.bar_cod;
    if (bc is null) then bc = new.prir_cislo;
    if (bc is null) then bc = substring(new.signatura from 1 for 30);
    if (bc is not null)
    then
        execute procedure sproc_zapis_do_revize_data(:bc, substring(new.signatura from 1 for 30), new.fk_lokace, new.fk_pujc, new.fk_dokfond);
end
^

CREATE OR ALTER procedure SPROC_ZAPIS_DO_REVIZE (
    ID_EX GENERATORY_NOTNULL)
as
declare variable BC STRING_30;
declare variable SG STRING_50;
declare variable PC STRING_30;
declare variable LOK STRING_20;
declare variable PUJC SMALL_NULL;
declare variable FOND SMALL_NULL;
begin
    bc = null;

    select bar_cod, signatura, prir_cislo, fk_lokace, fk_PUJC, fk_dokfond from kat1_5 where id_ex = :id_ex
        into :bc, :sg, :pc, :lok, :PUJC, :fond;

    sg = substring(sg from 1 for 30);

    if (bc is null) then
        bc = pc;
    if (bc is null) then
        bc = sg;
    if (bc is not null) then
    begin
        execute procedure sproc_zapis_do_revize_data(:bc, :sg, :lok, :PUJC, :fond);
    end
end
^

CREATE OR ALTER procedure SPROC_SHOW_POLVYMSOUB (
    SOUB_ID INT_NULL)
returns (
    PRIR_CISLO STRING_50,
    FK_PUJC SMALL_NULL,
    PORADI SMALL_NULL,
    POCET_DNI SMALL_NULL,
    DATUM_IN TYPEDATE,
    DATUM_OUT TYPEDATE,
    NAZEV_PUJC STRING_50,
    NAZEV UTF_250,
    ID_ZAZ INT_NULL,
    ID_EX INT_NULL,
    TRIDNAZ STRING_100)
as
BEGIN
FOR
    select id_ex, coalesce(prir_cislo, signatura, bar_cod), nazev, id_zaz, tridnaz
        from pol_vymsoub join kat1_5 on pol_vymsoub.fk_ex = kat1_5.id_ex
        join kat1_4 on kat1_5.fk_zaz = kat1_4.id_zaz
        where fk_vsoub = :soub_id into :id_ex, :prir_cislo, :nazev, :id_zaz, :tridnaz
    do begin
        FK_PUJC = null;
        PORADI = null;
        POCET_DNI = null;
        DATUM_IN = null;
        DATUM_OUT = null;
        NAZEV_PUJC = null;

        select fk_PUJC, pol_vymfond.poradi, pocet_dni, datum_in, NAZEV
            from pol_vymfond join def_PUJC on fk_PUJC = id_PUJC
            where fk_ex = :id_ex and aktivni = 1
            into :fk_pujc, :poradi, :pocet_dni, :datum_in, :NAZEV_PUJC;
        DATUM_OUT = DATUM_IN + POCET_DNI;

        SUSPEND;
    END
END
^

alter table pol_revi alter signatura type string_50
^

execute procedure sproc_obnov_invalid ('POL_REVI', 'SIGNATURA')
^

CREATE OR ALTER procedure SPROC_REVIDUJ_EXEMP (
    ID_EX GENERATORY,
    ID_REVI SMALL_NOTNULL)
returns (
    STAV SMALL_NOTNULL)
as
declare variable BC STRING_30;
declare variable SG STRING_50;
declare variable PC STRING_30;
declare variable POCET_EX SMALL_NULL;
declare variable SQL_COMMAND STRING_512;
declare variable POCET SMALL_NULL;
declare variable TYP SMALL_NULL;
declare variable AUX_TAB STRING_40;
declare variable ROZDIL SMALL_NULL;
declare variable BC_VALID_LEN SMALL_NOTNULL;
begin
    /* stav 0 == nenalezen */
    stav = 0;
    rozdil = 0;
    aux_tab = 'AUX_REVI_';
    bc_valid_len = 12;
    if (id_revi < 10) then aux_tab = aux_tab || '0';
    if (id_revi < 100) then aux_tab = aux_tab || '0';
    aux_tab = aux_tab || id_revi;

    select hodnota from ini_file where fk_sekce = 'VYPUC' and fk_klic = 'BCVALIDLEN' and fk_pujc is null
        into :bc_valid_len;

    select bar_cod, signatura, prir_cislo, pocet_ks from kat1_5 where id_ex = :id_ex
        into :bc, :sg, :pc, :pocet_ex;

    if (pocet_ex is null) then
        pocet_ex = 0;

    if (bc is null and sg is null and pc is null) then begin
        suspend;
        exit;
    end
    /* Kontroloa zda je v nactenych kodech */
    sql_command = 'select pocet, typ_zadani from ' || aux_tab || ' where kod = ? or kod = ? or kod = ? or substring(kod from 1 for ' || bc_valid_len || ') = ?';
    for execute statement (sql_command) (bc, sg, pc, bc) into :pocet, :typ do begin

        if (pocet is null) then
            pocet = 1;

        if (pocet_ex = 0) then begin
            if (typ = 1) then
                stav = 4;
            else
                stav = 1;
            execute procedure sproc_reviduj_exemp_zapis (:id_ex, :id_revi, :stav, 0 );
            suspend;
            exit;
        end

        if (pocet_ex <= pocet) then begin
            if (typ = 1) then
                stav = 4;
            else
                stav = 1;
            execute procedure sproc_reviduj_exemp_zapis (:id_ex, :id_revi, :stav, 0 );
            suspend;
            exit;
        end

        rozdil = pocet_ex - pocet;

    end

    /* Kontrola zda neni vypujcen */
    for select oznac from vypuc where fk_ex = :id_ex into :sg
    do begin

        stav = 2;
        execute procedure sproc_reviduj_exemp_zapis (:id_ex, :id_revi, :stav, 0 );
        suspend;
        exit;

    end

    /* Kontrola vymenneho fondu */
    for select fk_lokace from pol_vymsoub where fk_ex = :id_ex into :sg
    do begin

        stav = 5;
        execute procedure sproc_reviduj_exemp_zapis (:id_ex, :id_revi, :stav, 0 );
        suspend;
        exit;

    end

    execute procedure sproc_reviduj_exemp_zapis (:id_ex, :id_revi, :stav, :rozdil );
    suspend;
end
^

CREATE INDEX IDX_LOG_EXEMP_EX ON LOG_EXEMP (FK_EX)
^
