alter table kat1_5 alter prilohy type utf_121
^

execute procedure sproc_obnov_invalid('KAT1_5', 'PRILOHY')
^

update def_gridedit_grid set
delka_pole = 120
where pole = 'PRILOHY'
^

CREATE OR ALTER VIEW VIEW_LOG_IN_USERS(
    SESSION_ID,
    UZIV_ID,
    UZIV_JMENO,
    UZIV_TISK,
    UZIV_UROVEN,
    LOGIN_TIME,
    POSL_CAS,
    CLIENT_IP,
    SVN_CISLO,
    CIS_PUJC,
    verze_verbis,
    ID_PRIPOJ)
AS
select
    id,
    uz.id_uziv,
    uz.username,
    uz.zobr_jmeno,
    uz_knih.uroven,
    login_time,
    coalesce(logoff_time, posl_cas),
    client_ip,
    SVN_CISLO,
    CIS_PUJC,
    verze_verbis,
    mon$attachment_id
from log_uziv
    left join uzivatele uz on log_uziv.fk_uziv = uz.id_uziv
    join def_uziv uz_knih on log_uziv.fk_uziv = uz_knih.fk_uziv
    left join mon$context_variables on id = mon$variable_value
where connected = 1
union
select
    id,
    uz.id_uziv,
    uz.username,
    uz.zobr_jmeno,
    uz_knih.uroven,
    coalesce(login_time, mon$attachments.mon$timestamp),
    coalesce(logoff_time, posl_cas),
    client_ip,
    SVN_CISLO,
    CIS_PUJC,
    verze_verbis,
    mon$attachments.mon$attachment_id as id_pripoj
from mon$attachments
    left join mon$context_variables on mon$attachments.mon$attachment_id = mon$context_variables.mon$attachment_id
    left join log_uziv on id = mon$variable_value
    left join uzivatele uz on log_uziv.fk_uziv = uz.id_uziv
    left join def_uziv uz_knih on log_uziv.fk_uziv = uz_knih.fk_uziv
where mon$user = 'KATALOG' and mon$variable_name = 'LOGIN_SESSION_ID'
^

CREATE OR ALTER VIEW VIEW_EXEMP_UBYTKY(
    ID_EX,
    FK_ZAZ,
    UBYT_PRIRC,
    FK_LOKACE,
    LOKACE,
    FK_VYPKAT,
    VYPKAT,
    FK_TEMSKUP,
    TEMSKUP,
    FK_UBYTEK,
    UBYT_CISLO,
    DATUM_UBYT,
    DUVOD_UBY,
    ZPUS_NAHR,
    CENA_UBY,
    CIS_PORADY,
    DATCAS,
    FK_UZIV,
    ID_UBYTEK,
    FK_PUJC)
AS
select
kat1_5.ID_EX,
kat1_5.FK_ZAZ,
kat1_5.PRIR_CISLO,
kat1_5.FK_LOKACE,
def_lokace.nazev,
kat1_5.FK_VYPKAT,
def_vypkat.popis,
kat1_5.FK_TEMSKUP,
def_temskup.popis,
kat1_5.FK_UBYTEK,
ubytky.ubyt_cislo,
ubytky.datum_ubyt,
ubytky.duvod_uby,
ubytky.zpus_nahr,
ubytky.cena_uby,
ubytky.cis_porady,
kat1_5.DATCAS,
kat1_5.FK_UZIV,
ubytky.id_ubytek,
kat1_5.fk_pujc
from kat1_5 left join vazba on id_ex = fk_ex
            join def_lokace on fk_lokace = id_lokace
            join def_vypkat on fk_vypkat = id_vypkat
            join def_temskup on id_temskup = fk_temskup
            join ubytky on id_ubytek = fk_ubytek
where kat1_5.typ_cisla != 1
^

alter table log_uziv add attachment_id  int_null
^

ALTER TRIGGER AFTER_CONNECT
ACTIVE ON CONNECT POSITION 0
as
declare variable id_row bigint;
declare variable cesta utf_255;
begin

    if (CURRENT_USER = 'KATALOG') then begin

        select MON$REMOTE_PROCESS from mon$attachments where MON$ATTACHMENT_ID = current_connection
            into :cesta;

        insert into log_uziv
          (fk_uziv, id, login_time, logoff_time, connected, client_ip, cesta_k_souboru, attachment_id)
          values
          (0, gen_id(seq_login_user, 1), 'NOW', null, 1, rdb$get_context('SYSTEM', 'CLIENT_ADDRESS'), :cesta, current_connection)
        returning id into :id_row;
        rdb$set_context('USER_SESSION', 'LOGIN_SESSION_ID', :id_row);

    end else begin

      if (CURRENT_USER = 'OPAC') then
      begin

        insert into log_uziv_opac (client_ip, login_time, logoff_time)
          values (rdb$get_context('SYSTEM', 'CLIENT_ADDRESS'), 'NOW', null)
          returning id into :id_row;

        rdb$set_context('USER_SESSION', 'LOGIN_SESSION_ID', :id_row);

      end else begin

        if (CURRENT_USER = 'SQLKPWIN') then begin

          insert into log_uziv_kpwinsql (client_ip, login_time, logoff_time)
            values (rdb$get_context('SYSTEM', 'CLIENT_ADDRESS'), 'NOW', null)
            returning id into :id_row;

          rdb$set_context('USER_SESSION', 'LOGIN_SESSION_ID', :id_row);

        end else begin

          insert into log_uziv_other (client_ip, login_time, logoff_time, user_name)
            values (rdb$get_context('SYSTEM', 'CLIENT_ADDRESS'), 'NOW', null, CURRENT_USER)
            returning id into :id_row;

          rdb$set_context('USER_SESSION', 'LOGIN_SESSION_ID', :id_row);

        end

      end

    end

end
^

ALTER VIEW VIEW_LOG_IN_USERS(
    SESSION_ID,
    UZIV_ID,
    UZIV_JMENO,
    UZIV_TISK,
    UZIV_UROVEN,
    LOGIN_TIME,
    POSL_CAS,
    CLIENT_IP,
    SVN_CISLO,
    CIS_PUJC,
    VERZE_VERBIS,
    ID_PRIPOJ)
AS
select
    id,
    uz.id_uziv,
    uz.username,
    uz.zobr_jmeno,
    uz_knih.uroven,
    login_time,
    coalesce(logoff_time, posl_cas),
    client_ip,
    SVN_CISLO,
    CIS_PUJC,
    verze_verbis,
    mon$attachment_id
from log_uziv
    left join uzivatele uz on log_uziv.fk_uziv = uz.id_uziv
    join def_uziv uz_knih on log_uziv.fk_uziv = uz_knih.fk_uziv
    left join mon$attachments on attachment_id = mon$attachment_id
where connected = 1
union
select
    id,
    uz.id_uziv,
    uz.username,
    uz.zobr_jmeno,
    uz_knih.uroven,
    coalesce(login_time, mon$attachments.mon$timestamp),
    coalesce(logoff_time, posl_cas),
    client_ip,
    SVN_CISLO,
    CIS_PUJC,
    verze_verbis,
    mon$attachments.mon$attachment_id as id_pripoj
from mon$attachments
    left join log_uziv on attachment_id = mon$attachment_id
    left join uzivatele uz on log_uziv.fk_uziv = uz.id_uziv
    left join def_uziv uz_knih on log_uziv.fk_uziv = uz_knih.fk_uziv
where mon$user = 'KATALOG'
^