create or alter procedure SPROC_TISK_KARTY_CTEN (
    CIS_CTEN INT_NONULL = 0)
returns (
    FK_UZIV INT_NULL,
    BLOKOVAN SMALL_NULL,
    BAR_COD STRING_30,
    CIS_LEG STRING_30,
    JMENO UTF_121,
    PRIJMENI UTF_121,
    TITUL STRING_30,
    TRV_MI STRING_255,
    TRV_UL STRING_255,
    TRV_PSC STRING_15,
    PRE_MI STRING_255,
    PRE_UL STRING_255,
    PRE_PSC STRING_15,
    PRE_TISK SMALL_NULL,
    DAT_NAR TYPEDATE,
    ZAMESTNANI STRING_80,
    ADR_ZAM STRING_40,
    VZDELANI STRING_100,
    TRIDA STRING_50,
    DAT_REG TYPEDATE,
    CISOP RODCIS,
    FK_CTENKAT STRING_25,
    POZNAMKA STRING_1000,
    KON_REG TYPEDATE,
    EMAIL STRING_60,
    DATP_REG TYPEDATE,
    SMSCISLO STRING_40,
    TRIDJMENO STRING_60,
    TELEFON STRING_20,
    FK_PUJC SMALL_NULL,
    KOD_STAVU SMALL_PLUSMINUS,
    DAT_OBNOV TYPEDATE,
    BAKALARI STRING_20,
    VZKAZ STRING_1000,
    BLOKOVAN_INTERNET SMALL_NULL,
    TYP_TISK_REZE SMALL_NULL,
    TYP_TISK_UPOM SMALL_NULL,
    OSOBA_GUID STRING_40,
    NET_ID STRING_15,
    NEPOSILAT_PREDUPOM SMALL_NULL,
    NEPOVOLIT_SELFCHECK SMALL_NULL,
    RFID_UID STRING_20,
    OPENID STRING_40,
    NEPOSILAT_EMAIL SMALL_NULL,
    TRV_STAT STRING_100,
    PRE_STAT STRING_100,
    EMAIL_KOPIE STRING_255,
    TITUL_ZA STRING_30,
    EMAIL_ZAKZAST STRING_60,
    VZTAH_UNIV STRING_50,
    FORMA_STUDIA STRING_100,
    FLATJMENO STRING_60,
    ZAKZAST_PRIJMENI UTF_121,
    ZAKZAST_JMENO UTF_121,
    ZAKZAST_MI STRING_255,
    ZAKZAST_UL STRING_255,
    ZAKZAST_PSC STRING_15,
    NAZEV_FIRMY UTF_121,
    OBCH_REJSTRIK STRING_255,
    FUNKCE STRING_100,
    ICO STRING_20,
    DIC STRING_20,
    POC_VYPUC SMALL_NULL,
    POC_REZE SMALL_NULL,
    DLUH BIGMONEY,
    VYPUC_NAZEV UTF_512,
    VYPUC_OD TYPEDATE,
    VYPUC_PROL TYPEDATE,
    VYPUC_DO TYPEDATE,
    VYPUC_CENA BIGMONEY,
    VYPUC_POKUTA STRING_20,
    VYPUC_UPOM_CISLO SMALL_NULL,
    VYPUC_UPOM_DAT_GEN TYPEDATE,
    VYPUC_UPOM_DAT_TISK TYPEDATE,
    DLUHY_TYP STRING_100,
    DLUHY_CASTKA BIGMONEY,
    DLUHY_UHRAZENO BIGMONEY,
    DLUHY_DAT_GEN TYPEDATE,
    DLUHY_DAT_UHR TYPEDATE,
    DLUHY_PRAC_GEN STRING_60,
    DLUHY_PRAC_UHR STRING_60,
    RADEK SMALL_NOTNULL,
    TYP SMALL_NOTNULL,
    PODRADEK SMALL_NOTNULL,
    POZNAMKA_PLATBA STRING_255)
as
declare variable CIS_ZAZ GENERATORY_NULL;
declare variable CIS_VYPUC GENERATORY_NULL;
declare variable CIS_EX GENERATORY_NULL;
declare variable ISS_OZNAC STRING_30;
declare variable ISS_ROKVOL STRING_10;
declare variable CIS_VYPKAT STRING_01;
declare variable CIS_POPL SMALL_NULL;
declare variable CASTKA_PLUS BIGMONEY;
declare variable ISS_INFO UTF_100;
begin

    fk_uziv = null;
    poc_vypuc = 0;
    poc_reze = 0;
    dluh = 0;
    radek = 0;
    typ = 0;
    podradek = 0;
    poznamka_platba = null;

    select
        ctenari.fk_uziv,ctenari.je_blokovan,ctenari.BAR_COD,ctenari.CIS_LEG, DAT_REG, FK_CTENKAT, ctenari.POZNAMKA, KON_REG, DATP_REG, FK_PUJC, KOD_STAVU, DAT_OBNOV, 
        osoby.JMENO,osoby.PRIJMENI,osoby.TITUL,osoby.TITUL_ZA,osoby.DAT_NAR,osoby.ZAMESTNANI,osoby.ADR_ZAM,osoby.VZDELANI,osoby.TRIDA,osoby.CISOP,
        vpk.KOR_MI,vpk.KOR_UL,vpk.KOR_PSC, vpk.kor_stat,
        vpk.EMAIL, vpk.sms, vpk.TELEFON, vpk.email_kopie,
        uzivatele.TRIDJMENO, uzivatele.FLATJMENO, osoby.BAKALARI, ctenari.VZKAZ,
        osoby.BLOKOVAN_INTERNET,TYP_TISK_REZE,TYP_TISK_UPOM,osoby.OSOBA_GUID,osoby.NET_ID,NEPOSILAT_PREDUPOM,NEPOVOLIT_SELFCHECK,
        ctenari.RFID_UID,osoby.OPENID,
        0, --uzivatele.NEPOSILAT_EMAIL,
        vpk.trv_mi, vpk.trv_ul, vpk.trv_psc, vpk.TRV_STAT,
        osoby.VZTAH_UNIV,osoby.FORMA_STUDIA,vpp.prijmeni,vpp.jmeno,vpp.mi, vpp.ul, vpp.psc, vpp.email,
        instituce.nazev, instituce.obch_rejstrik,osoby.FUNKCE,instituce.ico, instituce.dic
    from ctenari
        left join osoby on osoby.fk_uziv = ctenari.fk_uziv
        join uzivatele on uzivatele.id_uziv = ctenari.fk_uziv
        left join view_primarni_kontakty vpk on vpk.fk_uziv = uzivatele.id_uziv
        left join instituce on instituce.fk_uziv = uzivatele.id_uziv
        left join view_primarni_zastupci vpp on uzivatele.id_uziv = vpp.fk_uziv
    where ctenari.fk_uziv = :cis_cten
        into :FK_UZIV,:BLOKOVAN,:BAR_COD,:CIS_LEG, :DAT_REG,:FK_CTENKAT,:POZNAMKA,:KON_REG, :DATP_REG, :FK_PUJC,:KOD_STAVU,:DAT_OBNOV,
            :JMENO,:PRIJMENI,:TITUL,:TITUL_ZA,:DAT_NAR,:ZAMESTNANI,:ADR_ZAM,:VZDELANI,:TRIDA,:CISOP,
            :PRE_MI,:PRE_UL,:PRE_PSC, :PRE_STAT,
            :EMAIL, :SMSCISLO, :TELEFON, :email_kopie,
            :TRIDJMENO,:FLATJMENO,:BAKALARI,:VZKAZ,:BLOKOVAN_INTERNET,
            :TYP_TISK_REZE,:TYP_TISK_UPOM,:OSOBA_GUID,:NET_ID,:NEPOSILAT_PREDUPOM,:NEPOVOLIT_SELFCHECK,:RFID_UID,
            :OPENID,:NEPOSILAT_EMAIL,:TRV_MI, :TRV_UL, :TRV_PSC, :TRV_STAT,:VZTAH_UNIV,:FORMA_STUDIA,
            :ZAKZAST_PRIJMENI,:ZAKZAST_JMENO,:ZAKZAST_MI,:ZAKZAST_UL,:ZAKZAST_PSC,:EMAIL_ZAKZAST,:NAZEV_FIRMY,:OBCH_REJSTRIK,:FUNKCE,:ICO,:DIC;

    select nazev from def_ctenkat where id_ctenkat = :fk_ctenkat into :fk_ctenkat;
    select count(*) from vypuc where fk_uziv_cten = :cis_cten and cis_reze = 0 into :poc_vypuc;
    select count(*) from vypuc where fk_uziv_cten = :cis_cten and cis_reze > 0 into :poc_reze;
    select sum(castka) from (select sum(castka) as castka from platby where fk_uziv_vlastnik = :cis_cten group by platby.fk_popl having sum(castka) < 0) into :dluh;

    if (trv_mi is distinct from pre_mi or trv_ul is distinct from pre_ul ) then
        pre_tisk = 1;

    suspend;
    typ = 1;

    for select fk_zaz, dat_vyp, dat_prol, dat_prol + dob_vyp, fk_vypuc, fk_ex, fk_vypkat, cena from vypuc where fk_uziv_cten = :cis_cten and cis_reze = 0 order by dat_vyp
        into :cis_zaz, :vypuc_od, :vypuc_prol, :vypuc_do, :cis_vypuc, :cis_ex, :cis_vypkat, :vypuc_cena
    do begin

        podradek = 0;
        iss_oznac = null;
        iss_rokvol = null;
        select nazev from kat1_4 where id_zaz = :cis_zaz into :vypuc_nazev;
        select rok_vol, issue from issues join volume on fk_vol = id_vol where fk_ex = :cis_ex into :iss_rokvol, :iss_oznac;
        iss_info = coalesce(iss_oznac || '/' || iss_rokvol || ' - ', '');
        vypuc_nazev = trim(vypuc_nazev);
        vypuc_nazev = iss_info || vypuc_nazev;
        vypuc_pokuta = 0;
        if (current_date > vypuc_do) then
            select pokuta from sproc_spocti_pokutu(:fk_uziv, :vypuc_do, :cis_vypkat) into :vypuc_pokuta;

        vypuc_upom_cislo = null;
        vypuc_upom_dat_gen = null;
        vypuc_upom_dat_tisk = null;
        for select cis_upom, dat_gen, dat_tisk from upominky2 where fk_vypuc = :cis_vypuc order by dat_gen
            into :vypuc_upom_cislo, :vypuc_upom_dat_gen, :vypuc_upom_dat_tisk
        do begin
            suspend;
            podradek = podradek + 1;
        end

        if (vypuc_upom_cislo is null) then
            suspend;

        radek = radek + 1;

    end

    vypuc_od = null;
    vypuc_prol = null;
    vypuc_do = null;
    vypuc_nazev = null;
    vypuc_upom_cislo = null;
    vypuc_upom_dat_gen = null;
    vypuc_upom_dat_tisk = null;
    vypuc_cena = 0;
    radek = 0;
    podradek = 0;
    typ = 2;

    for select id_popl, nazev from def_popl order by id_popl
        into :cis_popl, :dluhy_typ
    do begin
        
        castka_plus = 0;
        dluhy_dat_uhr = null;
        dluhy_castka = 0;
        dluhy_dat_gen = null;
        dluhy_uhrazeno = 0;
        dluhy_prac_gen = '';
        dluhy_prac_uhr = '';

        select sum(castka), max(datum) from platby where fk_uziv_vlastnik = :fk_uziv and fk_popl = :cis_popl and castka > 0 and vraceno is null
            into :castka_plus, :dluhy_dat_uhr;
        select first 1 uzivatele.zobr_jmeno from platby join uzivatele on platby.fk_uziv = uzivatele.id_uziv where platby.fk_uziv_vlastnik = :fk_uziv and fk_popl = :cis_popl and castka > 0 order by datum desc
            into :dluhy_prac_uhr;

        for select (-1) * castka, datum, zobr_jmeno, fk_vypuc, poznamka from platby join uzivatele on platby.fk_uziv = id_uziv
            where platby.fk_uziv_vlastnik = :fk_uziv and fk_popl = :cis_popl and castka < 0 order by datum
            into :dluhy_castka, :dluhy_dat_gen, :dluhy_prac_gen, :cis_vypuc, :poznamka_platba
        do begin
        
            vypuc_od = null;
            vypuc_prol = null;
            vypuc_do = null;
            vypuc_nazev = null;
            
            if (cis_vypuc is not null) THEN
            BEGIN
                select dat_vyp, dat_prol + dob_vyp, dat_vr, nazev from vypuc2 join kat1_4 on vypuc2.FK_ZAZ = id_zaz where id_vypuc = :cis_vypuc
                into :vypuc_od, :vypuc_prol, :vypuc_do, :vypuc_nazev;
            END

            if (castka_plus >= dluhy_castka) then
                castka_plus = castka_plus - dluhy_castka;
            else begin

                if (castka_plus > 0) then begin
                    dluhy_uhrazeno = castka_plus;
                end else begin
                    dluhy_dat_uhr = null;
                    dluhy_prac_uhr = '';
                end
                castka_plus = 0;
                suspend;
                radek = radek + 1;

                dluhy_uhrazeno = 0;
                dluhy_dat_uhr = null;
                dluhy_prac_uhr = '';
                    
            end

        end

    end

    suspend;

end
^
