INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
VALUES (4412, 'cze', 7, 'DEF_PUJC', 'ACTIVATION_DATE', 'Datum aktivace', 5, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, 'TODAY')
^

CREATE OR ALTER VIEW VIEW_VYPUC(
    ID_VYPUC,
    FK_UZIV_CTEN,
    FK_ZAZ,
    FK_EX,
    OZNAC,
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    POC_PROL,
    DOB_VYP,
    CENA,
    DAT_VR,
    FK_TEMSKUP,
    FK_LOKACE,
    FK_KATVYP,
    CIS_UPOM,
    ZPET_KATAL,
    FK_PUJC,
    FK_TYPPUJC,
    DATCAS,
    FK_UZIV,
    PUJCOVNA,
    FK_BUDOVA,
    NAZEV,
    FOND,
    POC_KS,
    DAT_PREDUP,
    DAT_UPOM_GEN,
    DAT_UPOM_TISK,
    ISSUE,
    ROK_VOL,
    VOLUME,
    PRIR_CISLO,
    SIGNATURA,
    BAR_COD,
    POZNAMKA,
    RFID_UID,
    POCET_REZE,
    VALID_PUJC,
    CTENAR)
AS
select
     vypuc.FK_VYPUC,
     vypuc.FK_UZIV_CTEN,
     vypuc.FK_ZAZ,
     vypuc.FK_EX,
     vypuc.OZNAC,
     vypuc.CIS_REZE,
     vypuc.DAT_VYP,
     vypuc.DAT_PROL,
     vypuc.POC_PROL,
     vypuc.DOB_VYP,
     vypuc.CENA,
     vypuc.DAT_PROL + vypuc.DOB_VYP,
     vypuc.FK_TEMSKUP,
     vypuc.FK_LOKACE,
     vypuc.FK_VYPKAT,
     vypuc.CIS_UPOM,
     vypuc.ZPET_KATAL,
     vypuc.FK_PUJC,
     vypuc.FK_TYPPUJC,
     VYPUC.DATCAS,
     VYPUC.FK_UZIV,
     DEF_PUJC.NAZEV,
     DEF_PUJC.FK_BUDOVA,
     KAT1_4.NAZEV,
     KAT1_4.fk_dokfond,
     case fk_typpujc
        when 1 then
            (select sum(zmena) from vypuc_titper where vypuc_titper.fk_vypuc = vypuc.fk_vypuc)
        else NULL
     end,
     VYPUC.dat_predup,
     case
        when cis_upom between 1 and 5 then
            (select first 1 upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc order by dat_gen desc)
        else null
     end,
     case
        when cis_upom between 1 and 5 then
            (select first 1 upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc order by dat_gen desc)
        else null
     end,
    coalesce(issues.issue, kat1_5.rozm_cisel),
    coalesce(volume.rok_vol, kat1_5.rok_vol),
    coalesce(volume.cis_vol, kat1_5.volume),
    kat1_5.PRIR_CISLO,
    kat1_5.SIGNATURA,
    kat1_5.BAR_COD,
    vypuc.Poznamka,
    kat1_5.rfid_uid,
    (select count(*) from vypuc rezervace where rezervace.fk_zaz = kat1_4.id_zaz and rezervace.cis_reze between 1 and 50 and rezervace.fk_ex is null),
    (select pujcovny from poz_rez where poz_rez.fk_vypuc = vypuc.fk_vypuc),
    (select zobr_jmeno from uzivatele where uzivatele.id_uziv = vypuc.fk_uziv_cten)
from vypuc
    left join def_pujc on vypuc.fk_pujc = def_pujc.id_pujc
    left join kat1_4 on kat1_4.id_zaz = vypuc.fk_zaz
    left join issues on vypuc.fk_ex = issues.fk_ex
    left join volume on issues.fk_vol = volume.id_vol
    left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
^

UPDATE OR INSERT INTO DEF_VYKONY (ID_VYKON, POPIS) 
VALUES (27, 'Import fulltextu - formát Kramerius')
^

drop procedure SPROC_UPOMINKY_OD_DO
^

update ini_keys set
  popis = 'Výchozí kategorie čtenáře pro knihovny v aktivní MVS - pokud není nastavena použije program výchozí kategorii pro čtenáře',
  datovy_typ = 'CTEN_KAT' 
where id_klic = 'MVSDEFKATKNIH' and fk_sekce = 'MVS'
^
