/*
 * Decompiled with CFR 0.152.
 */
package asn1;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BEREncoding;
import asn1.BERPrimitive;

public final class ASN1ObjectIdentifier
extends ASN1Any {
    public static final int TAG = 6;
    private int[] oid;

    public ASN1ObjectIdentifier(int[] ai) {
        this.oid = ai;
    }

    public ASN1ObjectIdentifier(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1EncodingException {
        if (flag && (berencoding.tag_get() != 6 || berencoding.tag_type_get() != 0)) {
            throw new ASN1EncodingException("ASN.1 OBJECT IDENTIFIER: bad BER: tag=" + berencoding.tag_get() + " expected 6\n");
        }
        if (!(berencoding instanceof BERPrimitive)) {
            throw new ASN1EncodingException("ASN.1 OBJECT IDENTIFIER: bad form, constructed");
        }
        BERPrimitive berprimitive = (BERPrimitive)berencoding;
        int[] ai = berprimitive.peek();
        if (ai.length < 2) {
            throw new ASN1EncodingException("ASN1 OBJECT IDENTIFER: invalid encoding, length = " + ai.length);
        }
        int i = 2;
        for (int j = 1; j < ai.length; ++j) {
            if ((ai[j] & 0x80) != 0) continue;
            ++i;
        }
        this.oid = new int[i];
        this.oid[0] = ai[0] / 40;
        this.oid[1] = ai[0] % 40;
        int k = 1;
        int l = 2;
        while (l < i) {
            int i1;
            this.oid[l] = 0;
            do {
                i1 = ai[k++];
                int n = l;
                this.oid[n] = this.oid[n] << 7;
                int n2 = l++;
                this.oid[n2] = this.oid[n2] | i1 & 0x7F;
            } while ((i1 & 0x80) != 0);
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 6);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        if (this.oid.length < 2) {
            throw new ASN1Exception("OBJECT IDENTIFIER: less than 2 components, violates X.208");
        }
        if (this.oid[0] < 0 || this.oid[0] > 2) {
            throw new ASN1Exception("OBJECT IDENTIFIER: First component invalid, value = " + this.oid[0]);
        }
        if (this.oid[1] < 0 || this.oid[1] > 39) {
            throw new ASN1Exception("OBJECT IDENTIFIER: Second component invalid, value = " + this.oid[1]);
        }
        int k = 1;
        for (int l = 2; l < this.oid.length; ++l) {
            int i1 = this.oid[l];
            if (i1 < 0) {
                throw new ASN1Exception("OBJECT IDENTIFIER: component " + (l + 1) + " is negative, value = " + i1);
            }
            do {
                ++k;
            } while ((i1 >>= 7) != 0);
        }
        int[] ai = new int[k];
        ai[0] = 40 * this.oid[0] + this.oid[1];
        int j1 = 0;
        for (int k1 = 2; k1 < this.oid.length; ++k1) {
            int l1 = 0;
            int i2 = this.oid[k1];
            do {
                ++l1;
            } while ((i2 >>= 7) != 0);
            i2 = this.oid[k1];
            for (int j2 = l1 - 1; j2 >= 0; --j2) {
                ai[++j1] = i2 >> j2 * 7 & 0x7F;
                if (j2 == 0) continue;
                int n = j1;
                ai[n] = ai[n] | 0x80;
            }
        }
        return new BERPrimitive(i, j, ai);
    }

    public ASN1ObjectIdentifier set(int[] ai) {
        this.oid = ai;
        return this;
    }

    public int[] get() {
        return this.oid;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        for (int i = 0; i < this.oid.length; ++i) {
            if (i != 0) {
                stringbuffer.append('.');
            }
            stringbuffer.append(String.valueOf(this.oid[i]));
        }
        return new String(stringbuffer);
    }
}

