/*
 * Decompiled with CFR 0.152.
 */
package asn1;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BEREncoding;
import asn1.BERPrimitive;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASN1OctetString
extends ASN1Any {
    private static final Logger logger = LoggerFactory.getLogger(ASN1OctetString.class);
    public static final int TAG = 4;
    private static final char[] oct = new char[]{'0', '1', '2', '3', '4', '5', '6', '7'};
    private byte[] octets;

    public ASN1OctetString(byte[] abyte0) {
        this.dekoduj(abyte0, "ASCII");
    }

    private void dekoduj(byte[] abyte0, String encoding) {
        this.octets = abyte0;
    }

    public ASN1OctetString(byte[] abyte0, String encoding) {
        this.dekoduj(abyte0, encoding);
    }

    public ASN1OctetString(String s) {
        try {
            this.octets = s.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("selhani", (Throwable)e);
        }
    }

    public ASN1OctetString(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        this.ber_decode(berencoding, flag, "ASCII");
    }

    public ASN1OctetString(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        this.ber_decode(berencoding, flag, encoding);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag, String encoding) throws ASN1EncodingException {
        if (flag && (berencoding.tag_get() != 4 || berencoding.tag_type_get() != 0)) {
            throw new ASN1EncodingException("ASN.1 OCTET STRING: bad BER: tag=" + berencoding.tag_get() + " expected 4\n");
        }
        if (berencoding instanceof BERPrimitive) {
            BERPrimitive berprimitive = (BERPrimitive)berencoding;
            int[] ai = berprimitive.peek();
            byte[] codes = new byte[ai.length];
            StringBuffer stringbuffer = new StringBuffer(ai.length);
            for (int i = 0; i < ai.length; ++i) {
                stringbuffer.append((char)(ai[i] & 0xFF));
                codes[i] = (byte)(ai[i] & 0xFF);
            }
            try {
                this.octets = codes;
            }
            catch (Exception e) {
                logger.error("nepodporovane kodovani: " + encoding);
                this.octets = codes;
            }
            return;
        }
        throw new ASN1EncodingException("ASN.1 OCTET STRING: decode from constructed NOT IMPLEMENTED YET");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 4);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = this.octets.length;
        int[] ai = new int[k];
        for (int l = 0; l < k; ++l) {
            ai[l] = this.octets[l] & 0xFF;
        }
        return new BERPrimitive(i, j, ai);
    }

    public ASN1OctetString set(byte[] abyte0) {
        this.octets = abyte0;
        return this;
    }

    public ASN1OctetString set(String s) {
        try {
            this.octets = s.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("selhani", (Throwable)e);
        }
        return this;
    }

    public String get() {
        try {
            String ret = new String(this.octets, "ASCII");
            return ret;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("selhani", (Throwable)e);
            return null;
        }
    }

    public String get(String encoding) {
        try {
            String ret = new String(this.octets, encoding);
            return ret;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("selhani", (Throwable)e);
            return null;
        }
    }

    public byte[] get_bytes() {
        return this.octets;
    }

    public String toString() {
        return this.get();
    }
}

