/*
 * Decompiled with CFR 0.152.
 */
package asn1;

import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BERPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BEREncoding {
    public static final int UNIVERSAL_TAG = 0;
    public static final int APPLICATION_TAG = 64;
    public static final int CONTEXT_SPECIFIC_TAG = 128;
    public static final int PRIVATE_TAG = 192;
    private static final int MAX_BER_SIZE = 262144;
    private int[] identifierEncoding;
    protected int i_tag_type;
    protected int i_tag;
    private int[] lengthEncoding;
    protected int i_total_length;

    protected static BEREncoding doInput(InputStream inputstream, int[] ai) throws ASN1Exception, IOException {
        int i1;
        int l;
        int i = inputstream.read();
        if (i < 0) {
            return null;
        }
        ai[0] = ai[0] + 1;
        int k = i & 0xC0;
        boolean flag = false;
        if ((i & 0x20) != 0) {
            flag = true;
        }
        if ((l = i & 0x1F) == 31) {
            l = 0;
            do {
                if ((i = inputstream.read()) < 0) {
                    throw new ASN1EncodingException("Unexpected end in BER encoding");
                }
                ai[0] = ai[0] + 1;
                l <<= 7;
                l |= i & 0x7F;
            } while ((i & 0x80) != 0);
        }
        if ((i = inputstream.read()) < 0) {
            throw new ASN1EncodingException("Unexpected end in BER encoding");
        }
        ai[0] = ai[0] + 1;
        if ((i & 0x80) != 0) {
            if ((i & 0x7F) == 0) {
                i1 = -1;
                if (!flag) {
                    throw new ASN1EncodingException("BER encoding corrupted primitive");
                }
            } else {
                if ((i & 0x7F) > 4) {
                    throw new ASN1EncodingException("BER encoding too long");
                }
                i1 = 0;
                for (int j1 = i & 0x7F; j1 > 0; --j1) {
                    i = inputstream.read();
                    if (i < 0) {
                        throw new ASN1EncodingException("Unexpected end in BER encoding");
                    }
                    ai[0] = ai[0] + 1;
                    i1 <<= 8;
                    i1 |= i & 0xFF;
                }
                if (i1 < 0 || i1 > 262144) {
                    throw new ASN1EncodingException("BER encoding too long");
                }
            }
        } else {
            i1 = i & 0x7F;
        }
        if (!flag) {
            if (i1 < 0) {
                throw new ASN1EncodingException("Indefinite length primitive BER");
            }
            int[] ai1 = new int[i1];
            for (int k1 = 0; k1 < i1; ++k1) {
                int j = inputstream.read();
                if (j < 0) {
                    throw new ASN1EncodingException("Unexpected end in BER encoding");
                }
                ai[0] = ai[0] + 1;
                ai1[k1] = j;
            }
            return new BERPrimitive(k, l, ai1);
        }
        Vector<BEREncoding> vector = new Vector<BEREncoding>(8, 8);
        if (i1 >= 0) {
            int i2;
            for (int l1 = 0; l1 < i1; l1 += ai[0] - i2) {
                i2 = ai[0];
                BEREncoding berencoding1 = BEREncoding.doInput((InputStream)inputstream, (int[])ai);
                if (berencoding1 == null) {
                    throw new ASN1EncodingException("Unexpected end in BER encoding");
                }
                vector.addElement(berencoding1);
            }
        } else {
            while (true) {
                BEREncoding berencoding;
                if ((berencoding = BEREncoding.doInput((InputStream)inputstream, (int[])ai)) == null) {
                    throw new ASN1EncodingException("Unexpected end in BER encoding");
                }
                if (berencoding.i_tag == 0 && berencoding.i_tag_type == 0 && berencoding.i_total_length == 2) break;
                vector.addElement(berencoding);
            }
        }
        int j2 = vector.size();
        BEREncoding[] aberencoding = new BEREncoding[j2];
        for (int k2 = 0; k2 < j2; ++k2) {
            aberencoding[k2] = (BEREncoding)vector.elementAt(k2);
        }
        return new BERConstructed(k, l, aberencoding);
    }

    public byte[] encoding_get() {
        byte[] abyte0 = new byte[this.i_total_length];
        this.i_encoding_get(0, abyte0);
        return abyte0;
    }

    protected abstract int i_encoding_get(int var1, byte[] var2);

    protected int i_get_head(int i, byte[] abyte0) {
        for (int j = 0; j < this.identifierEncoding.length; ++j) {
            abyte0[i++] = (byte)this.identifierEncoding[j];
        }
        for (int k = 0; k < this.lengthEncoding.length; ++k) {
            abyte0[i++] = (byte)this.lengthEncoding[k];
        }
        return i;
    }

    protected void init(int i, boolean flag, int j, int k) throws ASN1Exception {
        this.make_identifier(i, flag, j);
        this.make_length(k);
        this.i_total_length = this.identifierEncoding.length + this.lengthEncoding.length + k;
    }

    public static BEREncoding input(InputStream inputstream) throws ASN1Exception, IOException {
        int[] ai = new int[]{0};
        return BEREncoding.doInput((InputStream)inputstream, (int[])ai);
    }

    private void make_identifier(int i, boolean flag, int j) throws ASN1Exception {
        if ((i & 0xFFFFFF3F) != 0) {
            throw new ASN1Exception("Invalid ASN.1 tag type");
        }
        if (j < 0) {
            throw new ASN1Exception("ASN.1 tag value is negative");
        }
        int k = this.i_tag_type = i & 0xC0;
        if (flag) {
            k |= 0x20;
        }
        this.i_tag = j;
        if (j <= 30) {
            this.identifierEncoding = new int[1];
            this.identifierEncoding[0] = k |= j & 0x1F;
        } else {
            k |= 0x1F;
            int l = 1;
            int i1 = j;
            do {
                ++l;
            } while ((i1 >>= 7) != 0);
            this.identifierEncoding = new int[l];
            this.identifierEncoding[0] = k;
            int j1 = 0;
            for (int k1 = l - 2; k1 >= 0; --k1) {
                this.identifierEncoding[++j1] = j >> k1 * 7 & 0x7F;
                if (k1 == 0) continue;
                int n = j1;
                this.identifierEncoding[n] = this.identifierEncoding[n] | 0x80;
            }
        }
    }

    private void make_length(int i) {
        if (i < 0) {
            this.lengthEncoding = new int[1];
            this.lengthEncoding[0] = 128;
        } else if (i < 128) {
            this.lengthEncoding = new int[1];
            this.lengthEncoding[0] = i;
        } else {
            int j = 0;
            for (int k = i; k != 0; k >>= 8) {
                ++j;
            }
            this.lengthEncoding = new int[j + 1];
            this.lengthEncoding[0] = j | 0x80;
            int l = 0;
            while (j > 0) {
                int i1 = i >> --j * 8 & 0xFF;
                this.lengthEncoding[++l] = i1;
            }
        }
    }

    public abstract void output(OutputStream var1) throws IOException;

    protected void output_bytes(int[] ai, OutputStream outputstream) throws IOException {
        for (int i = 0; i < ai.length; ++i) {
            outputstream.write(ai[i]);
        }
    }

    protected void output_head(OutputStream outputstream) throws IOException {
        this.output_bytes(this.identifierEncoding, outputstream);
        this.output_bytes(this.lengthEncoding, outputstream);
    }

    public int tag_get() {
        return this.i_tag;
    }

    public int tag_type_get() {
        return this.i_tag_type;
    }

    public int total_length() {
        return this.i_total_length;
    }
}

