/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys;

import cz.kpsys.AppServerStatusError;
import cz.kpsys.service.Utils;
import java.util.HashMap;
import java.util.Map;

public class AppServerStatus
extends RuntimeException {
    public static final int MISSING_VALUE = 610;
    public static final int INVALID_STORED_VALUE = 611;
    public static final int NOT_FOUND_IN_DB = 612;
    public static final int INVALID_FOND_NUMBER = 613;
    public static final int INVALID_RECORD_NUMBER = 614;
    public static final int INVALID_INPUT_PARAMETER = 615;
    public static final int ERR1000_REZERVOVANO = 1000;
    public static final int ERR1001_DB_OFFLINE = 1001;
    public static final int ERR1002_INVALID_PORTARO_KEY = 1002;
    private final String message;
    private final int errorCode;
    public Object data;
    final HashMap<String, String> returnedValues = new HashMap();

    public AppServerStatus(String message, int errorCode) {
        this.message = Utils.xmlEscape((String)message);
        this.errorCode = errorCode;
    }

    public AppServerStatus(AppServerStatusError error) {
        this.message = Utils.xmlEscape((String)error.message());
        this.errorCode = error.errorCode();
    }

    public AppServerStatus(String message, int errorCode, Throwable cause) {
        super(cause);
        this.message = Utils.xmlEscape((String)message);
        this.errorCode = errorCode;
    }

    public Map<String, String> getParams() {
        return this.returnedValues;
    }

    public AppServerStatus addReturnValue(String key, String value) {
        this.returnedValues.put(key, value);
        return this;
    }

    @Override
    public String getMessage() {
        return "ERR=" + this.errorCode + ": " + this.message;
    }

    private String formatReturnValues() {
        if (this.returnedValues.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" [");
        boolean first = true;
        for (String key : this.returnedValues.keySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append(key + "=" + (String)this.returnedValues.get(key));
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.errorCode;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppServerStatus other = (AppServerStatus)obj;
        return this.errorCode == other.errorCode;
    }

    public void incrementErrorCodeBy(int increment) throws AppServerStatus {
        throw new AppServerStatus(this.message, this.errorCode + increment);
    }
}

