/*
 * Decompiled with CFR 0.152.
 */
package cz.kpsys.as.commons.repo;

import cz.kpsys.as.commons.repo.WriteDelegatingDmlAppserverService;
import cz.kpsys.db.WriteExecutor;
import cz.kpsys.db.model.WriteInput;
import cz.kpsys.db.query.QueryCollection;
import cz.kpsys.db.query.QueryType;
import cz.kpsys.db.query.ResourceWithSize;
import cz.kpsys.db.query.WriteColumnQueryBuilder;
import cz.kpsys.db.query.WriteQueryBuilder;
import cz.kpsys.db.query.WriteTableQueryBuilder;
import cz.kpsys.marc.SessionData;
import cz.kpsys.portaro.appserver.AppserverAccessException;
import cz.kpsys.portaro.appserver.AppserverErrorResponseException;
import cz.kpsys.portaro.appserver.AppserverInformativeResponseException;
import cz.kpsys.portaro.appserver.AppserverTransferException;
import cz.kpsys.portaro.appserver.dml.BlobCol;
import cz.kpsys.portaro.appserver.dml.Col;
import cz.kpsys.portaro.appserver.dml.DmlAppserverService;
import cz.kpsys.portaro.appserver.dml.ReferringCol;
import cz.kpsys.portaro.appserver.dml.SimpleCol;
import cz.kpsys.portaro.appserver.dml.TableWrite;
import cz.kpsys.portaro.appserver.mapping.AppserverResponseHandler;
import cz.kpsys.portaro.commons.object.Provider;
import cz.kpsys.portaro.department.Department;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class WriteDelegatingDmlAppserverService
implements DmlAppserverService {
    private static final Logger logger = LoggerFactory.getLogger(WriteDelegatingDmlAppserverService.class);
    private final WriteExecutor writeExecutor;
    private final Provider<Integer> suUserIdProvider;
    private final Provider<Department> departmentProvider;

    public WriteDelegatingDmlAppserverService(WriteExecutor writeExecutor, Provider<Integer> suUserIdProvider, Provider<Department> deparmentProvider) {
        this.writeExecutor = Objects.requireNonNull(writeExecutor);
        this.suUserIdProvider = Objects.requireNonNull(suUserIdProvider);
        this.departmentProvider = deparmentProvider;
    }

    public void executeStatement(List<TableWrite> tableWrites) throws AppserverAccessException, AppserverTransferException, AppserverErrorResponseException, AppserverInformativeResponseException {
        WriteQueryBuilder builder = new WriteQueryBuilder();
        tableWrites.forEach(tableWrite -> this.buildWriteTableQuery(builder, tableWrite));
        QueryCollection queryCollection = builder.buildQuery();
        logger.info("Mapped portaro's tableWrites to appserver's queryCollection: {} -> {}", tableWrites, (Object)queryCollection);
        WriteInput writeInput = new WriteInput(queryCollection, new SessionData(((Integer)this.suUserIdProvider.get()).intValue(), ((Integer)((Department)this.departmentProvider.get()).getId()).shortValue()));
        this.writeExecutor.executeWrite(writeInput);
    }

    public <E> E executeStatement(List<TableWrite> list, AppserverResponseHandler<E> appserverResponseHandler) throws AppserverAccessException, AppserverTransferException, AppserverErrorResponseException, AppserverInformativeResponseException {
        throw new UnsupportedOperationException(String.format("Write with custom responseHandler is not supported in %s yet.", this.getClass().getSimpleName()));
    }

    private void buildWriteTableQuery(WriteQueryBuilder builder, TableWrite tableWrite) {
        QueryType queryType = this.mapModeToQueryType(tableWrite);
        WriteTableQueryBuilder tableBuilder = builder.tableBuilder(tableWrite.getTable(), queryType);
        tableWrite.getCols().forEach(col -> this.buildWriteColumnQuery(tableBuilder, col));
        tableBuilder.commit();
    }

    private QueryType mapModeToQueryType(TableWrite tableWrite) {
        switch (1.$SwitchMap$cz$kpsys$portaro$appserver$dml$TableWriteMode[tableWrite.getMode().ordinal()]) {
            case 1: {
                return QueryType.INSERT;
            }
            case 2: {
                return QueryType.UPDATE;
            }
            case 3: {
                return QueryType.INSERT_OR_UPDATE;
            }
            case 4: {
                return QueryType.DELETE;
            }
        }
        throw new UnsupportedOperationException(String.format("Table write mode %s is not supported", tableWrite.getMode()));
    }

    private void buildWriteColumnQuery(WriteTableQueryBuilder tableBuilder, Col col) {
        WriteColumnQueryBuilder columnBuilder = tableBuilder.columnBuilder(col.getName());
        if (col instanceof ReferringCol) {
            this.buildWriteReferringColumnQuery(columnBuilder, (ReferringCol)col);
            return;
        }
        if (col instanceof SimpleCol) {
            this.buildWriteSimpleColumnQuery(columnBuilder, (SimpleCol)col);
            return;
        }
        if (col instanceof BlobCol) {
            this.buildWriteBlobColumnQuery((BlobCol)col, columnBuilder);
            return;
        }
        throw new UnsupportedOperationException(String.format("Column of class %s is not supported (column value: %s)", col.getClass().getSimpleName(), col));
    }

    private void buildWriteBlobColumnQuery(BlobCol col, WriteColumnQueryBuilder columnBuilder) {
        ByteArrayResource dataResource = new ByteArrayResource(col.getData());
        long dataLength = col.getData().length;
        columnBuilder.setResource(new ResourceWithSize((Resource)dataResource, Optional.of(dataLength))).commit();
    }

    private void buildWriteSimpleColumnQuery(WriteColumnQueryBuilder columnBuilder, SimpleCol col) {
        columnBuilder.setPk(col.isInWhere());
        if (col.getValue() == null) {
            columnBuilder.setExplicitNull(true);
        } else {
            columnBuilder.setValue(col.getValue());
        }
        columnBuilder.commit();
    }

    private void buildWriteReferringColumnQuery(WriteColumnQueryBuilder columnBuilder, ReferringCol col) {
        columnBuilder.setMasterColumn(col.getReferredTable() + "." + col.getReferredCol()).setPk(col.isInWhere()).commit();
    }
}

